/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.util;

import com.plotsquared.bukkit.player.BukkitOfflinePlayer;
import com.plotsquared.bukkit.player.BukkitPlayer;
import com.plotsquared.core.player.OfflinePlotPlayer;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.util.EconHandler;
import com.plotsquared.google.Singleton;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.checkerframework.checker.nullness.qual.NonNull;

@Singleton
public class BukkitEconHandler
extends EconHandler {
    private Economy econ;

    private static OfflinePlayer getBukkitOfflinePlayer(PlotPlayer<?> plotPlayer) {
        return ((BukkitPlayer)plotPlayer).player;
    }

    @Override
    public boolean init() {
        if (this.econ == null) {
            this.setupEconomy();
        }
        return this.econ != null;
    }

    private void setupEconomy() {
        if (Bukkit.getServer().getPluginManager().getPlugin("Vault") == null) {
            return;
        }
        RegisteredServiceProvider registeredServiceProvider = Bukkit.getServer().getServicesManager().getRegistration(Economy.class);
        if (registeredServiceProvider != null) {
            this.econ = (Economy)registeredServiceProvider.getProvider();
        }
    }

    @Override
    public double getMoney(PlotPlayer<?> plotPlayer) {
        double d = super.getMoney(plotPlayer);
        if (Double.isNaN(d)) {
            return this.econ.getBalance(BukkitEconHandler.getBukkitOfflinePlayer(plotPlayer));
        }
        return d;
    }

    @Override
    public void withdrawMoney(PlotPlayer<?> plotPlayer, double d) {
        this.econ.withdrawPlayer(BukkitEconHandler.getBukkitOfflinePlayer(plotPlayer), d);
    }

    @Override
    public void depositMoney(PlotPlayer<?> plotPlayer, double d) {
        this.econ.depositPlayer(BukkitEconHandler.getBukkitOfflinePlayer(plotPlayer), d);
    }

    @Override
    public void depositMoney(OfflinePlotPlayer offlinePlotPlayer, double d) {
        this.econ.depositPlayer(((BukkitOfflinePlayer)offlinePlotPlayer).player, d);
    }

    @Override
    public boolean isEnabled(PlotArea plotArea) {
        return plotArea.useEconomy();
    }

    @Override
    public @NonNull String format(double d) {
        return this.econ.format(d);
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public double getBalance(PlotPlayer<?> plotPlayer) {
        return this.econ.getBalance(BukkitEconHandler.getBukkitOfflinePlayer(plotPlayer));
    }
}

