/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.util;

import com.plotsquared.bukkit.player.BukkitPlayer;
import com.plotsquared.bukkit.util.BukkitUtil;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.flag.implementations.AnimalAttackFlag;
import com.plotsquared.core.plot.flag.implementations.AnimalCapFlag;
import com.plotsquared.core.plot.flag.implementations.DoneFlag;
import com.plotsquared.core.plot.flag.implementations.EntityCapFlag;
import com.plotsquared.core.plot.flag.implementations.HangingBreakFlag;
import com.plotsquared.core.plot.flag.implementations.HostileAttackFlag;
import com.plotsquared.core.plot.flag.implementations.HostileCapFlag;
import com.plotsquared.core.plot.flag.implementations.MiscBreakFlag;
import com.plotsquared.core.plot.flag.implementations.MiscCapFlag;
import com.plotsquared.core.plot.flag.implementations.MobCapFlag;
import com.plotsquared.core.plot.flag.implementations.PveFlag;
import com.plotsquared.core.plot.flag.implementations.PvpFlag;
import com.plotsquared.core.plot.flag.implementations.TamedAttackFlag;
import com.plotsquared.core.plot.flag.implementations.VehicleCapFlag;
import com.plotsquared.core.util.EntityUtil;
import com.plotsquared.core.util.entity.EntityCategories;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.registry.Keyed;
import java.util.Objects;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.projectiles.ProjectileSource;

public class BukkitEntityUtil {
    public static final com.sk89q.worldedit.world.entity.EntityType FAKE_ENTITY_TYPE = new com.sk89q.worldedit.world.entity.EntityType("plotsquared:fake");

    public static boolean entityDamage(Entity entity, Entity entity2) {
        return BukkitEntityUtil.entityDamage(entity, entity2, null);
    }

    public static boolean entityDamage(Entity entity, Entity entity2, EntityDamageEvent.DamageCause damageCause) {
        ProjectileSource projectileSource;
        Object object;
        Player player;
        PlotArea plotArea;
        String string;
        Plot plot;
        Location location = BukkitUtil.adapt(entity.getLocation());
        Location location2 = BukkitUtil.adapt(entity2.getLocation());
        PlotArea plotArea2 = location.getPlotArea();
        PlotArea plotArea3 = plotArea2 != null && plotArea2.contains(location2.getX(), location2.getZ()) ? plotArea2 : location2.getPlotArea();
        if (plotArea2 == null && plotArea3 == null) {
            return true;
        }
        Plot plot2 = plotArea2 != null ? plotArea2.getPlot(location) : null;
        Plot plot3 = plotArea3 != null ? plotArea3.getPlot(location2) : null;
        boolean bl = true;
        if (plot2 == null && plot3 == null) {
            if (plotArea2 == null) {
                return true;
            }
            plot = null;
            string = "road";
            bl = false;
        } else {
            plot = entity2.getTicksLived() > entity.getTicksLived() ? (plot2 == null || !(entity2 instanceof Player) ? (plot3 == null ? plot2 : plot3) : plot2) : (plot2 == null || !(entity2 instanceof Player) ? (plot3 == null ? plot2 : plot3) : (plot3 == null ? plot2 : plot3));
            string = plot.hasOwner() ? "other" : "unowned";
        }
        boolean bl2 = plotArea3 != null ? plotArea3.isRoadFlags() : plotArea2.isRoadFlags();
        PlotArea plotArea4 = plotArea = plotArea3 != null ? plotArea3 : plotArea2;
        if (entity instanceof Player) {
            player = (Player)entity;
        } else if (entity instanceof Projectile) {
            object = (Projectile)entity;
            projectileSource = object.getShooter();
            if (projectileSource instanceof Player) {
                player = (Player)projectileSource;
            } else {
                if (projectileSource instanceof BlockProjectileSource) {
                    Location location3 = BukkitUtil.adapt(((BlockProjectileSource)projectileSource).getBlock().getLocation());
                    plot2 = plotArea2.getPlot(location3);
                }
                player = null;
            }
        } else {
            player = null;
        }
        if (player != null) {
            object = BukkitUtil.adapt(player);
            projectileSource = entity2.getType().getName() == null ? FAKE_ENTITY_TYPE : BukkitAdapter.adapt((EntityType)entity2.getType());
            if (EntityCategories.HANGING.contains((Keyed)projectileSource)) {
                if (plot != null && (((Boolean)plot.getFlag(HangingBreakFlag.class)).booleanValue() || plot.isAdded(((BukkitPlayer)object).getUUID()))) {
                    if (Settings.Done.RESTRICT_BUILDING && DoneFlag.isDone(plot) && !object.hasPermission(Permission.PERMISSION_ADMIN_BUILD_OTHER)) {
                        ((PlotPlayer)object).sendMessage((Caption)TranslatableCaption.of("done.building_restricted"), new TagResolver[0]);
                        return false;
                    }
                    return true;
                }
                if (!((PlotPlayer)object).hasPermission(Permission.PERMISSION_ADMIN_DESTROY + "." + string)) {
                    ((PlotPlayer)object).sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", Tag.inserting(Component.text(Permission.PERMISSION_ADMIN_DESTROY + "." + string))));
                    return false;
                }
            } else if (entity2.getType() == EntityType.ARMOR_STAND) {
                if (plot != null && (((Boolean)plot.getFlag(MiscBreakFlag.class)).booleanValue() || plot.isAdded(((BukkitPlayer)object).getUUID()))) {
                    return true;
                }
                if (!((PlotPlayer)object).hasPermission(Permission.PERMISSION_ADMIN_DESTROY + "." + string)) {
                    ((PlotPlayer)object).sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", Tag.inserting(Component.text(Permission.PERMISSION_ADMIN_DESTROY + "." + string))));
                    if (plot != null) {
                        plot.debug(player.getName() + " could not break armor stand because misc-break = false");
                    }
                    return false;
                }
            } else if (EntityCategories.HOSTILE.contains((Keyed)projectileSource)) {
                if (bl ? (Boolean)plot.getFlag(HostileAttackFlag.class) != false || (Boolean)plot.getFlag(PveFlag.class) != false || plot.isAdded(((BukkitPlayer)object).getUUID()) : bl2 && ((Boolean)plotArea.getRoadFlag(HostileAttackFlag.class) != false || (Boolean)plotArea.getFlag(PveFlag.class) != false)) {
                    return true;
                }
                if (!((PlotPlayer)object).hasPermission(Permission.PERMISSION_ADMIN_PVE + "." + string)) {
                    ((PlotPlayer)object).sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", Tag.inserting(Component.text(Permission.PERMISSION_ADMIN_PVE + "." + string))));
                    if (plot != null) {
                        plot.debug(player.getName() + " could not attack " + (com.sk89q.worldedit.world.entity.EntityType)projectileSource + " because pve = false OR hostile-attack = false");
                    }
                    return false;
                }
            } else if (EntityCategories.TAMEABLE.contains((Keyed)projectileSource)) {
                if (bl ? (Boolean)plot.getFlag(TamedAttackFlag.class) != false || (Boolean)plot.getFlag(PveFlag.class) != false || plot.isAdded(((BukkitPlayer)object).getUUID()) : bl2 && ((Boolean)plotArea.getRoadFlag(TamedAttackFlag.class) != false || (Boolean)plotArea.getFlag(PveFlag.class) != false)) {
                    return true;
                }
                if (!((PlotPlayer)object).hasPermission(Permission.PERMISSION_ADMIN_PVE + "." + string)) {
                    ((PlotPlayer)object).sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", Tag.inserting(Component.text(Permission.PERMISSION_ADMIN_PVE + "." + string))));
                    if (plot != null) {
                        plot.debug(player.getName() + " could not attack " + (com.sk89q.worldedit.world.entity.EntityType)projectileSource + " because pve = false OR tamed-attack = false");
                    }
                    return false;
                }
            } else if (EntityCategories.PLAYER.contains((Keyed)projectileSource)) {
                if (bl) {
                    if (!((Boolean)plot.getFlag(PvpFlag.class)).booleanValue() && !((PlotPlayer)object).hasPermission(Permission.PERMISSION_ADMIN_PVP + "." + string)) {
                        ((PlotPlayer)object).sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", Tag.inserting(Component.text(Permission.PERMISSION_ADMIN_PVP + "." + string))));
                        plot.debug(player.getName() + " could not attack " + (com.sk89q.worldedit.world.entity.EntityType)projectileSource + " because pve = false");
                        return false;
                    }
                    return true;
                }
                if (bl2 && ((Boolean)plotArea.getRoadFlag(PvpFlag.class)).booleanValue()) {
                    return true;
                }
                if (!((PlotPlayer)object).hasPermission(Permission.PERMISSION_ADMIN_PVP + "." + string)) {
                    ((PlotPlayer)object).sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", Tag.inserting(Component.text(Permission.PERMISSION_ADMIN_PVP + "." + string))));
                    return false;
                }
            } else if (EntityCategories.ANIMAL.contains((Keyed)projectileSource)) {
                if (bl ? (Boolean)plot.getFlag(AnimalAttackFlag.class) != false || (Boolean)plot.getFlag(PveFlag.class) != false || plot.isAdded(((BukkitPlayer)object).getUUID()) : bl2 && ((Boolean)plotArea.getRoadFlag(AnimalAttackFlag.class) != false || (Boolean)plotArea.getFlag(PveFlag.class) != false)) {
                    return true;
                }
                if (!((PlotPlayer)object).hasPermission(Permission.PERMISSION_ADMIN_PVE + "." + string)) {
                    ((PlotPlayer)object).sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", Tag.inserting(Component.text(Permission.PERMISSION_ADMIN_PVE + "." + string))));
                    if (plot != null) {
                        plot.debug(player.getName() + " could not attack " + (com.sk89q.worldedit.world.entity.EntityType)projectileSource + " because pve = false OR animal-attack = false");
                    }
                    return false;
                }
            } else {
                if (EntityCategories.VEHICLE.contains((Keyed)projectileSource)) {
                    return true;
                }
                if (bl ? (Boolean)plot.getFlag(PveFlag.class) != false || plot.isAdded(((BukkitPlayer)object).getUUID()) : bl2 && (Boolean)plotArea.getRoadFlag(PveFlag.class) != false) {
                    return true;
                }
                if (!((PlotPlayer)object).hasPermission(Permission.PERMISSION_ADMIN_PVE + "." + string)) {
                    ((PlotPlayer)object).sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", Tag.inserting(Component.text(Permission.PERMISSION_ADMIN_PVE + "." + string))));
                    if (plot != null) {
                        plot.debug(player.getName() + " could not attack " + (com.sk89q.worldedit.world.entity.EntityType)projectileSource + " because pve = false");
                    }
                    return false;
                }
            }
            return true;
        }
        if (plot2 != null && (!plot2.equals(plot3) || Objects.equals(plot2.getOwnerAbs(), plot3.getOwnerAbs()))) {
            return plot3 != null && (Boolean)plot3.getFlag(PveFlag.class) != false;
        }
        if (plot3 != null && EntityDamageEvent.DamageCause.ENTITY_EXPLOSION == damageCause && entity.getType() == EntityType.FIREWORK) {
            return false;
        }
        if (plot3 == null && bl2 && ((Boolean)plotArea.getRoadFlag(PveFlag.class)).booleanValue()) {
            return true;
        }
        return plot3 != null && (Boolean)plot3.getFlag(PveFlag.class) != false || !(entity instanceof Arrow) || entity2 instanceof Creature;
    }

    public static boolean checkEntity(Entity entity, Plot plot) {
        if (plot == null || !plot.hasOwner() || plot.getFlags().isEmpty() && plot.getArea().getFlagContainer().getFlagMap().isEmpty()) {
            return false;
        }
        com.sk89q.worldedit.world.entity.EntityType entityType = BukkitAdapter.adapt((EntityType)entity.getType());
        if (EntityCategories.PLAYER.contains((Keyed)entityType)) {
            return false;
        }
        if (EntityCategories.PROJECTILE.contains((Keyed)entityType) || EntityCategories.OTHER.contains((Keyed)entityType) || EntityCategories.HANGING.contains((Keyed)entityType)) {
            return EntityUtil.checkEntity(plot, EntityCapFlag.ENTITY_CAP_UNLIMITED, MiscCapFlag.MISC_CAP_UNLIMITED);
        }
        if (EntityCategories.ANIMAL.contains((Keyed)entityType) || EntityCategories.VILLAGER.contains((Keyed)entityType) || EntityCategories.TAMEABLE.contains((Keyed)entityType)) {
            return EntityUtil.checkEntity(plot, EntityCapFlag.ENTITY_CAP_UNLIMITED, MobCapFlag.MOB_CAP_UNLIMITED, AnimalCapFlag.ANIMAL_CAP_UNLIMITED);
        }
        if (EntityCategories.HOSTILE.contains((Keyed)entityType)) {
            return EntityUtil.checkEntity(plot, EntityCapFlag.ENTITY_CAP_UNLIMITED, MobCapFlag.MOB_CAP_UNLIMITED, HostileCapFlag.HOSTILE_CAP_UNLIMITED);
        }
        if (EntityCategories.VEHICLE.contains((Keyed)entityType)) {
            return EntityUtil.checkEntity(plot, EntityCapFlag.ENTITY_CAP_UNLIMITED, VehicleCapFlag.VEHICLE_CAP_UNLIMITED);
        }
        return EntityUtil.checkEntity(plot, EntityCapFlag.ENTITY_CAP_UNLIMITED);
    }
}

