/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.util;

import com.google.common.collect.Maps;
import com.plotsquared.core.location.World;
import java.util.Map;
import org.bukkit.Bukkit;
import org.checkerframework.checker.nullness.qual.NonNull;

public class BukkitWorld
implements World<org.bukkit.World> {
    private static final Map<String, BukkitWorld> worldMap;
    private static final boolean HAS_MIN_Y;
    private final org.bukkit.World world;

    private BukkitWorld(org.bukkit.World world) {
        this.world = world;
    }

    public static @NonNull BukkitWorld of(@NonNull String string) {
        org.bukkit.World world = Bukkit.getWorld((String)string);
        if (world == null) {
            throw new IllegalArgumentException(String.format("There is no world with the name '%s'", string));
        }
        return BukkitWorld.of(world);
    }

    public static @NonNull BukkitWorld of(org.bukkit.World world) {
        BukkitWorld bukkitWorld = worldMap.get(world.getName());
        if (bukkitWorld != null && bukkitWorld.getPlatformWorld().equals(world)) {
            return bukkitWorld;
        }
        bukkitWorld = new BukkitWorld(world);
        worldMap.put(world.getName(), bukkitWorld);
        return bukkitWorld;
    }

    public static int getMinWorldHeight(org.bukkit.World world) {
        return HAS_MIN_Y ? world.getMinHeight() : 0;
    }

    public static int getMaxWorldHeight(org.bukkit.World world) {
        return HAS_MIN_Y ? world.getMaxHeight() : 256;
    }

    @Override
    public org.bukkit.World getPlatformWorld() {
        return this.world;
    }

    @Override
    public @NonNull String getName() {
        return this.world.getName();
    }

    @Override
    public int getMinHeight() {
        return BukkitWorld.getMinWorldHeight(this.world);
    }

    @Override
    public int getMaxHeight() {
        return BukkitWorld.getMaxWorldHeight(this.world) - 1;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BukkitWorld bukkitWorld = (BukkitWorld)object;
        return this.world.equals(bukkitWorld.world);
    }

    public int hashCode() {
        return this.world.hashCode();
    }

    public String toString() {
        return "BukkitWorld(world=" + this.world + ")";
    }

    static {
        boolean bl;
        worldMap = Maps.newHashMap();
        try {
            org.bukkit.World.class.getMethod("getMinHeight", new Class[0]);
            bl = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            bl = false;
        }
        HAS_MIN_Y = bl;
    }
}

