/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.util;

import com.plotsquared.bukkit.entity.EntityWrapper;
import com.plotsquared.bukkit.entity.ReplicatingEntityWrapper;
import com.plotsquared.bukkit.util.BukkitChunkManager;
import com.plotsquared.bukkit.util.BukkitUtil;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.location.PlotLoc;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.world.block.BaseBlock;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class ContentMap {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + ContentMap.class.getSimpleName()));
    final Set<EntityWrapper> entities = new HashSet<EntityWrapper>();
    final Map<PlotLoc, BaseBlock[]> allBlocks = new HashMap<PlotLoc, BaseBlock[]>();

    ContentMap() {
    }

    public void saveRegion(BukkitWorld bukkitWorld, int n, int n2, int n3, int n4) {
        int n5;
        if (n3 > n4) {
            n5 = n3;
            n3 = n4;
            n4 = n5;
        }
        if (n > n2) {
            n5 = n;
            n = n2;
            n2 = n5;
        }
        for (n5 = n; n5 <= n2; ++n5) {
            for (int i = n3; i <= n4; ++i) {
                this.saveBlocks(bukkitWorld, n5, i);
            }
        }
    }

    void saveEntitiesOut(Chunk chunk, CuboidRegion cuboidRegion) {
        for (Entity entity : chunk.getEntities()) {
            int n;
            Location location = BukkitUtil.adapt(entity.getLocation());
            int n2 = location.getX();
            if (BukkitChunkManager.isIn(cuboidRegion, n2, n = location.getZ()) || entity.getVehicle() != null) continue;
            ReplicatingEntityWrapper replicatingEntityWrapper = new ReplicatingEntityWrapper(entity, 2);
            ((EntityWrapper)replicatingEntityWrapper).saveEntity();
            this.entities.add(replicatingEntityWrapper);
        }
    }

    void saveEntitiesIn(Chunk chunk, CuboidRegion cuboidRegion, boolean bl) {
        for (Entity entity : chunk.getEntities()) {
            int n;
            Location location = BukkitUtil.adapt(entity.getLocation());
            int n2 = location.getX();
            if (!BukkitChunkManager.isIn(cuboidRegion, n2, n = location.getZ()) || entity.getVehicle() != null) continue;
            ReplicatingEntityWrapper replicatingEntityWrapper = new ReplicatingEntityWrapper(entity, 2);
            ((EntityWrapper)replicatingEntityWrapper).saveEntity();
            this.entities.add(replicatingEntityWrapper);
            if (!bl || entity instanceof Player) continue;
            entity.remove();
        }
    }

    void restoreEntities(World world) {
        for (EntityWrapper entityWrapper : this.entities) {
            try {
                entityWrapper.spawn(world, 0, 0);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to restore entity", (Throwable)exception);
            }
        }
        this.entities.clear();
    }

    private void saveBlocks(BukkitWorld bukkitWorld, int n, int n2) {
        BaseBlock[] baseBlockArray = new BaseBlock[bukkitWorld.getMaxY() - bukkitWorld.getMinY() + 1];
        for (int n3 = 0; n3 <= bukkitWorld.getMaxY() - bukkitWorld.getMinY(); n3 = (int)((short)(n3 + 1))) {
            BaseBlock baseBlock;
            baseBlockArray[n3] = baseBlock = bukkitWorld.getFullBlock(BlockVector3.at((int)n, (int)(n3 + bukkitWorld.getMinY()), (int)n2));
        }
        PlotLoc plotLoc = new PlotLoc(n, n2);
        this.allBlocks.put(plotLoc, baseBlockArray);
    }
}

