/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.util.task;

import com.plotsquared.bukkit.BukkitPlatform;
import com.plotsquared.bukkit.util.task.BukkitPlotSquaredTask;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.util.task.PlotSquaredTask;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.core.util.task.TaskTime;
import com.plotsquared.google.Inject;
import com.plotsquared.google.Singleton;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.checkerframework.checker.nullness.qual.NonNull;

@Singleton
public class BukkitTaskManager
extends TaskManager {
    private final BukkitPlatform bukkitMain;
    private final TaskTime.TimeConverter timeConverter;

    @Inject
    public BukkitTaskManager(@NonNull BukkitPlatform bukkitPlatform, @NonNull TaskTime.TimeConverter timeConverter) {
        this.bukkitMain = bukkitPlatform;
        this.timeConverter = timeConverter;
    }

    @Override
    public PlotSquaredTask taskRepeat(@NonNull Runnable runnable, @NonNull TaskTime taskTime) {
        long l = this.timeConverter.toTicks(taskTime);
        BukkitPlotSquaredTask bukkitPlotSquaredTask = new BukkitPlotSquaredTask(runnable);
        bukkitPlotSquaredTask.runTaskTimer((Plugin)this.bukkitMain, l, l);
        return bukkitPlotSquaredTask;
    }

    @Override
    public PlotSquaredTask taskRepeatAsync(@NonNull Runnable runnable, @NonNull TaskTime taskTime) {
        long l = this.timeConverter.toTicks(taskTime);
        BukkitPlotSquaredTask bukkitPlotSquaredTask = new BukkitPlotSquaredTask(runnable);
        bukkitPlotSquaredTask.runTaskTimerAsynchronously((Plugin)this.bukkitMain, l, l);
        return bukkitPlotSquaredTask;
    }

    @Override
    public void taskAsync(@NonNull Runnable runnable) {
        if (this.bukkitMain.isEnabled()) {
            new BukkitPlotSquaredTask(runnable).runTaskAsynchronously((Plugin)this.bukkitMain);
        } else {
            runnable.run();
        }
    }

    @Override
    public <T> T sync(@NonNull Callable<T> callable, int n) {
        if (PlotSquared.get().isMainThread(Thread.currentThread())) {
            return callable.call();
        }
        return this.callMethodSync(callable).get(n, TimeUnit.MILLISECONDS);
    }

    @Override
    public <T> Future<T> callMethodSync(@NonNull Callable<T> callable) {
        return Bukkit.getScheduler().callSyncMethod((Plugin)this.bukkitMain, callable);
    }

    @Override
    public void task(@NonNull Runnable runnable) {
        new BukkitPlotSquaredTask(runnable).runTask((Plugin)this.bukkitMain);
    }

    @Override
    public void taskLater(@NonNull Runnable runnable, @NonNull TaskTime taskTime) {
        long l = this.timeConverter.toTicks(taskTime);
        new BukkitPlotSquaredTask(runnable).runTaskLater((Plugin)this.bukkitMain, l);
    }

    @Override
    public void taskLaterAsync(@NonNull Runnable runnable, @NonNull TaskTime taskTime) {
        long l = this.timeConverter.toTicks(taskTime);
        new BukkitPlotSquaredTask(runnable).runTaskLaterAsynchronously((Plugin)this.bukkitMain, l);
    }
}

