/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.uuid;

import com.plotsquared.core.uuid.UUIDMapping;
import com.plotsquared.core.uuid.UUIDService;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.model.user.UserManager;
import org.bukkit.Bukkit;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.checkerframework.checker.nullness.qual.NonNull;

public class LuckPermsUUIDService
implements UUIDService {
    private final LuckPerms luckPerms;

    public LuckPermsUUIDService() {
        RegisteredServiceProvider registeredServiceProvider = Bukkit.getServicesManager().getRegistration(LuckPerms.class);
        if (registeredServiceProvider == null) {
            throw new IllegalStateException("LuckPerms not available");
        }
        this.luckPerms = (LuckPerms)registeredServiceProvider.getProvider();
    }

    @Override
    public @NonNull List<UUIDMapping> getNames(@NonNull List<UUID> list) {
        ArrayList<UUIDMapping> arrayList = new ArrayList<UUIDMapping>(list.size());
        UserManager userManager = this.luckPerms.getUserManager();
        for (UUID uUID : list) {
            try {
                String string = (String)userManager.lookupUsername(uUID).get();
                if (string == null) continue;
                arrayList.add(new UUIDMapping(uUID, string));
            }
            catch (Exception exception) {}
        }
        return arrayList;
    }

    @Override
    public @NonNull List<UUIDMapping> getUUIDs(@NonNull List<String> list) {
        ArrayList<UUIDMapping> arrayList = new ArrayList<UUIDMapping>(list.size());
        UserManager userManager = this.luckPerms.getUserManager();
        for (String string : list) {
            try {
                UUID uUID = (UUID)userManager.lookupUniqueId(string).get();
                if (string == null) continue;
                arrayList.add(new UUIDMapping(uUID, string));
            }
            catch (Exception exception) {}
        }
        return arrayList;
    }
}

