/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.StaticCaption;
import com.plotsquared.core.player.ConsolePlayer;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.queue.GlobalBlockQueue;
import com.plotsquared.core.util.ChunkManager;
import com.plotsquared.core.util.SchematicHandler;
import com.plotsquared.core.util.query.PlotQuery;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PlotAPI {
    public @NonNull Set<@NonNull Plot> getAllPlots() {
        return PlotQuery.newQuery().allPlots().asSet();
    }

    public @NonNull Set<@NonNull Plot> getPlayerPlots(@NonNull PlotPlayer<?> plotPlayer) {
        return PlotQuery.newQuery().ownedBy(plotPlayer).asSet();
    }

    public void addPlotArea(@NonNull PlotArea plotArea) {
        PlotSquared.get().addPlotArea(plotArea);
    }

    public @NonNull ChunkManager getChunkManager() {
        return PlotSquared.platform().injector().getInstance(ChunkManager.class);
    }

    public @NonNull GlobalBlockQueue getBlockQueue() {
        return PlotSquared.platform().globalBlockQueue();
    }

    public @NonNull SchematicHandler getSchematicHandler() {
        return PlotSquared.platform().injector().getInstance(SchematicHandler.class);
    }

    public @NonNull Set<@NonNull PlotArea> getPlotAreas(@Nullable String string) {
        if (string == null) {
            return Collections.emptySet();
        }
        return PlotSquared.get().getPlotAreaManager().getPlotAreasSet(string);
    }

    public void sendConsoleMessage(@NonNull String string, TagResolver ... tagResolverArray) {
        ConsolePlayer.getConsole().sendMessage((Caption)StaticCaption.of(string), tagResolverArray);
    }

    public void sendConsoleMessage(@NonNull Caption caption, TagResolver ... tagResolverArray) {
        ConsolePlayer.getConsole().sendMessage(caption, tagResolverArray);
    }

    public @NonNull PlotSquared getPlotSquared() {
        return PlotSquared.get();
    }

    public @Nullable PlotPlayer<?> wrapPlayer(@NonNull UUID uUID) {
        return PlotSquared.platform().playerManager().getPlayerIfExists(uUID);
    }

    public @Nullable PlotPlayer<?> wrapPlayer(@NonNull String string) {
        return PlotSquared.platform().playerManager().getPlayerIfExists(string);
    }

    public void registerListener(@NonNull Object object) {
        PlotSquared.get().getEventDispatcher().registerListener(object);
    }
}

