/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.collection;

import com.plotsquared.core.util.RegionUtil;
import com.sk89q.worldedit.regions.CuboidRegion;
import java.util.HashSet;
import java.util.Set;

public class QuadMap<T> {
    public final int size;
    public final int x;
    public final int z;
    private final int newsize;
    private final int min;
    public HashSet<T> objects;
    public QuadMap<T> one;
    public QuadMap<T> two;
    public QuadMap<T> three;
    public QuadMap<T> four;
    public QuadMap<T> skip;

    public QuadMap(int n, int n2, int n3) {
        this.size = n;
        this.x = n2;
        this.z = n3;
        this.newsize = n >> 1;
        this.min = 512;
    }

    public QuadMap(int n, int n2, int n3, int n4) {
        this.size = n;
        this.x = n2;
        this.z = n3;
        this.newsize = n >> 1;
        this.min = n4;
    }

    public int count() {
        int n = this.countBelow();
        if (this.objects != null) {
            n += this.objects.size();
        }
        return n;
    }

    public Set<T> getAll() {
        HashSet<T> hashSet = new HashSet<T>();
        if (this.objects != null) {
            hashSet.addAll(this.objects);
        }
        if (this.skip != null) {
            hashSet.addAll(this.skip.getAll());
            return hashSet;
        }
        if (this.one != null) {
            hashSet.addAll(this.one.getAll());
        }
        if (this.two != null) {
            hashSet.addAll(this.two.getAll());
        }
        if (this.three != null) {
            hashSet.addAll(this.three.getAll());
        }
        if (this.four != null) {
            hashSet.addAll(this.four.getAll());
        }
        return hashSet;
    }

    public int countCurrent() {
        return this.objects == null ? 0 : this.objects.size();
    }

    public int countBelow() {
        int n = 0;
        if (this.one != null) {
            n += this.one.count();
        }
        if (this.two != null) {
            n += this.two.count();
        }
        if (this.three != null) {
            n += this.three.count();
        }
        if (this.four != null) {
            n += this.four.count();
        }
        return n;
    }

    public void add(T t) {
        if (this.size <= this.min) {
            if (this.objects == null) {
                this.objects = new HashSet();
            }
            this.objects.add(t);
            return;
        }
        CuboidRegion cuboidRegion = this.getRegion(t);
        if (cuboidRegion.getMinimumPoint().getX() >= this.x) {
            if (cuboidRegion.getMinimumPoint().getZ() >= this.z) {
                if (this.one == null) {
                    this.one = this.newInstance(this.newsize, this.x + this.newsize, this.z + this.newsize, this.min);
                }
                this.one.add(t);
                this.recalculateSkip();
                return;
            }
            if (cuboidRegion.getMaximumPoint().getZ() < this.z) {
                if (this.two == null) {
                    this.two = this.newInstance(this.newsize, this.x + this.newsize, this.z - this.newsize, this.min);
                }
                this.two.add(t);
                this.recalculateSkip();
                return;
            }
        } else if (cuboidRegion.getMaximumPoint().getX() < this.x) {
            if (cuboidRegion.getMinimumPoint().getZ() >= this.z) {
                if (this.four == null) {
                    this.four = this.newInstance(this.newsize, this.x - this.newsize, this.z + this.newsize, this.min);
                }
                this.four.add(t);
                this.recalculateSkip();
                return;
            }
            if (cuboidRegion.getMaximumPoint().getZ() < this.z) {
                if (this.three == null) {
                    this.three = this.newInstance(this.newsize, this.x - this.newsize, this.z - this.newsize, this.min);
                }
                this.three.add(t);
                this.recalculateSkip();
                return;
            }
        }
        if (this.objects == null) {
            this.objects = new HashSet();
        }
        this.objects.add(t);
    }

    public CuboidRegion getRegion(T t) {
        return null;
    }

    public QuadMap<T> newInstance(int n, int n2, int n3, int n4) {
        try {
            return new QuadMap<T>(n, n2, n3, n4){

                @Override
                public CuboidRegion getRegion(T t) {
                    return QuadMap.this.getRegion(t);
                }
            };
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public boolean remove(T t) {
        if (this.objects != null && this.objects.remove(t)) {
            return this.objects.isEmpty();
        }
        if (this.skip != null) {
            if (this.skip.remove(t)) {
                this.skip = null;
            }
        } else {
            CuboidRegion cuboidRegion = this.getRegion(t);
            if (cuboidRegion.getMinimumPoint().getX() >= this.x) {
                if (cuboidRegion.getMinimumPoint().getZ() >= this.z) {
                    if (this.one != null) {
                        if (this.one.remove(t)) {
                            this.one = null;
                        }
                        return this.countCurrent() == 0;
                    }
                } else if (this.two != null) {
                    if (this.two.remove(t)) {
                        this.two = null;
                    }
                    return this.countCurrent() == 0;
                }
            } else if (cuboidRegion.getMinimumPoint().getZ() >= this.z) {
                if (this.four != null) {
                    if (this.four.remove(t)) {
                        this.four = null;
                    }
                    return this.countCurrent() == 0;
                }
            } else if (this.three != null) {
                if (this.three.remove(t)) {
                    this.three = null;
                }
                return this.countCurrent() == 0;
            }
        }
        return false;
    }

    public void recalculateSkip() {
        QuadMap quadMap = null;
        for (QuadMap quadMap2 : new QuadMap[]{this.one, this.two, this.three, this.four}) {
            if (quadMap2 == null) continue;
            if (quadMap != null) {
                this.skip = null;
                return;
            }
            quadMap = quadMap2;
        }
        this.skip = quadMap.skip == null ? quadMap : quadMap.skip;
    }

    public Set<T> get(CuboidRegion cuboidRegion) {
        HashSet<T> hashSet = new HashSet<T>();
        if (this.objects != null) {
            for (T t : this.objects) {
                if (!RegionUtil.intersects(this.getRegion(t), cuboidRegion)) continue;
                hashSet.add(t);
            }
        }
        if (this.skip != null) {
            if (this.skip.intersects(cuboidRegion)) {
                hashSet.addAll(this.skip.get(cuboidRegion));
            }
        } else {
            if (this.one != null && this.one.intersects(cuboidRegion)) {
                hashSet.addAll(this.one.get(cuboidRegion));
            }
            if (this.two != null && this.two.intersects(cuboidRegion)) {
                hashSet.addAll(this.two.get(cuboidRegion));
            }
            if (this.three != null && this.three.intersects(cuboidRegion)) {
                hashSet.addAll(this.three.get(cuboidRegion));
            }
            if (this.four != null && this.four.intersects(cuboidRegion)) {
                hashSet.addAll(this.four.get(cuboidRegion));
            }
        }
        return hashSet;
    }

    public boolean intersects(CuboidRegion cuboidRegion) {
        return cuboidRegion.getMinimumPoint().getX() <= this.x + this.size && cuboidRegion.getMaximumPoint().getX() >= this.x - this.size && cuboidRegion.getMinimumPoint().getZ() <= this.z + this.size && cuboidRegion.getMaximumPoint().getZ() >= this.z - this.size;
    }

    public T get(int n, int n2) {
        if (this.objects != null) {
            for (T t : this.objects) {
                if (!RegionUtil.contains(this.getRegion(t), n, n2)) continue;
                return t;
            }
        }
        if (this.skip != null) {
            return this.skip.get(n, n2);
        }
        if (n >= this.x) {
            if (n2 >= this.z) {
                if (this.one != null) {
                    return this.one.get(n, n2);
                }
            } else if (this.two != null) {
                return this.two.get(n, n2);
            }
        } else if (n2 >= this.z) {
            if (this.four != null) {
                return this.four.get(n, n2);
            }
        } else if (this.three != null) {
            return this.three.get(n, n2);
        }
        return null;
    }
}

