/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.query.PlotQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeoutException;

@CommandDeclaration(command="alias", permission="plots.alias", usage="/plot alias <set | remove> <alias>", aliases={"setalias", "sa", "name", "rename", "setname", "seta", "nameplot"}, category=CommandCategory.SETTINGS, requiredType=RequiredType.PLAYER)
public class Alias
extends SubCommand {
    private static final Command SET_COMMAND = new Command(null, false, "set", null, RequiredType.NONE, null){};
    private static final Command REMOVE_COMMAND = new Command(null, false, "remove", null, RequiredType.NONE, null){};

    @Override
    public boolean onCommand(PlotPlayer<?> plotPlayer, String[] stringArray) {
        if (stringArray.length == 0) {
            this.sendUsage(plotPlayer);
            return false;
        }
        Location location = plotPlayer.getLocation();
        Plot plot = location.getPlotAbs();
        if (plot == null) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
            return false;
        }
        if (!plot.hasOwner()) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("working.plot_not_claimed"), new TagResolver[0]);
            return false;
        }
        boolean bl = false;
        boolean bl2 = plot.isOwner(plotPlayer.getUUID());
        switch (stringArray[0].toLowerCase()) {
            case "set": {
                if (stringArray.length != 2) {
                    this.sendUsage(plotPlayer);
                    return false;
                }
                boolean bl3 = this.isPermitted(plotPlayer, Permission.PERMISSION_ALIAS_SET);
                boolean bl4 = this.isPermitted(plotPlayer, Permission.PERMISSION_ADMIN_ALIAS_SET);
                if (!bl4 && !bl2) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_plot_perms"), new TagResolver[0]);
                    return false;
                }
                if (bl3) {
                    this.setAlias(plotPlayer, plot, stringArray[1]);
                    return true;
                }
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_ALIAS_SET)));
                break;
            }
            case "remove": {
                boolean bl5 = this.isPermitted(plotPlayer, Permission.PERMISSION_ALIAS_REMOVE);
                boolean bl6 = this.isPermitted(plotPlayer, Permission.PERMISSION_ADMIN_ALIAS_REMOVE);
                if (!bl6 && !bl2) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_plot_perms"), new TagResolver[0]);
                    return false;
                }
                if (bl5) {
                    bl = this.removeAlias(plotPlayer, plot);
                    break;
                }
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_ALIAS_REMOVE)));
                break;
            }
            default: {
                this.sendUsage(plotPlayer);
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> plotPlayer, String[] stringArray, boolean bl) {
        ArrayList<Command> arrayList = new ArrayList<Command>(2);
        if (stringArray.length == 1) {
            if ("set".startsWith(stringArray[0])) {
                arrayList.add(SET_COMMAND);
            }
            if ("remove".startsWith(stringArray[0])) {
                arrayList.add(REMOVE_COMMAND);
            }
            return arrayList;
        }
        return Collections.emptySet();
    }

    private void setAlias(PlotPlayer<?> plotPlayer, Plot plot, String string) {
        if (string.isEmpty()) {
            this.sendUsage(plotPlayer);
        } else if (string.length() >= 50) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("alias.alias_too_long"), new TagResolver[0]);
        } else if (MathMan.isInteger(string)) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("flag.not_valid_value"), new TagResolver[0]);
        } else {
            if (PlotQuery.newQuery().inArea(plot.getArea()).withAlias(string).anyMatch()) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("alias.alias_is_taken"), TagResolver.resolver("alias", Tag.inserting(Component.text(string))));
                return;
            }
            if (Settings.UUID.OFFLINE) {
                plot.setAlias(string);
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("alias.alias_set_to"), TagResolver.resolver("alias", Tag.inserting(Component.text(string))));
                return;
            }
            PlotSquared.get().getImpromptuUUIDPipeline().getSingle(string, (uUID, throwable) -> {
                if (throwable instanceof TimeoutException) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("players.fetching_players_timeout"), new TagResolver[0]);
                } else if (uUID != null) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("alias.alias_is_taken"), TagResolver.resolver("alias", Tag.inserting(Component.text(string))));
                } else {
                    plot.setAlias(string);
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("alias.alias_set_to"), TagResolver.resolver("alias", Tag.inserting(Component.text(string))));
                }
            });
        }
    }

    private boolean removeAlias(PlotPlayer<?> plotPlayer, Plot plot) {
        String string = plot.getAlias();
        if (!plot.getAlias().isEmpty()) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("alias.alias_removed"), TagResolver.resolver("alias", Tag.inserting(Component.text(string))));
        } else {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("alias.no_alias_set"), new TagResolver[0]);
        }
        plot.setAlias(null);
        return true;
    }

    private boolean isPermitted(PlotPlayer<?> plotPlayer, Permission permission) {
        return plotPlayer.hasPermission(permission);
    }
}

