/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.plot.PlotId;

public abstract class Argument<T> {
    public static final Argument<Integer> Integer = new Argument<Integer>("int", java.lang.Integer.valueOf(16)){

        @Override
        public Integer parse(String string) {
            Integer n = null;
            try {
                n = java.lang.Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return n;
        }
    };
    public static final Argument<Boolean> Boolean = new Argument<Boolean>("boolean", java.lang.Boolean.valueOf(true)){

        @Override
        public Boolean parse(String string) {
            Boolean bl = null;
            if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("Yes") || string.equalsIgnoreCase("1")) {
                bl = true;
            } else if (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("No") || string.equalsIgnoreCase("0")) {
                bl = false;
            }
            return bl;
        }
    };
    public static final Argument<String> String = new Argument<String>("String", "Example"){

        @Override
        public String parse(String string) {
            return string;
        }
    };
    public static final Argument<String> PlayerName = new Argument<String>("PlayerName", "<player | *>"){

        @Override
        public String parse(String string) {
            return string.length() <= 16 ? string : null;
        }
    };
    public static final Argument<PlotId> PlotID = new Argument<PlotId>("PlotID", PlotId.of(-6, 3)){

        @Override
        public PlotId parse(String string) {
            return PlotId.fromString(string);
        }
    };
    private final String name;
    private final T example;

    public Argument(String string, T t) {
        this.name = string;
        this.example = t;
    }

    public abstract T parse(String var1);

    public final String toString() {
        return this.getName();
    }

    public final String getName() {
        return this.name;
    }

    public final T getExample() {
        return this.example;
    }
}

