/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.events.PlayerAutoPlotEvent;
import com.plotsquared.core.events.PlotAutoMergeEvent;
import com.plotsquared.core.events.Result;
import com.plotsquared.core.geantyref.TypeToken;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.permissions.PermissionHandler;
import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.PlayerMetaDataKeys;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.services.ServicePipeline;
import com.plotsquared.core.services.plots.AutoQuery;
import com.plotsquared.core.services.plots.AutoService;
import com.plotsquared.core.util.EconHandler;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.PlotExpression;
import com.plotsquared.core.util.task.AutoClaimFinishTask;
import com.plotsquared.core.util.task.RunnableVal;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.google.Inject;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@CommandDeclaration(command="auto", permission="plots.auto", category=CommandCategory.CLAIMING, requiredType=RequiredType.NONE, aliases={"a"}, usage="/plot auto [length, width]")
public class Auto
extends SubCommand {
    private final PlotAreaManager plotAreaManager;
    private final EventDispatcher eventDispatcher;
    private final EconHandler econHandler;
    private final ServicePipeline servicePipeline;

    @Inject
    public Auto(@NonNull PlotAreaManager plotAreaManager, @NonNull EventDispatcher eventDispatcher, @NonNull EconHandler econHandler, @NonNull ServicePipeline servicePipeline) {
        this.plotAreaManager = plotAreaManager;
        this.eventDispatcher = eventDispatcher;
        this.econHandler = econHandler;
        this.servicePipeline = servicePipeline;
        this.servicePipeline.registerServiceType(TypeToken.get(AutoService.class), new AutoService.DefaultAutoService());
        AutoService.MultiPlotService multiPlotService = new AutoService.MultiPlotService();
        this.servicePipeline.registerServiceImplementation(AutoService.class, multiPlotService, Collections.singletonList(multiPlotService));
        AutoService.SinglePlotService singlePlotService = new AutoService.SinglePlotService();
        this.servicePipeline.registerServiceImplementation(AutoService.class, singlePlotService, Collections.singletonList(singlePlotService));
    }

    public static boolean checkAllowedPlots(PlotPlayer<?> plotPlayer, PlotArea plotArea, @Nullable Integer n, int n2, int n3) {
        block15: {
            if (n == null) {
                n = plotPlayer.getAllowedPlots();
            }
            int n4 = Settings.Limit.GLOBAL ? plotPlayer.getPlotCount() : plotPlayer.getPlotCount(plotArea.getWorldName());
            int n5 = n - n4;
            if (n5 - n2 * n3 < 0) {
                try (MetaDataAccess<Integer> metaDataAccess = plotPlayer.accessPersistentMetaData(PlayerMetaDataKeys.PERSISTENT_GRANTED_PLOTS);){
                    if (metaDataAccess.isPresent()) {
                        int n6;
                        int n7 = metaDataAccess.get().orElse(0);
                        if (n5 < 0 && n7 < n2 * n3) {
                            plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.cant_claim_more_plots"), TagResolver.resolver("amount", Tag.inserting(Component.text(n5 + n7))));
                            boolean bl = false;
                            return bl;
                        }
                        if (n5 >= 0 && n7 + n5 < n2 * n3) {
                            plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.cant_claim_more_plots"), TagResolver.resolver("amount", Tag.inserting(Component.text(n5 + n7))));
                            boolean bl = false;
                            return bl;
                        }
                        int n8 = n6 = n7 + n5 < 0 ? 0 : n5 - n2 * n3;
                        if (n6 == 0) {
                            metaDataAccess.remove();
                        } else {
                            metaDataAccess.set(n6);
                        }
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("economy.removed_granted_plot"), TagResolver.builder().tag("used_grants", Tag.inserting(Component.text(n7 - n6))).tag("remaining_grants", Tag.inserting(Component.text(n6))).build());
                        break block15;
                    }
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.cant_claim_more_plots"), TagResolver.resolver("amount", Tag.inserting(Component.text(plotPlayer.getAllowedPlots()))));
                    boolean bl = false;
                    return bl;
                }
            }
        }
        return true;
    }

    private void claimSingle(final @NonNull PlotPlayer<?> plotPlayer, final @NonNull Plot plot, final @NonNull PlotArea plotArea, final @Nullable String string) {
        try (Object object = plotPlayer.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_AUTO);){
            ((MetaDataAccess)object).set(true);
        }
        plot.setOwnerAbs(plotPlayer.getUUID());
        object = new RunnableVal<Plot>(){
            {
                this.value = plot;
            }

            @Override
            public void run(Plot plot2) {
                try {
                    TaskManager.getPlatformImplementation().sync(new AutoClaimFinishTask(plotPlayer, plot2, plotArea, string, PlotSquared.get().getEventDispatcher()));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        DBFunc.createPlotSafe(plot, (Runnable)object, () -> this.claimSingle(plotPlayer, plot, plotArea, string));
    }

    @Override
    public boolean onCommand(PlotPlayer<?> plotPlayer, String[] stringArray) {
        Object object;
        PlayerAutoPlotEvent playerAutoPlotEvent;
        PlotArea object3 = plotPlayer.getApplicablePlotArea();
        if (object3 == null) {
            PermissionHandler permissionHandler = PlotSquared.platform().permissionHandler();
            if (permissionHandler.hasCapability(PermissionHandler.PermissionHandlerCapability.PER_WORLD_PERMISSIONS)) {
                for (PlotArea object22 : this.plotAreaManager.getAllPlotAreas()) {
                    if (!plotPlayer.hasPermission(object22.getWorldName(), "plots.auto")) continue;
                    if (object3 != null) {
                        object3 = null;
                        break;
                    }
                    object3 = object22;
                }
            }
            if (this.plotAreaManager.getAllPlotAreas().length == 1) {
                object3 = this.plotAreaManager.getAllPlotAreas()[0];
            }
            if (object3 == null) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot_world"), new TagResolver[0]);
                return false;
            }
        }
        int n = 1;
        int n2 = 1;
        String string = null;
        int n3 = 0;
        if (stringArray.length > 0) {
            try {
                String[] numberFormatException = stringArray[0].split("[,;]");
                if (numberFormatException.length != 2) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text(this.getUsage()))));
                    return true;
                }
                n = Integer.parseInt(numberFormatException[0]);
                n2 = Integer.parseInt(numberFormatException[1]);
                if (n < 1 || n2 < 1) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("error.plot_size_negative"), new TagResolver[0]);
                    return true;
                }
                if (stringArray.length > 1) {
                    string = stringArray[1];
                }
                n3 = 1;
            }
            catch (NumberFormatException numberFormatException) {
                n = 1;
                n2 = 1;
                string = stringArray[0];
            }
        }
        if ((playerAutoPlotEvent = this.eventDispatcher.callAuto(plotPlayer, object3, string, n, n2)).getEventResult() == Result.DENY) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("events.event_denied"), TagResolver.resolver("value", Tag.inserting(Component.text("Auto claim"))));
            return true;
        }
        boolean bl = playerAutoPlotEvent.getEventResult() == Result.FORCE;
        n = playerAutoPlotEvent.getSizeX();
        n2 = playerAutoPlotEvent.getSizeZ();
        string = playerAutoPlotEvent.getSchematic();
        if (!bl && n3 != 0 && !plotPlayer.hasPermission(Permission.PERMISSION_AUTO_MEGA)) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_AUTO_MEGA)));
            return false;
        }
        if (!bl && n * n2 > Settings.Claim.MAX_AUTO_AREA) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.cant_claim_more_plots_num"), TagResolver.resolver("amount", Tag.inserting(Component.text(Settings.Claim.MAX_AUTO_AREA))));
            return false;
        }
        int n4 = plotPlayer.getAllowedPlots();
        try (List<Plot> list = plotPlayer.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_AUTO);){
            if (!(bl || !((MetaDataAccess)((Object)list)).get().orElse(false).booleanValue() && Auto.checkAllowedPlots(plotPlayer, object3, n4, n, n2))) {
                boolean bl2 = false;
                return bl2;
            }
        }
        if (string != null && !string.isEmpty()) {
            if (!object3.hasSchematic(string)) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_invalid_named"), TagResolver.builder().tag("schemname", Tag.inserting(Component.text(string))).tag("reason", Tag.inserting(Component.text("non-existent"))).build());
                return true;
            }
            if (!(bl || plotPlayer.hasPermission(Permission.PERMISSION_CLAIM_SCHEMATIC.format(string)) || plotPlayer.hasPermission("plots.admin.command.schematic"))) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Component.text("plots.claim.%s0"))));
                return true;
            }
        }
        if (this.econHandler != null && object3.useEconomy() && !plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_BYPASS_ECON)) {
            list = object3.getPrices().get("claim");
            object = object3.getPrices().get("merge");
            int n5 = n * n2;
            double d = n5 <= 1 || object == null ? 0.0 : ((PlotExpression)object).evaluate(n5);
            double d2 = ((PlotExpression)((Object)list)).evaluate(Settings.Limit.GLOBAL ? (double)plotPlayer.getPlotCount() : (double)plotPlayer.getPlotCount(object3.getWorldName()));
            if ((d2 = (double)n5 * d2 + d) > 0.0) {
                if (!this.econHandler.isSupported()) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("economy.vault_or_consumer_null"), new TagResolver[0]);
                    return false;
                }
                if (!bl && this.econHandler.getMoney(plotPlayer) < d2) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("economy.cannot_afford_plot"), TagResolver.builder().tag("money", Tag.inserting(Component.text(this.econHandler.format(d2)))).tag("balance", Tag.inserting(Component.text(this.econHandler.format(this.econHandler.getMoney(plotPlayer))))).build());
                    return false;
                }
                this.econHandler.withdrawMoney(plotPlayer, d2);
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("economy.removed_balance"), TagResolver.resolver("money", Tag.inserting(Component.text(this.econHandler.format(d2)))));
            }
        }
        list = (List)this.servicePipeline.pump(new AutoQuery(plotPlayer, null, n, n2, object3)).through(AutoService.class).getResult();
        if ((list = this.eventDispatcher.callAutoPlotsChosen(plotPlayer, list).getPlots()).isEmpty()) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.no_free_plots"), new TagResolver[0]);
            return false;
        }
        if (list.size() != 1) {
            object = list.iterator();
            while (object.hasNext()) {
                Plot plot = (Plot)object.next();
                if (!plot.canClaim(plotPlayer)) continue;
                plot.claim(plotPlayer, !object.hasNext(), null, true, true);
                this.eventDispatcher.callPostAuto(plotPlayer, plot);
            }
            PlotAutoMergeEvent plotAutoMergeEvent = this.eventDispatcher.callAutoMerge(list.get(0), list.stream().map(Plot::getId).collect(Collectors.toList()));
            if (!bl && plotAutoMergeEvent.getEventResult() == Result.DENY) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("events.event_denied"), TagResolver.resolver("value", Tag.inserting(Component.text("Auto merge"))));
                return false;
            }
            return object3.mergePlots(plotAutoMergeEvent.getPlots(), true);
        }
        this.claimSingle(plotPlayer, list.get(0), object3, string);
        return true;
    }
}

