/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.backup.BackupManager;
import com.plotsquared.core.backup.BackupProfile;
import com.plotsquared.core.backup.NullBackupProfile;
import com.plotsquared.core.backup.PlayerBackupProfile;
import com.plotsquared.core.command.CmdConfirm;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.MainCommand;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.util.task.RunnableVal2;
import com.plotsquared.core.util.task.RunnableVal3;
import com.plotsquared.google.Inject;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="backup", usage="/plot backup <save | list | load>", category=CommandCategory.SETTINGS, requiredType=RequiredType.PLAYER, permission="plots.backup")
public final class Backup
extends Command {
    private final BackupManager backupManager;

    @Inject
    public Backup(@NonNull BackupManager backupManager) {
        super(MainCommand.getInstance(), true);
        this.backupManager = backupManager;
    }

    private static boolean sendMessage(PlotPlayer<?> plotPlayer) {
        plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot backup <save | list | load>"))));
        return true;
    }

    @Override
    public CompletableFuture<Boolean> execute(PlotPlayer<?> plotPlayer, String[] stringArray, RunnableVal3<Command, Runnable, Runnable> runnableVal3, RunnableVal2<Command, Command.CommandResult> runnableVal2) {
        if (stringArray.length == 0 || !Arrays.asList("save", "list", "load").contains(stringArray[0].toLowerCase(Locale.ENGLISH))) {
            return CompletableFuture.completedFuture(Backup.sendMessage(plotPlayer));
        }
        return super.execute(plotPlayer, stringArray, runnableVal3, runnableVal2);
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> plotPlayer, String[] stringArray, boolean bl) {
        CompletableFuture<List<com.plotsquared.core.backup.Backup>> completableFuture;
        BackupProfile backupProfile;
        Plot plot;
        if (stringArray.length == 1) {
            return Stream.of("save", "list", "load").filter(string -> string.startsWith(stringArray[0].toLowerCase(Locale.ENGLISH))).map(string -> new Command(null, false, (String)string, "", RequiredType.NONE, null){}).collect(Collectors.toList());
        }
        if (stringArray[0].equalsIgnoreCase("load") && (plot = plotPlayer.getCurrentPlot()) != null && (backupProfile = Objects.requireNonNull(this.backupManager.getProfile(plot))) instanceof PlayerBackupProfile && (completableFuture = backupProfile.listBackups()).isDone()) {
            List list = completableFuture.getNow(new ArrayList());
            if (list.isEmpty()) {
                return new ArrayList<Command>();
            }
            return IntStream.range(1, 1 + list.size()).mapToObj(n -> new Command(null, false, Integer.toString(n), "", RequiredType.NONE, null){}).collect(Collectors.toList());
        }
        return this.tabOf(plotPlayer, stringArray, bl, new String[0]);
    }

    @CommandDeclaration(command="save", usage="/plot backup save", category=CommandCategory.SETTINGS, requiredType=RequiredType.PLAYER, permission="plots.backup.save")
    public void save(Command command, PlotPlayer<?> plotPlayer, String[] stringArray, RunnableVal3<Command, Runnable, Runnable> runnableVal3, RunnableVal2<Command, Command.CommandResult> runnableVal2) {
        Plot plot = plotPlayer.getCurrentPlot();
        if (plot == null) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
        } else if (!plot.hasOwner()) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("backups.backup_impossible"), TagResolver.resolver("plot", Tag.inserting(TranslatableCaption.of("generic.generic_unowned").toComponent(plotPlayer))));
        } else if (plot.getVolume() > 2.147483647E9) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_too_large"), new TagResolver[0]);
        } else if (plot.isMerged()) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("backups.backup_impossible"), TagResolver.resolver("plot", Tag.inserting(TranslatableCaption.of("generic.generic_merged").toComponent(plotPlayer))));
        } else if (!plot.isOwner(plotPlayer.getUUID()) && !plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_BACKUP_OTHER)) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_ADMIN_BACKUP_OTHER)));
        } else {
            BackupProfile backupProfile = Objects.requireNonNull(this.backupManager.getProfile(plot));
            if (backupProfile instanceof NullBackupProfile) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("backups.backup_impossible"), TagResolver.resolver("plot", Tag.inserting(TranslatableCaption.of("generic.generic_other").toComponent(plotPlayer))));
            } else {
                backupProfile.createBackup().whenComplete((backup, throwable) -> {
                    if (throwable != null) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("backups.backup_save_failed"), TagResolver.resolver("reason", Tag.inserting(Component.text(throwable.getMessage()))));
                        throwable.printStackTrace();
                    } else {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("backups.backup_save_success"), new TagResolver[0]);
                    }
                });
            }
        }
    }

    @CommandDeclaration(command="list", usage="/plot backup list", category=CommandCategory.SETTINGS, requiredType=RequiredType.PLAYER, permission="plots.backup.list")
    public void list(Command command, PlotPlayer<?> plotPlayer, String[] stringArray, RunnableVal3<Command, Runnable, Runnable> runnableVal3, RunnableVal2<Command, Command.CommandResult> runnableVal2) {
        Plot plot = plotPlayer.getCurrentPlot();
        if (plot == null) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
        } else if (!plot.hasOwner()) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("backups.backup_impossible"), TagResolver.resolver("plot", Tag.inserting(TranslatableCaption.of("generic.generic_unowned").toComponent(plotPlayer))));
        } else if (plot.isMerged()) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("backups.backup_impossible"), TagResolver.resolver("plot", Tag.inserting(TranslatableCaption.of("generic.generic_merged").toComponent(plotPlayer))));
        } else if (plot.getVolume() > 2.147483647E9) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_too_large"), new TagResolver[0]);
        } else if (!plot.isOwner(plotPlayer.getUUID()) && !plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_BACKUP_OTHER)) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_ADMIN_BACKUP_OTHER)));
        } else {
            BackupProfile backupProfile = Objects.requireNonNull(this.backupManager.getProfile(plot));
            if (backupProfile instanceof NullBackupProfile) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("backups.backup_impossible"), TagResolver.resolver("plot", Tag.inserting(TranslatableCaption.of("generic.generic_other").toComponent(plotPlayer))));
            } else {
                backupProfile.listBackups().whenComplete((list, throwable) -> {
                    if (throwable != null) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("backups.backup_list_failed"), TagResolver.resolver("reason", Tag.inserting(Component.text(throwable.getMessage()))));
                        throwable.printStackTrace();
                    } else {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("backups.backup_list_header"), TagResolver.resolver("plot", Tag.inserting(Component.text(plot.getId().toCommaSeparatedString()))));
                        try {
                            for (int i = 0; i < list.size(); ++i) {
                                plotPlayer.sendMessage((Caption)TranslatableCaption.of("backups.backup_list_entry"), TagResolver.builder().tag("number", Tag.inserting(Component.text(i + 1))).tag("value", Tag.inserting(Component.text(DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.ofInstant(Instant.ofEpochMilli(((com.plotsquared.core.backup.Backup)list.get(i)).getCreationTime()), ZoneId.systemDefault()))))).build());
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
            }
        }
    }

    @CommandDeclaration(command="load", usage="/plot backup load <#>", category=CommandCategory.SETTINGS, requiredType=RequiredType.PLAYER, permission="plots.backup.load")
    public void load(Command command, PlotPlayer<?> plotPlayer, String[] stringArray, RunnableVal3<Command, Runnable, Runnable> runnableVal3, RunnableVal2<Command, Command.CommandResult> runnableVal2) {
        Plot plot = plotPlayer.getCurrentPlot();
        if (plot == null) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
        } else if (!plot.hasOwner()) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("backups.backup_impossible"), TagResolver.resolver("plot", Tag.inserting(TranslatableCaption.of("generic.generic_unowned").toComponent(plotPlayer))));
        } else if (plot.isMerged()) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("backups.backup_impossible"), TagResolver.resolver("plot", Tag.inserting(TranslatableCaption.of("generic.generic_merged").toComponent(plotPlayer))));
        } else if (plot.getVolume() > 2.147483647E9) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_too_large"), new TagResolver[0]);
        } else if (!plot.isOwner(plotPlayer.getUUID()) && !plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_BACKUP_OTHER)) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_ADMIN_BACKUP_OTHER)));
        } else if (stringArray.length == 0) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("Usage: /plot backup save/list/load"))));
        } else {
            int n;
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (Exception exception) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("invalid.not_a_number"), TagResolver.resolver("value", Tag.inserting(Component.text(stringArray[0]))));
                return;
            }
            BackupProfile backupProfile = Objects.requireNonNull(this.backupManager.getProfile(plot));
            if (backupProfile instanceof NullBackupProfile) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("backups.backup_impossible"), TagResolver.resolver("plot", Tag.inserting(TranslatableCaption.of("generic.generic_other").toComponent(plotPlayer))));
            } else {
                backupProfile.listBackups().whenComplete((list, throwable) -> {
                    if (throwable != null) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("backups.backup_load_failure"), TagResolver.resolver("reason", Tag.inserting(Component.text(throwable.getMessage()))));
                        throwable.printStackTrace();
                    } else if (n < 1 || n > list.size()) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("backups.backup_impossible"), TagResolver.resolver("plot", Tag.inserting(TranslatableCaption.of("generic.generic_invalid_choice").toComponent(plotPlayer))));
                    } else {
                        com.plotsquared.core.backup.Backup backup = (com.plotsquared.core.backup.Backup)list.get(n - 1);
                        if (backup == null || backup.getFile() == null || !Files.exists(backup.getFile(), new LinkOption[0])) {
                            plotPlayer.sendMessage((Caption)TranslatableCaption.of("backups.backup_impossible"), TagResolver.resolver("plot", Tag.inserting(TranslatableCaption.of("generic.generic_invalid_choice").toComponent(plotPlayer))));
                        } else {
                            CmdConfirm.addPending(plotPlayer, "/plot backup load " + n, () -> backupProfile.restoreBackup(backup, plotPlayer).whenComplete((void_, throwable) -> {
                                if (throwable != null) {
                                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("backups.backup_load_failure"), TagResolver.resolver("reason", Tag.inserting(Component.text(throwable.getMessage()))));
                                } else {
                                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("backups.backup_load_success"), new TagResolver[0]);
                                }
                            }));
                        }
                    }
                });
            }
        }
    }
}

