/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SetCommand;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.StaticCaption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.util.StringMan;
import com.sk89q.worldedit.command.util.SuggestionHelper;
import com.sk89q.worldedit.registry.NamespacedRegistry;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.biome.BiomeTypes;
import java.util.Collection;
import java.util.Locale;
import java.util.stream.Collectors;

@CommandDeclaration(command="setbiome", permission="plots.set.biome", usage="/plot biome [biome]", aliases={"biome", "sb", "setb", "b"}, category=CommandCategory.APPEARANCE, requiredType=RequiredType.NONE)
public class Biome
extends SetCommand {
    @Override
    public boolean set(PlotPlayer<?> plotPlayer, Plot plot, String string) {
        BiomeType biomeType = null;
        try {
            biomeType = BiomeTypes.get((String)string.toLowerCase());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (biomeType == null) {
            String string2 = TranslatableCaption.of("blocklist.block_list_separator").getComponent(plotPlayer);
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("biome.need_biome"), new TagResolver[0]);
            plotPlayer.sendMessage((Caption)StaticCaption.of(TranslatableCaption.of("commandconfig.subcommand_set_options_header_only").getComponent(plotPlayer) + StringMan.join(BiomeType.REGISTRY.values(), string2)), new TagResolver[0]);
            return false;
        }
        if (plot.getRunning() > 0) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.wait_for_timer"), new TagResolver[0]);
            return false;
        }
        if (plot.getVolume() > 2.147483647E9) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_too_large"), new TagResolver[0]);
            return false;
        }
        plot.addRunning();
        plot.getPlotModificationManager().setBiome(biomeType, () -> {
            plot.removeRunning();
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("biome.biome_set_to"), TagResolver.resolver("value", Tag.inserting(Component.text(string.toLowerCase()))));
        });
        return true;
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> plotPlayer, String[] stringArray, boolean bl) {
        return SuggestionHelper.getNamespacedRegistrySuggestions((NamespacedRegistry)BiomeType.REGISTRY, (String)stringArray[0]).map(string -> string.toLowerCase(Locale.ENGLISH).replace("minecraft:", "")).filter(string -> string.startsWith(stringArray[0].toLowerCase(Locale.ENGLISH))).map(string -> new Command(null, false, (String)string, "", RequiredType.NONE, null){}).collect(Collectors.toList());
    }
}

