/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.ComponentLike;
import com.plotsquared.core.configuration.adventure.text.TextComponent;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.plot.flag.implementations.AnimalCapFlag;
import com.plotsquared.core.plot.flag.implementations.EntityCapFlag;
import com.plotsquared.core.plot.flag.implementations.HostileCapFlag;
import com.plotsquared.core.plot.flag.implementations.MiscCapFlag;
import com.plotsquared.core.plot.flag.implementations.MobCapFlag;
import com.plotsquared.core.plot.flag.implementations.VehicleCapFlag;

@CommandDeclaration(command="caps", category=CommandCategory.INFO, usage="/plot caps")
public class Caps
extends SubCommand {
    @Override
    public boolean onCommand(PlotPlayer<?> plotPlayer, String[] stringArray) {
        Plot plot = plotPlayer.getCurrentPlot();
        if (plot == null) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
            return false;
        }
        if (!plot.isAdded(plotPlayer.getUUID()) && !plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_CAPS_OTHER)) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_ADMIN_CAPS_OTHER)));
            return false;
        }
        if (plot.getVolume() > 2.147483647E9) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_too_large"), new TagResolver[0]);
            return false;
        }
        plotPlayer.sendMessage((Caption)TranslatableCaption.of("info.plot_caps_header"), new TagResolver[0]);
        int[] nArray = plot.countEntities();
        this.sendFormatted(plot, plotPlayer, MobCapFlag.class, nArray, "mobs", 3);
        this.sendFormatted(plot, plotPlayer, HostileCapFlag.class, nArray, "hostile", 2);
        this.sendFormatted(plot, plotPlayer, AnimalCapFlag.class, nArray, "animals", 1);
        this.sendFormatted(plot, plotPlayer, VehicleCapFlag.class, nArray, "vehicle", 4);
        this.sendFormatted(plot, plotPlayer, MiscCapFlag.class, nArray, "misc", 5);
        this.sendFormatted(plot, plotPlayer, EntityCapFlag.class, nArray, "entities", 0);
        return true;
    }

    private <T extends PlotFlag<Integer, T>> void sendFormatted(Plot plot, PlotPlayer<?> plotPlayer, Class<T> clazz, int[] nArray, String string, int n) {
        int n2 = nArray[n];
        int n3 = (Integer)plot.getFlag(clazz);
        String string2 = String.format("%.1f", Float.valueOf(100.0f * ((float)n2 / (float)n3)));
        TextComponent textComponent = n3 >= Integer.MAX_VALUE ? TranslatableCaption.of("info.infinite").toComponent(plotPlayer) : Component.text(n3);
        plotPlayer.sendMessage((Caption)TranslatableCaption.of("info.plot_caps_format"), TagResolver.builder().tag("cap", Tag.inserting(Component.text(string))).tag("current", Tag.inserting(Component.text(n2))).tag("limit", Tag.inserting((ComponentLike)textComponent)).tag("percentage", Tag.inserting(Component.text(string2))).build());
    }
}

