/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.events.PlayerClaimPlotEvent;
import com.plotsquared.core.events.PlotMergeEvent;
import com.plotsquared.core.events.Result;
import com.plotsquared.core.location.Direction;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.PlayerMetaDataKeys;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.util.EconHandler;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.PlotExpression;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.google.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="claim", aliases={"c"}, category=CommandCategory.CLAIMING, requiredType=RequiredType.PLAYER, permission="plots.claim", usage="/plot claim")
public class Claim
extends SubCommand {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + Claim.class.getSimpleName()));
    private final EventDispatcher eventDispatcher;
    private final EconHandler econHandler;

    @Inject
    public Claim(@NonNull EventDispatcher eventDispatcher, @NonNull EconHandler econHandler) {
        this.eventDispatcher = eventDispatcher;
        this.econHandler = econHandler;
    }

    @Override
    public boolean onCommand(PlotPlayer<?> plotPlayer, String[] stringArray) {
        int n;
        Location location;
        Plot plot;
        String string = null;
        if (stringArray.length >= 1) {
            string = stringArray[0];
        }
        if ((plot = (location = plotPlayer.getLocation()).getPlotAbs()) == null) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
            return false;
        }
        PlayerClaimPlotEvent playerClaimPlotEvent = this.eventDispatcher.callClaim(plotPlayer, plot, string);
        string = playerClaimPlotEvent.getSchematic();
        if (playerClaimPlotEvent.getEventResult() == Result.DENY) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("events.event_denied"), TagResolver.resolver("value", Tag.inserting(Component.text("Claim"))));
            return true;
        }
        boolean bl = playerClaimPlotEvent.getEventResult() == Result.FORCE;
        int n2 = Settings.Limit.GLOBAL ? plotPlayer.getPlotCount() : plotPlayer.getPlotCount(location.getWorldName());
        PlotArea plotArea = plot.getArea();
        try (MetaDataAccess<Integer> metaDataAccess = plotPlayer.accessPersistentMetaData(PlayerMetaDataKeys.PERSISTENT_GRANTED_PLOTS);){
            int n3 = 0;
            if (n2 >= plotPlayer.getAllowedPlots() && !bl) {
                if (metaDataAccess.isPresent()) {
                    n3 = metaDataAccess.get().orElse(0);
                    if (n3 <= 0) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.cant_claim_more_plots"), TagResolver.resolver("amount", Tag.inserting(Component.text(n3))));
                        metaDataAccess.remove();
                    }
                } else {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.cant_claim_more_plots"), TagResolver.resolver("amount", Tag.inserting(Component.text(plotPlayer.getAllowedPlots()))));
                    boolean bl2 = false;
                    return bl2;
                }
            }
            if (!plot.canClaim(plotPlayer)) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("working.plot_is_claimed"), new TagResolver[0]);
                boolean bl3 = false;
                return bl3;
            }
            if (string != null && !string.isEmpty() && plotArea.isSchematicClaimSpecify()) {
                if (!plotArea.hasSchematic(string)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_invalid_named"), TagResolver.builder().tag("schemname", Tag.inserting(Component.text(string))).tag("reason", Tag.inserting(Component.text("non-existent"))).build());
                }
                if (!(plotPlayer.hasPermission(Permission.PERMISSION_CLAIM_SCHEMATIC.format(string)) || plotPlayer.hasPermission("plots.admin.command.schematic") || bl)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_schematic_permission"), TagResolver.resolver("value", Tag.inserting(Component.text(string))));
                }
            }
            if (this.econHandler.isEnabled(plotArea) && !bl && !plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_BYPASS_ECON)) {
                PlotExpression plotExpression = plotArea.getPrices().get("claim");
                double[] dArray = new double[]{n2};
                double d = plotExpression.evaluate(dArray);
                if (d > 0.0) {
                    if (!this.econHandler.isSupported()) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("economy.vault_or_consumer_null"), new TagResolver[0]);
                        boolean bl4 = false;
                        return bl4;
                    }
                    if (this.econHandler.getMoney(plotPlayer) < d) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("economy.cannot_afford_plot"), TagResolver.builder().tag("money", Tag.inserting(Component.text(this.econHandler.format(d)))).tag("balance", Tag.inserting(Component.text(this.econHandler.format(this.econHandler.getMoney(plotPlayer))))).build());
                        boolean bl5 = false;
                        return bl5;
                    }
                    this.econHandler.withdrawMoney(plotPlayer, d);
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("economy.removed_balance"), TagResolver.builder().tag("money", Tag.inserting(Component.text(this.econHandler.format(d)))).tag("balance", Tag.inserting(Component.text(this.econHandler.format(this.econHandler.getMoney(plotPlayer))))).build());
                }
            }
            if (n3 > 0) {
                if (n3 == 1) {
                    metaDataAccess.remove();
                } else {
                    metaDataAccess.set(n3 - 1);
                }
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("economy.removed_granted_plot"), TagResolver.builder().tag("used_grants", Tag.inserting(Component.text(n3 - 1))).tag("remaining_grants", Tag.inserting(Component.text(n3))).build());
            }
        }
        if (!plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_BYPASS_BORDER) && (n = plotArea.getBorder(false)) != Integer.MAX_VALUE && plot.getDistanceFromOrigin() > n && !bl) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("border.denied"), new TagResolver[0]);
            return false;
        }
        plot.setOwnerAbs(plotPlayer.getUUID());
        String string2 = string;
        DBFunc.createPlotSafe(plot, () -> {
            try {
                TaskManager.getPlatformImplementation().sync(() -> {
                    if (!plot.claim(plotPlayer, true, string2, false, false)) {
                        LOGGER.info("Failed to claim plot {}", (Object)plot.getId().toCommaSeparatedString());
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("working.plot_not_claimed"), new TagResolver[0]);
                        plot.setOwnerAbs(null);
                    } else if (plotArea.isAutoMerge()) {
                        PlotMergeEvent plotMergeEvent = this.eventDispatcher.callMerge(plot, Direction.ALL, Integer.MAX_VALUE, plotPlayer);
                        if (plotMergeEvent.getEventResult() == Result.DENY) {
                            plotPlayer.sendMessage((Caption)TranslatableCaption.of("events.event_denied"), TagResolver.resolver("value", Tag.inserting(Component.text("Auto merge on claim"))));
                        } else if (plot.getPlotModificationManager().autoMerge(plotMergeEvent.getDir(), plotMergeEvent.getMax(), plotPlayer.getUUID(), plotPlayer, true)) {
                            this.eventDispatcher.callPostMerge(plotPlayer, plot);
                        }
                    }
                    return null;
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }, () -> {
            LOGGER.info("Failed to add plot to database: {}", (Object)plot.getId().toCommaSeparatedString());
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("working.plot_not_claimed"), new TagResolver[0]);
            plot.setOwnerAbs(null);
        });
        return true;
    }
}

