/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.WorldUtil;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.core.util.task.TaskTime;
import com.plotsquared.google.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="condense", permission="plots.admin", usage="/plot condense <area> <start|stop|info> [radius]", category=CommandCategory.ADMINISTRATION, requiredType=RequiredType.CONSOLE)
public class Condense
extends SubCommand {
    public static boolean TASK = false;
    private final PlotAreaManager plotAreaManager;
    private final WorldUtil worldUtil;

    @Inject
    public Condense(@NonNull PlotAreaManager plotAreaManager, @NonNull WorldUtil worldUtil) {
        this.plotAreaManager = plotAreaManager;
        this.worldUtil = worldUtil;
    }

    @Override
    public boolean onCommand(final PlotPlayer<?> plotPlayer, String[] stringArray) {
        if (stringArray.length != 2 && stringArray.length != 3) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot condense <area> <start | stop | info> [radius]"))));
            return false;
        }
        PlotArea plotArea = this.plotAreaManager.getPlotAreaByString(stringArray[0]);
        if (plotArea == null || !this.worldUtil.isWorld(plotArea.getWorldName())) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("invalid.invalid_area"), new TagResolver[0]);
            return false;
        }
        switch (stringArray[1].toLowerCase()) {
            case "start": {
                Object object;
                int n;
                ArrayList<Object> arrayList;
                int n2;
                Object object2;
                if (stringArray.length == 2) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot condense" + plotArea + " start <radius>"))));
                    return false;
                }
                if (TASK) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("condense.task_already_started"), new TagResolver[0]);
                    return false;
                }
                if (!MathMan.isInteger(stringArray[2])) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("condense.invalid_radius"), new TagResolver[0]);
                    return false;
                }
                int n3 = Integer.parseInt(stringArray[2]);
                ArrayList<Plot> arrayList2 = new ArrayList<Plot>(plotArea.getPlots());
                Iterator iterator = arrayList2.iterator();
                int n4 = 0;
                ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
                while (iterator.hasNext()) {
                    object2 = (Plot)iterator.next();
                    if (!((Plot)object2).isBasePlot()) {
                        iterator.remove();
                        continue;
                    }
                    n2 = ((Plot)object2).getConnectedPlots().size();
                    if (n2 > n4) {
                        n4 = n2;
                    }
                    arrayList3.add(n2 - 1);
                }
                object2 = new ArrayList[n4];
                for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                    Plot plot = (Plot)arrayList2.get(n2);
                    int n5 = (Integer)arrayList3.get(n2);
                    arrayList = object2[n5];
                    if (arrayList == null) {
                        arrayList = new ArrayList<Plot>();
                        object2[n5] = arrayList;
                    }
                    arrayList.add(plot);
                }
                final ArrayList<Plot> arrayList4 = new ArrayList<Plot>(arrayList2.size());
                for (n = ((Object)object2).length - 1; n >= 0; --n) {
                    Object object3 = object2[n];
                    if (object3 == null) continue;
                    arrayList4.addAll((Collection<Plot>)object3);
                }
                n = arrayList4.size();
                int n6 = (int)Math.ceil(Math.sqrt(n) / 2.0 + 1.0);
                if (n3 < n6) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("condense.radius_too_small"), new TagResolver[0]);
                    return false;
                }
                arrayList = new ArrayList<PlotId>(this.getPlots(arrayList4, n3));
                final ArrayList<PlotId> arrayList5 = new ArrayList<PlotId>();
                PlotId plotId = PlotId.of(0, 0);
                while (plotId.getX() <= n6 && plotId.getY() <= n6) {
                    object = plotArea.getPlotAbs(plotId);
                    if (object != null && !((Plot)object).hasOwner()) {
                        arrayList5.add(((Plot)object).getId());
                    }
                    plotId = plotId.getNextId();
                }
                if (arrayList5.isEmpty() || arrayList.isEmpty()) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("condense.no_free_plots_found"), new TagResolver[0]);
                    return false;
                }
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("condense.task_started"), new TagResolver[0]);
                TASK = true;
                object = new Runnable(){

                    @Override
                    public void run() {
                        if (!TASK) {
                            plotPlayer.sendMessage((Caption)TranslatableCaption.of("debugexec.task_cancelled"), new TagResolver[0]);
                        }
                        if (arrayList4.isEmpty()) {
                            TASK = false;
                            plotPlayer.sendMessage((Caption)TranslatableCaption.of("condense.task_complete"), new TagResolver[0]);
                            return;
                        }
                        1 var1_1 = this;
                        Plot plot = (Plot)arrayList4.remove(0);
                        int n = 0;
                        while (arrayList5.size() > n) {
                            Plot plot2 = plot.getArea().getPlotAbs((PlotId)arrayList5.get(n));
                            if (plot2.hasOwner()) {
                                arrayList5.remove(n);
                                continue;
                            }
                            ++n;
                            AtomicBoolean atomicBoolean = new AtomicBoolean(false);
                            try {
                                atomicBoolean.set(plot.getPlotModificationManager().move(plot2, plotPlayer, () -> {
                                    if (atomicBoolean.get()) {
                                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("condense.moving"), TagResolver.builder().tag("origin", Tag.inserting(Component.text(plot.toString()))).tag("possible", Tag.inserting(Component.text(plot2.toString()))).build());
                                        TaskManager.runTaskLater(var1_1, TaskTime.ticks(1L));
                                    }
                                }, false).get());
                            }
                            catch (InterruptedException | ExecutionException exception) {
                                exception.printStackTrace();
                            }
                            if (!atomicBoolean.get()) continue;
                            break;
                        }
                        if (arrayList5.isEmpty()) {
                            TASK = false;
                            plotPlayer.sendMessage((Caption)TranslatableCaption.of("condense.task_failed"), new TagResolver[0]);
                            return;
                        }
                        if (n >= arrayList5.size()) {
                            plotPlayer.sendMessage((Caption)TranslatableCaption.of("condense.skipping"), TagResolver.resolver("plot", Tag.inserting(Component.text(plot.toString()))));
                        }
                    }
                };
                TaskManager.runTaskAsync((Runnable)object);
                return true;
            }
            case "stop": {
                if (!TASK) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("condense.task_stopped"), new TagResolver[0]);
                    return false;
                }
                TASK = false;
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("condense.task_stopped"), new TagResolver[0]);
                return true;
            }
            case "info": {
                Collection<Plot> collection;
                int n;
                int n7;
                if (stringArray.length == 2) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot condense " + plotArea + " info <radius>"))));
                    return false;
                }
                if (!MathMan.isInteger(stringArray[2])) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("condense.invalid_radius"), new TagResolver[0]);
                    return false;
                }
                int n8 = Integer.parseInt(stringArray[2]);
                if (n8 < (n7 = (int)Math.ceil(Math.sqrt(n = (collection = plotArea.getPlots()).size()) / 2.0 + 1.0))) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("condense.radius_too_small"), new TagResolver[0]);
                    return false;
                }
                int n9 = this.getPlots(collection, n7).size();
                int n10 = this.getPlots(collection, n8).size();
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("condense.default_eval"), new TagResolver[0]);
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("condense.minimum_radius"), TagResolver.resolver("minimumRadius", Tag.inserting(Component.text(n7))));
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("condense.maximum_moved"), TagResolver.resolver("maxMove", Tag.inserting(Component.text(n9))));
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("condense.input_eval"), new TagResolver[0]);
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("condense.input_radius"), TagResolver.resolver("radius", Tag.inserting(Component.text(n8))));
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("condense.estimated_moves"), TagResolver.resolver("userMove", Tag.inserting(Component.text(n10))));
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("condense.eta"), new TagResolver[0]);
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("condense.radius_measured"), new TagResolver[0]);
                return true;
            }
        }
        plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot condense " + plotArea.getWorldName() + " <start | stop | info> [radius]"))));
        return false;
    }

    public Set<PlotId> getPlots(Collection<Plot> collection, int n) {
        HashSet<PlotId> hashSet = new HashSet<PlotId>();
        for (Plot plot : collection) {
            if (plot.getId().getX() <= n && plot.getId().getX() >= -n && plot.getId().getY() <= n && plot.getId().getY() >= -n) continue;
            hashSet.add(plot.getId());
        }
        return hashSet;
    }
}

