/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;

@CommandDeclaration(command="copy", permission="plots.copy", aliases={"copypaste"}, category=CommandCategory.CLAIMING, usage="/plot copy <X;Z>", requiredType=RequiredType.NONE)
public class Copy
extends SubCommand {
    @Override
    public boolean onCommand(PlotPlayer<?> plotPlayer, String[] stringArray) {
        Location location = plotPlayer.getLocation();
        Plot plot = location.getPlotAbs();
        if (plot == null) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
            return false;
        }
        if (!plot.isOwner(plotPlayer.getUUID()) && !plotPlayer.hasPermission(Permission.PERMISSION_ADMIN.toString())) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_plot_perms"), new TagResolver[0]);
            return false;
        }
        if (stringArray.length != 1) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot copy <X;Z>"))));
            return false;
        }
        Plot plot2 = Plot.getPlotFromString(plotPlayer, stringArray[0], true);
        if (plot2 == null) {
            return false;
        }
        if (plot.equals(plot2)) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("invalid.origin_cant_be_target"), new TagResolver[0]);
            return false;
        }
        if (!plot.getArea().isCompatible(plot2.getArea())) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.plotworld_incompatible"), new TagResolver[0]);
            return false;
        }
        plot.getPlotModificationManager().copy(plot2, plotPlayer).thenAccept(bl -> {
            if (bl.booleanValue()) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("move.copy_success"), TagResolver.builder().tag("origin", Tag.inserting(Component.text(plot.toString()))).tag("target", Tag.inserting(Component.text(plot2.toString()))).build());
            } else {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("move.requires_unowned"), new TagResolver[0]);
            }
        });
        return true;
    }
}

