/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.TextComponent;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.StaticCaption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.StringMan;
import com.plotsquared.core.util.WorldUtil;
import com.plotsquared.core.util.entity.EntityCategories;
import com.plotsquared.core.util.entity.EntityCategory;
import com.plotsquared.core.util.query.PlotQuery;
import com.plotsquared.core.uuid.UUIDMapping;
import com.plotsquared.google.Inject;
import com.sk89q.worldedit.registry.Keyed;
import com.sk89q.worldedit.world.entity.EntityType;
import java.util.Collection;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="debug", category=CommandCategory.DEBUG, usage="/plot debug", permission="plots.admin")
public class Debug
extends SubCommand {
    private final PlotAreaManager plotAreaManager;
    private final WorldUtil worldUtil;

    @Inject
    public Debug(@NonNull PlotAreaManager plotAreaManager, @NonNull WorldUtil worldUtil) {
        this.plotAreaManager = plotAreaManager;
        this.worldUtil = worldUtil;
    }

    @Override
    public boolean onCommand(PlotPlayer<?> plotPlayer, String[] stringArray) {
        if (stringArray.length == 0) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot debug <player | debug-players | entitytypes | msg>"))));
        }
        if (stringArray.length > 0 && "player".equalsIgnoreCase(stringArray[0])) {
            for (Map.Entry<String, Object> entry : plotPlayer.getMeta().entrySet()) {
                plotPlayer.sendMessage((Caption)StaticCaption.of("Key: " + entry.getKey() + " Value: " + entry.getValue().toString() + " , "), new TagResolver[0]);
            }
            return true;
        }
        if (stringArray.length > 0 && "uuids".equalsIgnoreCase(stringArray[0])) {
            Collection<UUIDMapping> collection = PlotSquared.get().getImpromptuUUIDPipeline().getAllImmediately();
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("debug.cached_uuids"), TagResolver.resolver("value", Tag.inserting(Component.text(collection.size()))));
            return true;
        }
        if (stringArray.length > 0 && "debug-players".equalsIgnoreCase(stringArray[0])) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("debug.player_in_debugmode"), new TagResolver[0]);
            for (PlotPlayer<?> plotPlayer2 : PlotPlayer.getDebugModePlayers()) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("debug.player_in_debugmode_list"), TagResolver.resolver("value", Tag.inserting(Component.text(plotPlayer2.getName()))));
            }
            return true;
        }
        if (stringArray.length > 0 && "entitytypes".equalsIgnoreCase(stringArray[0])) {
            EntityCategories.init();
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("debug.entity_categories"), new TagResolver[0]);
            EntityCategory.REGISTRY.forEach(entityCategory -> {
                StringBuilder stringBuilder = new StringBuilder("<gray>-</gray> <gold>").append(entityCategory.getId()).append("</gold><gray>: <gold>");
                for (EntityType entityType : entityCategory.getAll()) {
                    stringBuilder.append(entityType.getId()).append(" ");
                }
                stringBuilder.append("</gold>");
                plotPlayer.sendMessage((Caption)StaticCaption.of("<prefix>" + stringBuilder), new TagResolver[0]);
            });
            EntityType.REGISTRY.values().stream().sorted(Comparator.comparing(EntityType::getId)).forEach(entityType -> {
                long l = EntityCategory.REGISTRY.values().stream().filter(entityCategory -> entityCategory.contains((Keyed)entityType)).count();
                if (l > 0L) {
                    return;
                }
                plotPlayer.sendMessage((Caption)StaticCaption.of("<prefix>" + entityType.getName() + " is in " + l + " categories"), new TagResolver[0]);
            });
            return true;
        }
        Set<TranslatableCaption> set = PlotSquared.get().getCaptionMap("plotsquared").getCaptions();
        TextComponent.Builder builder = Component.text();
        Component component = TranslatableCaption.of("debug.debug_header").toComponent(plotPlayer).append(Component.newline());
        String string = TranslatableCaption.of("debug.debug_line").getComponent(plotPlayer) + "\n";
        String string2 = TranslatableCaption.of("debug.debug_section").getComponent(plotPlayer) + "\n";
        builder.append(component);
        builder.append(MINI_MESSAGE.deserialize(string2, (TagResolver)TagResolver.resolver("val", Tag.inserting(Component.text("PlotArea")))));
        builder.append(MINI_MESSAGE.deserialize(string, TagResolver.builder().tag("var", Tag.inserting(Component.text("Plot Worlds"))).tag("val", Tag.inserting(Component.text(StringMan.join(this.plotAreaManager.getAllPlotAreas(), ", ")))).build()));
        builder.append(MINI_MESSAGE.deserialize(string, TagResolver.builder().tag("var", Tag.inserting(Component.text("Owned Plots"))).tag("val", Tag.inserting(Component.text(PlotQuery.newQuery().allPlots().count()))).build()));
        builder.append(MINI_MESSAGE.deserialize(string2, (TagResolver)TagResolver.resolver("val", Tag.inserting(Component.text("Messages")))));
        builder.append(MINI_MESSAGE.deserialize(string, TagResolver.builder().tag("var", Tag.inserting(Component.text("Total Messages"))).tag("val", Tag.inserting(Component.text(set.size()))).build()));
        plotPlayer.sendMessage((Caption)StaticCaption.of((String)MINI_MESSAGE.serialize(builder.build())), new TagResolver[0]);
        return true;
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> plotPlayer, String[] stringArray, boolean bl) {
        return Stream.of("debug-players", "entitytypes").filter(string -> string.startsWith(stringArray[0].toLowerCase(Locale.ENGLISH))).map(string -> new Command(null, false, (String)string, "plots.admin", RequiredType.NONE, null){}).collect(Collectors.toList());
    }
}

