/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.StaticCaption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.events.PlotFlagRemoveEvent;
import com.plotsquared.core.events.Result;
import com.plotsquared.core.generator.HybridUtils;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.expiration.PlotAnalysis;
import com.plotsquared.core.plot.flag.GlobalFlagContainer;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.StringMan;
import com.plotsquared.core.util.query.PlotQuery;
import com.plotsquared.core.util.task.RunnableVal;
import com.plotsquared.google.Inject;
import com.sk89q.worldedit.math.BlockVector2;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="debugexec", permission="plots.admin", aliases={"exec", "$"}, category=CommandCategory.DEBUG)
public class DebugExec
extends SubCommand {
    private final PlotAreaManager plotAreaManager;
    private final EventDispatcher eventDispatcher;
    private final HybridUtils hybridUtils;

    @Inject
    public DebugExec(@NonNull PlotAreaManager plotAreaManager, @NonNull EventDispatcher eventDispatcher, @NonNull HybridUtils hybridUtils) {
        this.plotAreaManager = plotAreaManager;
        this.eventDispatcher = eventDispatcher;
        this.hybridUtils = hybridUtils;
    }

    @Override
    public boolean onCommand(final PlotPlayer<?> plotPlayer, String[] stringArray) {
        List<String> list = Arrays.asList("analyze", "calibrate-analysis", "start-expire", "stop-expire", "remove-flag", "start-rgar", "stop-rgar");
        if (stringArray.length > 0) {
            String string;
            switch (string = stringArray[0].toLowerCase()) {
                case "analyze": {
                    Plot plot = plotPlayer.getCurrentPlot();
                    if (plot == null) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
                        return false;
                    }
                    PlotAnalysis plotAnalysis = plot.getComplexity(null);
                    if (plotAnalysis != null) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("debugexec.changes_column"), TagResolver.resolver("value", Tag.inserting(Component.text(plotAnalysis.changes))));
                        return true;
                    }
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("debugexec.starting_task"), new TagResolver[0]);
                    this.hybridUtils.analyzePlot(plot, new RunnableVal<PlotAnalysis>(){

                        @Override
                        public void run(PlotAnalysis plotAnalysis) {
                            plotPlayer.sendMessage((Caption)TranslatableCaption.of("debugexec.analyze_done"), TagResolver.resolver("command", Tag.inserting(Component.text("/plot debugexec analyze"))));
                        }
                    });
                    return true;
                }
                case "calibrate-analysis": {
                    double d;
                    if (stringArray.length != 2) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot debugexec analyze <threshold>"))));
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("debugexec.threshold_default"), new TagResolver[0]);
                        return false;
                    }
                    try {
                        d = (double)Integer.parseInt(stringArray[1]) / 100.0;
                    }
                    catch (NumberFormatException numberFormatException) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("debugexec.invalid_threshold"), TagResolver.resolver("value", Tag.inserting(Component.text(stringArray[1]))));
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("debugexec.threshold_default_double"), new TagResolver[0]);
                        return false;
                    }
                    PlotAnalysis.calcOptimalModifiers(() -> plotPlayer.sendMessage((Caption)TranslatableCaption.of("debugexec.calibration_done"), new TagResolver[0]), d);
                    return true;
                }
                case "start-expire": {
                    if (PlotSquared.platform().expireManager().runAutomatedTask()) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("debugexec.expiry_started"), new TagResolver[0]);
                    } else {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("debugexec.expiry_already_started"), new TagResolver[0]);
                    }
                    return true;
                }
                case "stop-expire": {
                    if (!PlotSquared.platform().expireManager().cancelTask()) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("debugexec.task_halted"), new TagResolver[0]);
                    } else {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("debugexec.task_cancelled"), new TagResolver[0]);
                    }
                    return true;
                }
                case "remove-flag": {
                    if (stringArray.length != 2) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot debugexec remove-flag <flag>"))));
                        return false;
                    }
                    String string2 = stringArray[1];
                    PlotFlag<?, ?> plotFlag = GlobalFlagContainer.getInstance().getFlagFromString(string2);
                    if (plotFlag != null) {
                        for (Plot plot : PlotQuery.newQuery().whereBasePlot()) {
                            PlotFlagRemoveEvent plotFlagRemoveEvent = this.eventDispatcher.callFlagRemove(plotFlag, plot);
                            if (plotFlagRemoveEvent.getEventResult() == Result.DENY) continue;
                            plot.removeFlag(plotFlagRemoveEvent.getFlag());
                        }
                    }
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("debugexec.cleared_flag"), TagResolver.resolver("value", Tag.inserting(Component.text(string2))));
                    return true;
                }
                case "start-rgar": {
                    if (stringArray.length != 2) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("Invalid syntax: /plot debugexec start-rgar <world>"))));
                        return false;
                    }
                    PlotArea plotArea = this.plotAreaManager.getPlotAreaByString(stringArray[1]);
                    if (plotArea == null) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_valid_plot_world"), TagResolver.resolver("value", Tag.inserting(Component.text(stringArray[1]))));
                        return false;
                    }
                    boolean bl = HybridUtils.regions != null ? this.hybridUtils.scheduleRoadUpdate(plotArea, HybridUtils.regions, 0, new LinkedHashSet<BlockVector2>()) : this.hybridUtils.scheduleRoadUpdate(plotArea, 0);
                    if (!bl) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("debugexec.mass_schematic_update_in_progress"), new TagResolver[0]);
                        return false;
                    }
                    return true;
                }
                case "stop-rgar": {
                    if (!HybridUtils.UPDATE) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("debugexec.task_not_running"), new TagResolver[0]);
                        return false;
                    }
                    HybridUtils.UPDATE = false;
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("debugexec.task_cancelled"), new TagResolver[0]);
                    return true;
                }
            }
        }
        plotPlayer.sendMessage((Caption)StaticCaption.of("<prefix><gold>Possible sub commands: </gold><gray>/plot debugexec <" + StringMan.join(list, " | ") + "></gray>"), new TagResolver[0]);
        return false;
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> plotPlayer, String[] stringArray, boolean bl) {
        return Stream.of("analyze", "calibrate-analysis", "start-expire", "stop-expire", "remove-flag", "start-rgar", "stop-rgar").filter(string -> string.startsWith(stringArray[0].toLowerCase(Locale.ENGLISH))).map(string -> new Command(null, false, (String)string, "plots.admin", RequiredType.NONE, null){}).collect(Collectors.toList());
    }
}

