/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.common.base.Charsets;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.MainCommand;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.plot.world.SinglePlotArea;
import com.plotsquared.core.plot.world.SinglePlotAreaManager;
import com.plotsquared.core.util.WorldUtil;
import com.plotsquared.core.util.task.RunnableVal2;
import com.plotsquared.core.util.task.RunnableVal3;
import com.plotsquared.google.Inject;
import java.io.File;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="debugimportworlds", permission="plots.admin", requiredType=RequiredType.CONSOLE, category=CommandCategory.TELEPORT)
public class DebugImportWorlds
extends Command {
    private final PlotAreaManager plotAreaManager;
    private final WorldUtil worldUtil;

    @Inject
    public DebugImportWorlds(@NonNull PlotAreaManager plotAreaManager, @NonNull WorldUtil worldUtil) {
        super(MainCommand.getInstance(), true);
        this.plotAreaManager = plotAreaManager;
        this.worldUtil = worldUtil;
    }

    @Override
    public CompletableFuture<Boolean> execute(PlotPlayer<?> plotPlayer, String[] stringArray, RunnableVal3<Command, Runnable, Runnable> runnableVal3, RunnableVal2<Command, Command.CommandResult> runnableVal2) {
        if (!(this.plotAreaManager instanceof SinglePlotAreaManager)) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("debugimportworlds.single_plot_area"), new TagResolver[0]);
            return CompletableFuture.completedFuture(false);
        }
        SinglePlotArea singlePlotArea = ((SinglePlotAreaManager)this.plotAreaManager).getArea();
        PlotId plotId = PlotId.of(0, 0);
        File file = PlotSquared.platform().worldContainer();
        if (file.equals(new File("."))) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("debugimportworlds.world_container"), new TagResolver[0]);
            return CompletableFuture.completedFuture(false);
        }
        for (File file2 : file.listFiles()) {
            UUID uUID;
            String string = file2.getName();
            if (this.worldUtil.isWorld(string) || PlotId.fromStringOrNull(string) != null) continue;
            if (string.length() > 16) {
                uUID = UUID.fromString(string);
            } else {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("players.fetching_player"), new TagResolver[0]);
                uUID = PlotSquared.get().getImpromptuUUIDPipeline().getSingle(string, 60000L);
            }
            if (uUID == null) {
                uUID = UUID.nameUUIDFromBytes(("OfflinePlayer:" + string).getBytes(Charsets.UTF_8));
            }
            while (new File(file, plotId.toCommaSeparatedString()).exists()) {
                plotId = plotId.getNextId();
            }
            File file3 = new File(file, plotId.toCommaSeparatedString());
            if (!file2.renameTo(file3)) continue;
            singlePlotArea.getPlot(plotId).setOwner(uUID);
        }
        plotPlayer.sendMessage((Caption)TranslatableCaption.of("players.done"), new TagResolver[0]);
        return CompletableFuture.completedFuture(true);
    }
}

