/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.Argument;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.events.TeleportCause;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.PlayerManager;
import com.plotsquared.core.util.TabCompletions;
import com.plotsquared.core.util.WorldUtil;
import com.plotsquared.google.Inject;
import com.sk89q.worldedit.world.gamemode.GameModes;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="deny", aliases={"d", "ban"}, usage="/plot deny <player>", category=CommandCategory.SETTINGS, requiredType=RequiredType.PLAYER)
public class Deny
extends SubCommand {
    private final PlotAreaManager plotAreaManager;
    private final EventDispatcher eventDispatcher;
    private final WorldUtil worldUtil;

    @Inject
    public Deny(@NonNull PlotAreaManager plotAreaManager, @NonNull EventDispatcher eventDispatcher, @NonNull WorldUtil worldUtil) {
        super(Argument.PlayerName);
        this.plotAreaManager = plotAreaManager;
        this.eventDispatcher = eventDispatcher;
        this.worldUtil = worldUtil;
    }

    @Override
    public boolean onCommand(PlotPlayer<?> plotPlayer, String[] stringArray) {
        Location location = plotPlayer.getLocation();
        Plot plot = location.getPlotAbs();
        if (plot == null) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
            return false;
        }
        if (!plot.hasOwner()) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("info.plot_unowned"), new TagResolver[0]);
            return false;
        }
        if (!plot.isOwner(plotPlayer.getUUID()) && !plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_COMMAND_DENY)) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_plot_perms"), new TagResolver[0]);
            return true;
        }
        int n = plotPlayer.hasPermissionRange(Permission.PERMISSION_DENY, Settings.Limit.MAX_PLOTS);
        int n2 = plot.getDenied().size();
        if (n2 >= n) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("members.plot_max_members_denied"), TagResolver.resolver("amount", Tag.inserting(Component.text(n2))));
            return false;
        }
        PlayerManager.getUUIDsFromString(stringArray[0], (collection, throwable) -> {
            if (throwable instanceof TimeoutException) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("players.fetching_players_timeout"), new TagResolver[0]);
            } else if (throwable != null || collection.isEmpty()) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.invalid_player"), TagResolver.resolver("value", Tag.inserting(Component.text(stringArray[0]))));
            } else {
                for (UUID uUID : collection) {
                    if (uUID == DBFunc.EVERYONE && !plotPlayer.hasPermission(Permission.PERMISSION_DENY_EVERYONE) && !plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_COMMAND_DENY)) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.invalid_player"), TagResolver.resolver("value", Tag.inserting(Component.text(stringArray[0]))));
                        continue;
                    }
                    if (plot.isOwner(uUID)) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("deny.cant_remove_owner"), new TagResolver[0]);
                        return;
                    }
                    if (plot.getDenied().contains(uUID)) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("member.already_added"), (CompletableFuture<TagResolver>)PlotSquared.platform().playerManager().getUsernameCaption(uUID).thenApply(caption -> TagResolver.resolver("player", Tag.inserting(caption.toComponent(plotPlayer)))));
                        return;
                    }
                    if (uUID != DBFunc.EVERYONE) {
                        plot.removeMember(uUID);
                        plot.removeTrusted(uUID);
                    }
                    plot.addDenied(uUID);
                    this.eventDispatcher.callDenied(plotPlayer, plot, uUID, true);
                    if (!uUID.equals(DBFunc.EVERYONE)) {
                        this.handleKick(PlotSquared.platform().playerManager().getPlayerIfExists(uUID), plot);
                        continue;
                    }
                    for (PlotPlayer<?> plotPlayer2 : plot.getPlayersInPlot()) {
                        if (plot.isAdded(plotPlayer2.getUUID())) continue;
                        this.handleKick(plotPlayer2, plot);
                    }
                }
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("deny.denied_added"), new TagResolver[0]);
            }
        });
        return true;
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> plotPlayer, String[] stringArray, boolean bl) {
        return TabCompletions.completePlayers(plotPlayer, String.join((CharSequence)",", stringArray).trim(), Collections.emptyList());
    }

    private void handleKick(PlotPlayer<?> plotPlayer, Plot plot) {
        plot = plot.getBasePlot(false);
        if (plotPlayer == null) {
            return;
        }
        if (!plot.equals(plotPlayer.getCurrentPlot())) {
            return;
        }
        if (plotPlayer.hasPermission("plots.admin.entry.denied")) {
            return;
        }
        if (plotPlayer.getGameMode() == GameModes.SPECTATOR) {
            plotPlayer.stopSpectating();
        }
        Location location = plotPlayer.getLocation();
        Location location2 = this.worldUtil.getSpawn(location.getWorldName());
        plotPlayer.sendMessage((Caption)TranslatableCaption.of("deny.you_got_denied"), new TagResolver[0]);
        if (plot.equals(location2.getPlot())) {
            Location location3 = this.worldUtil.getSpawn(this.plotAreaManager.getAllWorlds()[0]);
            if (plot.equals(location3.getPlot())) {
                plotPlayer.kick("You got kicked from the plot! This server did not set up a loaded spawn, so you got kicked from the server.");
            } else {
                plotPlayer.teleport(location3, TeleportCause.DENIED);
            }
        } else {
            plotPlayer.teleport(location2, TeleportCause.DENIED);
        }
    }
}

