/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SetCommand;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.events.PlotFlagAddEvent;
import com.plotsquared.core.events.PlotFlagRemoveEvent;
import com.plotsquared.core.events.Result;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.plot.flag.implementations.DescriptionFlag;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.google.Inject;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="setdescription", permission="plots.set.desc", usage="/plot desc <description>", aliases={"desc", "setdesc", "setd", "description"}, category=CommandCategory.SETTINGS, requiredType=RequiredType.PLAYER)
public class Desc
extends SetCommand {
    private final EventDispatcher eventDispatcher;

    @Inject
    public Desc(@NonNull EventDispatcher eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
    }

    @Override
    public boolean set(PlotPlayer<?> plotPlayer, Plot plot, String string) {
        if (string.isEmpty()) {
            PlotFlagRemoveEvent plotFlagRemoveEvent = this.eventDispatcher.callFlagRemove(plot.getFlagContainer().getFlag(DescriptionFlag.class), plot);
            if (plotFlagRemoveEvent.getEventResult() == Result.DENY) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("events.event_denied"), TagResolver.resolver("value", Tag.inserting(Component.text("Description removal"))));
                return false;
            }
            plot.removeFlag(plotFlagRemoveEvent.getFlag());
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("desc.desc_unset"), new TagResolver[0]);
            return true;
        }
        PlotFlagAddEvent plotFlagAddEvent = this.eventDispatcher.callFlagAdd((PlotFlag<?, ?>)plot.getFlagContainer().getFlag(DescriptionFlag.class).createFlagInstance(string), plot);
        if (plotFlagAddEvent.getEventResult() == Result.DENY) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("events.event_denied"), TagResolver.resolver("value", Tag.inserting(Component.text("Description set"))));
            return false;
        }
        boolean bl = plot.setFlag(plotFlagAddEvent.getFlag());
        if (!bl) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("flag.flag_not_added"), new TagResolver[0]);
            return false;
        }
        plotPlayer.sendMessage((Caption)TranslatableCaption.of("desc.desc_set"), new TagResolver[0]);
        return true;
    }
}

