/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.events.PlotDoneEvent;
import com.plotsquared.core.events.PlotFlagAddEvent;
import com.plotsquared.core.events.Result;
import com.plotsquared.core.generator.HybridUtils;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.expiration.PlotAnalysis;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.plot.flag.implementations.DoneFlag;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.task.RunnableVal;
import com.plotsquared.google.Inject;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="done", aliases={"submit"}, permission="plots.done", category=CommandCategory.SETTINGS, requiredType=RequiredType.NONE)
public class Done
extends SubCommand {
    private final EventDispatcher eventDispatcher;
    private final HybridUtils hybridUtils;

    @Inject
    public Done(@NonNull EventDispatcher eventDispatcher, @NonNull HybridUtils hybridUtils) {
        this.eventDispatcher = eventDispatcher;
        this.hybridUtils = hybridUtils;
    }

    @Override
    public boolean onCommand(final PlotPlayer<?> plotPlayer, String[] stringArray) {
        boolean bl;
        Location location = plotPlayer.getLocation();
        final Plot plot = location.getPlotAbs();
        if (plot == null || !plot.hasOwner()) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
            return false;
        }
        PlotDoneEvent plotDoneEvent = this.eventDispatcher.callDone(plot);
        if (plotDoneEvent.getEventResult() == Result.DENY) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("events.event_denied"), TagResolver.resolver("value", Tag.inserting(Component.text("Done"))));
            return true;
        }
        boolean bl2 = bl = plotDoneEvent.getEventResult() == Result.FORCE;
        if (!(bl || plot.isOwner(plotPlayer.getUUID()) || plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_COMMAND_DONE))) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_plot_perms"), new TagResolver[0]);
            return false;
        }
        if (DoneFlag.isDone(plot)) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("done.done_already_done"), new TagResolver[0]);
            return false;
        }
        if (plot.getRunning() > 0) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.wait_for_timer"), new TagResolver[0]);
            return false;
        }
        plot.addRunning();
        plotPlayer.sendMessage((Caption)TranslatableCaption.of("web.generating_link"), TagResolver.resolver("plot", Tag.inserting(Component.text(plot.getId().toString()))));
        final Settings.Auto_Clear auto_Clear = Settings.AUTO_CLEAR.get("done");
        if (PlotSquared.platform().expireManager() == null || auto_Clear == null) {
            this.finish(plot, plotPlayer, true);
            plot.removeRunning();
        } else {
            this.hybridUtils.analyzePlot(plot, new RunnableVal<PlotAnalysis>(){

                @Override
                public void run(PlotAnalysis plotAnalysis) {
                    plot.removeRunning();
                    boolean bl = plotAnalysis.getComplexity(auto_Clear) >= auto_Clear.THRESHOLD;
                    Done.this.finish(plot, plotPlayer, bl);
                }
            });
        }
        return true;
    }

    private void finish(Plot plot, PlotPlayer<?> plotPlayer, boolean bl) {
        if (!bl) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("done.done_insufficient_complexity"), new TagResolver[0]);
            return;
        }
        long l = System.currentTimeMillis() / 1000L;
        Object f = plot.getFlagContainer().getFlag(DoneFlag.class).createFlagInstance(Long.toString(l));
        PlotFlagAddEvent plotFlagAddEvent = this.eventDispatcher.callFlagAdd((PlotFlag<?, ?>)f, plot);
        if (plotFlagAddEvent.getEventResult() == Result.DENY) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("events.event_denied"), new TagResolver[0]);
            return;
        }
        plot.setFlag(f);
        plotPlayer.sendMessage((Caption)TranslatableCaption.of("done.done_success"), new TagResolver[0]);
    }
}

