/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.MainCommand;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.TextComponent;
import com.plotsquared.core.configuration.adventure.text.format.Style;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.CaptionUtility;
import com.plotsquared.core.configuration.caption.StaticCaption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.events.PlotFlagAddEvent;
import com.plotsquared.core.events.PlotFlagRemoveEvent;
import com.plotsquared.core.events.Result;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.flag.FlagParseException;
import com.plotsquared.core.plot.flag.GlobalFlagContainer;
import com.plotsquared.core.plot.flag.InternalFlag;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.plot.flag.types.IntegerFlag;
import com.plotsquared.core.plot.flag.types.ListFlag;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.StringComparison;
import com.plotsquared.core.util.StringMan;
import com.plotsquared.core.util.helpmenu.HelpMenu;
import com.plotsquared.core.util.task.RunnableVal2;
import com.plotsquared.core.util.task.RunnableVal3;
import com.plotsquared.google.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@CommandDeclaration(command="flag", aliases={"f", "flag"}, usage="/plot flag <set | remove | add | list | info> <flag> <value>", category=CommandCategory.SETTINGS, requiredType=RequiredType.NONE, permission="plots.flag")
public final class FlagCommand
extends Command {
    private final EventDispatcher eventDispatcher;

    @Inject
    public FlagCommand(@NonNull EventDispatcher eventDispatcher) {
        super(MainCommand.getInstance(), true);
        this.eventDispatcher = eventDispatcher;
    }

    private static boolean sendMessage(PlotPlayer<?> plotPlayer) {
        plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot flag <set | remove | add | list | info> <flag> <value>"))));
        return true;
    }

    private static boolean checkPermValue(@NonNull PlotPlayer<?> plotPlayer, @NonNull PlotFlag<?, ?> plotFlag, @NonNull String string, @NonNull String string2) {
        boolean bl;
        string = string.toLowerCase();
        string2 = string2.toLowerCase();
        String string3 = Permission.PERMISSION_SET_FLAG_KEY_VALUE.format(string.toLowerCase(), string2.toLowerCase());
        if (plotFlag instanceof IntegerFlag && MathMan.isInteger(string2)) {
            try {
                int n = Integer.parseInt(string2);
                string3 = string3.substring(0, string3.length() - string2.length() - 1);
                boolean bl2 = false;
                if (n > 0) {
                    int n2 = PlotSquared.get().getPlatform().equalsIgnoreCase("bukkit") ? n : Settings.Limit.MAX_PLOTS;
                    boolean bl3 = bl2 = plotPlayer.hasPermissionRange(string3, n2) >= n;
                }
                if (!bl2) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Component.text(string3 + "." + n))));
                }
                return bl2;
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (plotFlag instanceof ListFlag) {
            ListFlag listFlag = (ListFlag)plotFlag;
            try {
                Object f = listFlag.parse(string2);
                for (Object e : (List)((PlotFlag)f).getValue()) {
                    String string4 = Permission.PERMISSION_SET_FLAG_KEY_VALUE.format(string.toLowerCase(), e.toString().toLowerCase());
                    boolean bl4 = plotPlayer.hasPermission(string4);
                    if (bl4) continue;
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Component.text(string4))));
                    return false;
                }
            }
            catch (FlagParseException flagParseException) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("flag.flag_parse_error"), TagResolver.builder().tag("flag_name", Tag.inserting(Component.text(plotFlag.getName()))).tag("flag_value", Tag.inserting(Component.text(flagParseException.getValue()))).tag("error", Tag.inserting(flagParseException.getErrorMessage().toComponent(plotPlayer))).build());
                return false;
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }
        String string5 = Permission.PERMISSION_SET_FLAG_KEY.format(string.toLowerCase());
        if (plotFlag.isValuedPermission()) {
            bl = plotPlayer.hasKeyedPermission(string5, string2);
        } else {
            bl = plotPlayer.hasPermission(string5);
            string3 = string5;
        }
        if (!bl) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Component.text(string3))));
        }
        return bl;
    }

    private static boolean checkRequirements(@NonNull PlotPlayer<?> plotPlayer) {
        Location location = plotPlayer.getLocation();
        Plot plot = location.getPlotAbs();
        if (plot == null) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
            return false;
        }
        if (!plot.hasOwner()) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("working.plot_not_claimed"), new TagResolver[0]);
            return false;
        }
        if (!plot.isOwner(plotPlayer.getUUID()) && !plotPlayer.hasPermission(Permission.PERMISSION_SET_FLAG_OTHER)) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_SET_FLAG_OTHER)));
            return false;
        }
        return true;
    }

    private static @Nullable PlotFlag<?, ?> getFlag(@NonNull PlotPlayer<?> plotPlayer, @NonNull String string) {
        if (string.length() > 0) {
            PlotFlag<?, ?> plotFlag = GlobalFlagContainer.getInstance().getFlagFromString(string);
            if (plotFlag instanceof InternalFlag || plotFlag == null) {
                boolean bl = false;
                try {
                    StringComparison<PlotFlag> stringComparison = new StringComparison<PlotFlag>(string, GlobalFlagContainer.getInstance().getFlagMap().values(), PlotFlag::getName);
                    String string2 = stringComparison.getBestMatch();
                    if (string2 != null) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("flag.not_valid_flag_suggested"), TagResolver.resolver("value", Tag.inserting(Component.text(string2))));
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!bl) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("flag.not_valid_flag"), new TagResolver[0]);
                }
                return null;
            }
            return plotFlag;
        }
        return null;
    }

    @Override
    public CompletableFuture<Boolean> execute(PlotPlayer<?> plotPlayer, String[] stringArray, RunnableVal3<Command, Runnable, Runnable> runnableVal3, RunnableVal2<Command, Command.CommandResult> runnableVal2) {
        if (stringArray.length == 0 || !Arrays.asList("set", "s", "list", "l", "delete", "remove", "r", "add", "a", "info", "i").contains(stringArray[0].toLowerCase(Locale.ENGLISH))) {
            new HelpMenu(plotPlayer).setCategory(CommandCategory.SETTINGS).setCommands(this.getCommands()).generateMaxPages().generatePage(0, this.getParent().toString(), plotPlayer).render();
            return CompletableFuture.completedFuture(true);
        }
        return super.execute(plotPlayer, stringArray, runnableVal3, runnableVal2);
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> plotPlayer, String[] stringArray, boolean bl) {
        if (stringArray.length == 1) {
            return Stream.of("set", "add", "remove", "delete", "info", "list").filter(string -> string.startsWith(stringArray[0].toLowerCase(Locale.ENGLISH))).map(string -> new Command(null, false, (String)string, "", RequiredType.NONE, null){}).collect(Collectors.toList());
        }
        if (Arrays.asList("set", "add", "remove", "delete", "info").contains(stringArray[0].toLowerCase(Locale.ENGLISH)) && stringArray.length == 2) {
            return GlobalFlagContainer.getInstance().getRecognizedPlotFlags().stream().filter(plotFlag -> !(plotFlag instanceof InternalFlag)).filter(plotFlag -> plotFlag.getName().startsWith(stringArray[1].toLowerCase(Locale.ENGLISH))).map(plotFlag -> new Command(null, false, plotFlag.getName(), "", RequiredType.NONE, null){}).collect(Collectors.toList());
        }
        if (Arrays.asList("set", "add", "remove", "delete").contains(stringArray[0].toLowerCase(Locale.ENGLISH)) && stringArray.length == 3) {
            try {
                PlotFlag<?, ?> plotFlag2 = GlobalFlagContainer.getInstance().getFlagFromString(stringArray[1]);
                if (plotFlag2 != null) {
                    Stream<String> stream = plotFlag2.getTabCompletions().stream();
                    if (plotFlag2 instanceof ListFlag && stringArray[2].contains(",")) {
                        String string3;
                        String[] stringArray2 = stringArray[2].split(",");
                        StringBuilder stringBuilder = new StringBuilder();
                        for (int i = 0; i < stringArray2.length - 1; ++i) {
                            stringBuilder.append(stringArray2[i]).append(",");
                        }
                        if (!stringArray[2].endsWith(",")) {
                            string3 = stringArray2[stringArray2.length - 1];
                        } else {
                            stringBuilder.append(stringArray2[stringArray2.length - 1]).append(",");
                            string3 = "";
                        }
                        return stream.filter(string2 -> string2.startsWith(string3.toLowerCase(Locale.ENGLISH))).map(string -> new Command(null, false, stringBuilder + string, "", RequiredType.NONE, null){}).collect(Collectors.toList());
                    }
                    return stream.filter(string -> string.startsWith(stringArray[2].toLowerCase(Locale.ENGLISH))).map(string -> new Command(null, false, (String)string, "", RequiredType.NONE, null){}).collect(Collectors.toList());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.tabOf(plotPlayer, stringArray, bl, new String[0]);
    }

    @CommandDeclaration(command="set", aliases={"s", "set"}, usage="/plot flag set <flag> <value>", category=CommandCategory.SETTINGS, requiredType=RequiredType.NONE, permission="plots.set.flag")
    public void set(Command command, PlotPlayer<?> plotPlayer, String[] stringArray, RunnableVal3<Command, Runnable, Runnable> runnableVal3, RunnableVal2<Command, Command.CommandResult> runnableVal2) {
        Object obj;
        if (!FlagCommand.checkRequirements(plotPlayer)) {
            return;
        }
        if (stringArray.length < 2) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot flag set <flag> <value>"))));
            return;
        }
        PlotFlag<?, ?> plotFlag = FlagCommand.getFlag(plotPlayer, stringArray[0]);
        if (plotFlag == null) {
            return;
        }
        Plot plot = plotPlayer.getLocation().getPlotAbs();
        PlotFlagAddEvent plotFlagAddEvent = this.eventDispatcher.callFlagAdd(plotFlag, plot);
        if (plotFlagAddEvent.getEventResult() == Result.DENY) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("events.event_denied"), TagResolver.resolver("value", Tag.inserting(Component.text("Flag set"))));
            return;
        }
        boolean bl = plotFlagAddEvent.getEventResult() == Result.FORCE;
        String string = StringMan.join(Arrays.copyOfRange(stringArray, 1, stringArray.length), " ");
        if (!bl && !FlagCommand.checkPermValue(plotPlayer, plotFlag, stringArray[0], string)) {
            return;
        }
        string = CaptionUtility.stripClickEvents(plotFlag, string);
        try {
            obj = plotFlag.parse(string);
        }
        catch (FlagParseException flagParseException) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("flag.flag_parse_error"), TagResolver.builder().tag("flag_name", Tag.inserting(Component.text(plotFlag.getName()))).tag("flag_value", Tag.inserting(Component.text(flagParseException.getValue()))).tag("error", Tag.inserting(flagParseException.getErrorMessage().toComponent(plotPlayer))).build());
            return;
        }
        plot.setFlag(obj);
        plotPlayer.sendMessage((Caption)TranslatableCaption.of("flag.flag_added"), TagResolver.builder().tag("flag", Tag.inserting(Component.text(stringArray[0]))).tag("value", Tag.inserting(Component.text(((PlotFlag)obj).toString()))).build());
    }

    @CommandDeclaration(command="add", aliases={"a", "add"}, usage="/plot flag add <flag> <value>", category=CommandCategory.SETTINGS, requiredType=RequiredType.NONE, permission="plots.flag.add")
    public void add(Command command, PlotPlayer<?> plotPlayer, String[] stringArray, RunnableVal3<Command, Runnable, Runnable> runnableVal3, RunnableVal2<Command, Command.CommandResult> runnableVal2) {
        Object obj;
        if (!FlagCommand.checkRequirements(plotPlayer)) {
            return;
        }
        if (stringArray.length < 2) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot flag add <flag> <values>"))));
            return;
        }
        PlotFlag<?, ?> plotFlag = FlagCommand.getFlag(plotPlayer, stringArray[0]);
        if (plotFlag == null) {
            return;
        }
        Plot plot = plotPlayer.getLocation().getPlotAbs();
        PlotFlagAddEvent plotFlagAddEvent = this.eventDispatcher.callFlagAdd(plotFlag, plot);
        if (plotFlagAddEvent.getEventResult() == Result.DENY) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("events.event_denied"), TagResolver.resolver("value", Tag.inserting(Component.text("Flag add"))));
            return;
        }
        boolean bl = plotFlagAddEvent.getEventResult() == Result.FORCE;
        Object obj2 = plotPlayer.getLocation().getPlotAbs().getFlagContainer().getFlag(plotFlagAddEvent.getFlag().getClass());
        if (!bl) {
            for (String string : stringArray[1].split(",")) {
                if (FlagCommand.checkPermValue(plotPlayer, plotFlagAddEvent.getFlag(), stringArray[0], string)) continue;
                return;
            }
        }
        String string = StringMan.join(Arrays.copyOfRange(stringArray, 1, stringArray.length), " ");
        try {
            obj = plotFlagAddEvent.getFlag().parse(string);
        }
        catch (FlagParseException flagParseException) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("flag.flag_parse_error"), TagResolver.builder().tag("flag_name", Tag.inserting(Component.text(plotFlag.getName()))).tag("flag_value", Tag.inserting(Component.text(flagParseException.getValue()))).tag("error", Tag.inserting(flagParseException.getErrorMessage().toComponent(plotPlayer))).build());
            return;
        }
        int flagParseException = plotPlayer.getLocation().getPlotAbs().setFlag(((PlotFlag)obj2).merge(((PlotFlag)obj).getValue())) ? 1 : 0;
        if (flagParseException == 0) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("flag.flag_not_added"), new TagResolver[0]);
            return;
        }
        plotPlayer.sendMessage((Caption)TranslatableCaption.of("flag.flag_added"), TagResolver.builder().tag("flag", Tag.inserting(Component.text(stringArray[0]))).tag("value", Tag.inserting(Component.text(((PlotFlag)obj).toString()))).build());
    }

    @CommandDeclaration(command="remove", aliases={"r", "remove", "delete"}, usage="/plot flag remove <flag> [values]", category=CommandCategory.SETTINGS, requiredType=RequiredType.NONE, permission="plots.flag.remove")
    public void remove(Command command, PlotPlayer<?> plotPlayer, String[] stringArray, RunnableVal3<Command, Runnable, Runnable> runnableVal3, RunnableVal2<Command, Command.CommandResult> runnableVal2) {
        if (!FlagCommand.checkRequirements(plotPlayer)) {
            return;
        }
        if (stringArray.length != 1 && stringArray.length != 2) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot flag remove <flag> [values]"))));
            return;
        }
        PlotFlag<?, ?> plotFlag = FlagCommand.getFlag(plotPlayer, stringArray[0]);
        if (plotFlag == null) {
            return;
        }
        Plot plot = plotPlayer.getLocation().getPlotAbs();
        Object obj = plot.getFlagContainer().getFlag(plotFlag.getClass());
        PlotFlagRemoveEvent plotFlagRemoveEvent = this.eventDispatcher.callFlagRemove(plotFlag, plot);
        if (plotFlagRemoveEvent.getEventResult() == Result.DENY) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("events.event_denied"), TagResolver.resolver("value", Tag.inserting(Component.text("Flag remove"))));
            return;
        }
        boolean bl = plotFlagRemoveEvent.getEventResult() == Result.FORCE;
        plotFlag = plotFlagRemoveEvent.getFlag();
        if (!bl && !plotPlayer.hasPermission(Permission.PERMISSION_SET_FLAG_KEY.format(stringArray[0].toLowerCase())) && stringArray.length != 2) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Component.text(Permission.PERMISSION_SET_FLAG_KEY.format(stringArray[0].toLowerCase())))));
            return;
        }
        if (stringArray.length == 2 && plotFlag instanceof ListFlag) {
            Object f;
            ListFlag listFlag = (ListFlag)plotFlag;
            String string = StringMan.join(Arrays.copyOfRange(stringArray, 1, stringArray.length), " ");
            ArrayList arrayList = new ArrayList((Collection)plot.getFlag(listFlag.getClass()));
            try {
                f = listFlag.parse(string);
            }
            catch (FlagParseException flagParseException) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("flag.flag_parse_error"), TagResolver.builder().tag("flag_name", Tag.inserting(Component.text(plotFlag.getName()))).tag("flag_value", Tag.inserting(Component.text(flagParseException.getValue()))).tag("error", Tag.inserting(flagParseException.getErrorMessage().toComponent(plotPlayer))).build());
                return;
            }
            if (((List)((PlotFlag)f).getValue()).isEmpty()) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("flag.flag_not_removed"), new TagResolver[0]);
                return;
            }
            if (arrayList.removeAll((List)((PlotFlag)f).getValue())) {
                if (arrayList.isEmpty()) {
                    if (plot.removeFlag(plotFlag)) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("flag.flag_removed"), TagResolver.builder().tag("flag", Tag.inserting(Component.text(stringArray[0]))).tag("value", Tag.inserting(Component.text(plotFlag.toString()))).build());
                        return;
                    }
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("flag.flag_not_removed"), new TagResolver[0]);
                    return;
                }
                Object f2 = ((PlotFlag)f).createFlagInstance(arrayList);
                PlotFlagAddEvent plotFlagAddEvent = this.eventDispatcher.callFlagAdd((PlotFlag<?, ?>)f2, plot);
                if (plotFlagAddEvent.getEventResult() == Result.DENY) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("events.event_denied"), TagResolver.resolver("value", Tag.inserting(Component.text("Re-addition of " + ((PlotFlag)f2).getName()))));
                    return;
                }
                if (plot.setFlag(plotFlagAddEvent.getFlag())) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("flag.flag_partially_removed"), new TagResolver[0]);
                    return;
                }
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("flag.flag_not_removed"), new TagResolver[0]);
                return;
            }
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("flag.flag_not_removed"), new TagResolver[0]);
            return;
        }
        boolean bl2 = plot.removeFlag(plotFlag);
        if (!bl2) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("flag.flag_not_removed"), new TagResolver[0]);
            return;
        }
        plotPlayer.sendMessage((Caption)TranslatableCaption.of("flag.flag_removed"), TagResolver.builder().tag("flag", Tag.inserting(Component.text(stringArray[0]))).tag("value", Tag.inserting(Component.text(plotFlag.toString()))).build());
    }

    @CommandDeclaration(command="list", aliases={"l", "list", "flags"}, usage="/plot flag list", category=CommandCategory.SETTINGS, requiredType=RequiredType.NONE, permission="plots.flag.list")
    public void list(Command command, PlotPlayer<?> plotPlayer, String[] stringArray, RunnableVal3<Command, Runnable, Runnable> runnableVal3, RunnableVal2<Command, Command.CommandResult> runnableVal2) {
        Object object;
        Component component2;
        if (!FlagCommand.checkRequirements(plotPlayer)) {
            return;
        }
        HashMap<Component, ArrayList> hashMap = new HashMap<Component, ArrayList>();
        for (PlotFlag<?, ?> plotFlag : GlobalFlagContainer.getInstance().getRecognizedPlotFlags()) {
            if (plotFlag instanceof InternalFlag) continue;
            component2 = plotFlag.getFlagCategory().toComponent(plotPlayer);
            object = hashMap.computeIfAbsent(component2, component -> new ArrayList());
            object.add(plotFlag.getName());
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            Collections.sort((List)entry.getValue());
            component2 = MINI_MESSAGE.deserialize(TranslatableCaption.of("flag.flag_list_categories").getComponent(plotPlayer), (TagResolver)TagResolver.resolver("category", Tag.inserting(((Component)entry.getKey()).style(Style.empty()))));
            object = (TextComponent.Builder)Component.text().append(component2);
            Iterator iterator = ((ArrayList)entry.getValue()).iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                object.append(MINI_MESSAGE.deserialize(TranslatableCaption.of("flag.flag_list_flag").getComponent(plotPlayer), TagResolver.builder().tag("command", Tag.preProcessParsed("/plot flag info " + string)).tag("flag", Tag.inserting(Component.text(string))).tag("suffix", Tag.inserting(Component.text(iterator.hasNext() ? ", " : ""))).build()));
            }
            plotPlayer.sendMessage((Caption)StaticCaption.of((String)MINI_MESSAGE.serialize(object.build())), new TagResolver[0]);
        }
    }

    @CommandDeclaration(command="info", aliases={"i", "info"}, usage="/plot flag info <flag>", category=CommandCategory.SETTINGS, requiredType=RequiredType.NONE, permission="plots.flag.info")
    public void info(Command command, PlotPlayer<?> plotPlayer, String[] stringArray, RunnableVal3<Command, Runnable, Runnable> runnableVal3, RunnableVal2<Command, Command.CommandResult> runnableVal2) {
        if (!FlagCommand.checkRequirements(plotPlayer)) {
            return;
        }
        if (stringArray.length < 1) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot flag info <flag>"))));
            return;
        }
        PlotFlag<?, ?> plotFlag = FlagCommand.getFlag(plotPlayer, stringArray[0]);
        if (plotFlag != null) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("flag.flag_info_header"), new TagResolver[0]);
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("flag.flag_info_name"), TagResolver.resolver("flag", Tag.inserting(Component.text(plotFlag.getName()))));
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("flag.flag_info_category"), TagResolver.resolver("value", Tag.inserting(plotFlag.getFlagCategory().toComponent(plotPlayer))));
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("flag.flag_info_description"), new TagResolver[0]);
            plotPlayer.sendMessage(plotFlag.getFlagDescription(), new TagResolver[0]);
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("flag.flag_info_example"), TagResolver.builder().tag("command", Tag.preProcessParsed("/plot flag set")).tag("flag", Tag.preProcessParsed(plotFlag.getName())).tag("value", Tag.preProcessParsed(plotFlag.getExample())).build());
            String string = plotPlayer.getLocation().getPlotArea().getFlagContainer().getFlagErased(plotFlag.getClass()).toString();
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("flag.flag_info_default_value"), TagResolver.resolver("value", Tag.inserting(Component.text(string))));
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("flag.flag_info_footer"), new TagResolver[0]);
        }
    }
}

