/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.Argument;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.PlayerManager;
import com.plotsquared.core.util.TabCompletions;
import com.plotsquared.core.util.WorldUtil;
import com.plotsquared.google.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="kick", aliases={"k"}, permission="plots.kick", usage="/plot kick <player | *>", category=CommandCategory.TELEPORT, requiredType=RequiredType.PLAYER)
public class Kick
extends SubCommand {
    private final PlotAreaManager plotAreaManager;
    private final WorldUtil worldUtil;

    @Inject
    public Kick(@NonNull PlotAreaManager plotAreaManager, @NonNull WorldUtil worldUtil) {
        super(Argument.PlayerName);
        this.plotAreaManager = plotAreaManager;
        this.worldUtil = worldUtil;
    }

    @Override
    public boolean onCommand(PlotPlayer<?> plotPlayer, String[] stringArray) {
        Location location = plotPlayer.getLocation();
        Plot plot = location.getPlot();
        if (plot == null) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
            return false;
        }
        if (!(plot.hasOwner() && plot.isOwner(plotPlayer.getUUID()) || plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_COMMAND_KICK))) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_plot_perms"), new TagResolver[0]);
            return false;
        }
        PlayerManager.getUUIDsFromString(stringArray[0], (collection, throwable) -> {
            if (throwable instanceof TimeoutException) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("players.fetching_players_timeout"), new TagResolver[0]);
            } else if (throwable != null || collection.isEmpty()) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.invalid_player"), TagResolver.resolver("value", Tag.inserting(Component.text(stringArray[0]))));
            } else {
                PlotPlayer<?> plotPlayer2;
                HashSet<Object> hashSet = new HashSet<Object>();
                for (Object object : collection) {
                    if (object == DBFunc.EVERYONE) {
                        for (PlotPlayer object2 : plot.getPlayersInPlot()) {
                            if (object2 == plotPlayer || object2.hasPermission(Permission.PERMISSION_ADMIN_ENTRY_DENIED)) continue;
                            hashSet.add(object2);
                        }
                        continue;
                    }
                    plotPlayer2 = PlotSquared.platform().playerManager().getPlayerIfExists((UUID)object);
                    if (plotPlayer2 == null) continue;
                    hashSet.add(plotPlayer2);
                }
                hashSet.remove(plotPlayer);
                if (hashSet.isEmpty()) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.invalid_player"), TagResolver.resolver("value", Tag.inserting(Component.text(stringArray[0]))));
                    return;
                }
                for (Object object : hashSet) {
                    if (!plot.equals(((PlotPlayer)object).getCurrentPlot())) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("kick.player_not_in_plot"), TagResolver.resolver("player", Tag.inserting(Component.text(object.getName()))));
                        return;
                    }
                    if (object.hasPermission(Permission.PERMISSION_ADMIN_ENTRY_DENIED)) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("kick.cannot_kick_player"), TagResolver.resolver("player", Tag.inserting(Component.text(object.getName()))));
                        return;
                    }
                    plotPlayer2 = this.worldUtil.getSpawn(location.getWorldName());
                    ((PlotPlayer)object).sendMessage((Caption)TranslatableCaption.of("kick.you_got_kicked"), new TagResolver[0]);
                    if (plot.equals(((Location)((Object)plotPlayer2)).getPlot())) {
                        Location location2 = this.worldUtil.getSpawn(this.plotAreaManager.getAllWorlds()[0]);
                        if (plot.equals(location2.getPlot())) {
                            ((PlotPlayer)object).kick("You got kicked from the plot! This server did not set up a loaded spawn, so you got kicked from the server.");
                            continue;
                        }
                        ((PlotPlayer)object).plotkick(location2);
                        continue;
                    }
                    ((PlotPlayer)object).plotkick((Location)((Object)plotPlayer2));
                }
            }
        });
        return true;
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> plotPlayer, String[] stringArray, boolean bl) {
        Location location = plotPlayer.getLocation();
        Plot plot = location.getPlotAbs();
        if (plot == null) {
            return Collections.emptyList();
        }
        return TabCompletions.completePlayersInPlot(plot, String.join((CharSequence)",", stringArray).trim(), Collections.singletonList(plotPlayer.getName()));
    }
}

