/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.StaticCaption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.PlayerMetaDataKeys;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.schematic.Schematic;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.SchematicHandler;
import com.plotsquared.core.util.TimeUtil;
import com.plotsquared.core.util.task.RunnableVal;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.google.Inject;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="load", aliases={"restore"}, category=CommandCategory.SCHEMATIC, requiredType=RequiredType.NONE, permission="plots.load", usage="/plot load")
public class Load
extends SubCommand {
    private final PlotAreaManager plotAreaManager;
    private final SchematicHandler schematicHandler;

    @Inject
    public Load(@NonNull PlotAreaManager plotAreaManager, @NonNull SchematicHandler schematicHandler) {
        this.plotAreaManager = plotAreaManager;
        this.schematicHandler = schematicHandler;
    }

    @Override
    public boolean onCommand(final PlotPlayer<?> plotPlayer, String[] stringArray) {
        String string = plotPlayer.getLocation().getWorldName();
        if (!this.plotAreaManager.hasPlotArea(string)) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot_world"), new TagResolver[0]);
            return false;
        }
        final Plot plot = plotPlayer.getCurrentPlot();
        if (plot == null) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
            return false;
        }
        if (!plot.hasOwner()) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("info.plot_unowned"), new TagResolver[0]);
            return false;
        }
        if (!plot.isOwner(plotPlayer.getUUID()) && !plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_COMMAND_LOAD)) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_plot_perms"), new TagResolver[0]);
            return false;
        }
        if (plot.getRunning() > 0) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.wait_for_timer"), new TagResolver[0]);
            return false;
        }
        try (MetaDataAccess<List<String>> metaDataAccess = plotPlayer.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_SCHEMATICS);){
            if (stringArray.length != 0) {
                if (stringArray.length == 1) {
                    URL uRL;
                    String string2;
                    List list = metaDataAccess.get().orElse(null);
                    if (list == null) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("web.load_null"), TagResolver.resolver("command", Tag.inserting(Component.text("/plot load"))));
                        boolean bl = false;
                        return bl;
                    }
                    try {
                        string2 = (String)list.get(Integer.parseInt(stringArray[0]) - 1);
                    }
                    catch (Exception exception) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("invalid.not_valid_number"), TagResolver.resolver("value", Tag.inserting(Component.text("(1, " + list.size() + ")"))));
                        boolean bl = false;
                        if (metaDataAccess != null) {
                            metaDataAccess.close();
                        }
                        return bl;
                    }
                    try {
                        uRL = URI.create(Settings.Web.URL + "saves/" + plotPlayer.getUUID() + "/" + string2).toURL();
                    }
                    catch (MalformedURLException malformedURLException) {
                        malformedURLException.printStackTrace();
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("web.load_failed"), new TagResolver[0]);
                        boolean bl = false;
                        if (metaDataAccess != null) {
                            metaDataAccess.close();
                        }
                        return bl;
                    }
                    plot.addRunning();
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("working.generating_component"), new TagResolver[0]);
                    TaskManager.runTaskAsync(() -> {
                        Schematic schematic = this.schematicHandler.getSchematic(uRL);
                        if (schematic == null) {
                            plot.removeRunning();
                            plotPlayer.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_invalid"), TagResolver.resolver("reason", Tag.inserting(Component.text("non-existent or not in gzip format"))));
                            return;
                        }
                        PlotArea plotArea = plot.getArea();
                        this.schematicHandler.paste(schematic, plot, 0, plotArea.getMinBuildHeight(), 0, false, plotPlayer, new RunnableVal<Boolean>(){

                            @Override
                            public void run(Boolean bl) {
                                plot.removeRunning();
                                if (bl.booleanValue()) {
                                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_paste_success"), new TagResolver[0]);
                                } else {
                                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_paste_failed"), new TagResolver[0]);
                                }
                            }
                        });
                    });
                    boolean bl = true;
                    return bl;
                }
                plot.removeRunning();
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot load <index>"))));
                boolean bl = false;
                return bl;
            }
            List list = metaDataAccess.get().orElse(null);
            if (list == null) {
                plot.addRunning();
                TaskManager.runTaskAsync(() -> {
                    List<String> list = this.schematicHandler.getSaves(plotPlayer.getUUID());
                    plot.removeRunning();
                    if (list == null || list.isEmpty()) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("web.load_failed"), new TagResolver[0]);
                        return;
                    }
                    metaDataAccess.set(list);
                    this.displaySaves(plotPlayer);
                });
            } else {
                this.displaySaves(plotPlayer);
            }
        }
        return true;
    }

    public void displaySaves(PlotPlayer<?> plotPlayer) {
        try (MetaDataAccess<List<String>> metaDataAccess = plotPlayer.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_SCHEMATICS);){
            List list = metaDataAccess.get().orElse(Collections.emptyList());
            for (int i = 0; i < Math.min(list.size(), 32); ++i) {
                try {
                    String string = ((String)list.get(i)).split("\\.")[0];
                    String[] stringArray = string.split("_");
                    if (stringArray.length < 5) continue;
                    String string2 = TimeUtil.secToTime(System.currentTimeMillis() / 1000L - Long.parseLong(stringArray[0]));
                    String string3 = stringArray[1];
                    PlotId plotId = PlotId.fromString(stringArray[2] + ";" + stringArray[3]);
                    String string4 = stringArray[4];
                    String string5 = "<dark_aqua>";
                    plotPlayer.sendMessage((Caption)StaticCaption.of("<dark_gray>[</dark_gray><gray>" + (i + 1) + "</gray><dark_aqua>] </dark_aqua>" + string5 + string2 + "<dark_gray> | </dark_gray>" + string5 + string3 + ";" + plotId + "<dark_gray> | </dark_gray>" + string5 + string4 + "x" + string4), new TagResolver[0]);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("web.load_list"), TagResolver.resolver("command", Tag.inserting(Component.text("/plot load #"))));
        }
    }
}

