/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.Add;
import com.plotsquared.core.command.Alias;
import com.plotsquared.core.command.Area;
import com.plotsquared.core.command.Auto;
import com.plotsquared.core.command.Backup;
import com.plotsquared.core.command.Biome;
import com.plotsquared.core.command.Buy;
import com.plotsquared.core.command.Caps;
import com.plotsquared.core.command.Claim;
import com.plotsquared.core.command.Clear;
import com.plotsquared.core.command.Cluster;
import com.plotsquared.core.command.CmdConfirm;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.Comment;
import com.plotsquared.core.command.Condense;
import com.plotsquared.core.command.Confirm;
import com.plotsquared.core.command.Continue;
import com.plotsquared.core.command.Copy;
import com.plotsquared.core.command.CreateRoadSchematic;
import com.plotsquared.core.command.DatabaseCommand;
import com.plotsquared.core.command.Debug;
import com.plotsquared.core.command.DebugAllowUnsafe;
import com.plotsquared.core.command.DebugExec;
import com.plotsquared.core.command.DebugImportWorlds;
import com.plotsquared.core.command.DebugLoadTest;
import com.plotsquared.core.command.DebugPaste;
import com.plotsquared.core.command.DebugRoadRegen;
import com.plotsquared.core.command.DebugSaveTest;
import com.plotsquared.core.command.Delete;
import com.plotsquared.core.command.Deny;
import com.plotsquared.core.command.Desc;
import com.plotsquared.core.command.Dislike;
import com.plotsquared.core.command.Done;
import com.plotsquared.core.command.Download;
import com.plotsquared.core.command.FlagCommand;
import com.plotsquared.core.command.Grant;
import com.plotsquared.core.command.Help;
import com.plotsquared.core.command.HomeCommand;
import com.plotsquared.core.command.Inbox;
import com.plotsquared.core.command.Info;
import com.plotsquared.core.command.Kick;
import com.plotsquared.core.command.Leave;
import com.plotsquared.core.command.Like;
import com.plotsquared.core.command.ListCmd;
import com.plotsquared.core.command.Load;
import com.plotsquared.core.command.Merge;
import com.plotsquared.core.command.Middle;
import com.plotsquared.core.command.Move;
import com.plotsquared.core.command.Music;
import com.plotsquared.core.command.Near;
import com.plotsquared.core.command.Owner;
import com.plotsquared.core.command.PluginCmd;
import com.plotsquared.core.command.Purge;
import com.plotsquared.core.command.Rate;
import com.plotsquared.core.command.RegenAllRoads;
import com.plotsquared.core.command.Reload;
import com.plotsquared.core.command.Remove;
import com.plotsquared.core.command.SchematicCmd;
import com.plotsquared.core.command.Set;
import com.plotsquared.core.command.SetHome;
import com.plotsquared.core.command.Setup;
import com.plotsquared.core.command.Swap;
import com.plotsquared.core.command.Target;
import com.plotsquared.core.command.Template;
import com.plotsquared.core.command.Toggle;
import com.plotsquared.core.command.Trim;
import com.plotsquared.core.command.Trust;
import com.plotsquared.core.command.Unlink;
import com.plotsquared.core.command.Visit;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.ConsolePlayer;
import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.PlayerMetaDataKeys;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.world.SinglePlotArea;
import com.plotsquared.core.util.EconHandler;
import com.plotsquared.core.util.PlotExpression;
import com.plotsquared.core.util.task.RunnableVal2;
import com.plotsquared.core.util.task.RunnableVal3;
import com.plotsquared.google.Injector;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@CommandDeclaration(command="plot", aliases={"plots", "p", "plotsquared", "plot2", "p2", "ps", "2", "plotme", "plotz", "ap"})
public class MainCommand
extends Command {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + MainCommand.class.getSimpleName()));
    private static MainCommand instance;
    public Help help;
    public Toggle toggle;

    private MainCommand() {
        super(null, true);
        instance = this;
    }

    public static MainCommand getInstance() {
        if (instance == null) {
            instance = new MainCommand();
            Injector injector = PlotSquared.platform().injector();
            LinkedList<Class<Rate>> linkedList = new LinkedList<Class<Rate>>();
            linkedList.add(Caps.class);
            linkedList.add(Buy.class);
            if (Settings.Web.LEGACY_WEBINTERFACE) {
                LOGGER.warn("Legacy webinterface is used. Please note that it will be removed in future.");
            }
            linkedList.add(Load.class);
            linkedList.add(Confirm.class);
            linkedList.add(Template.class);
            linkedList.add(Download.class);
            linkedList.add(Setup.class);
            linkedList.add(Area.class);
            linkedList.add(DebugSaveTest.class);
            linkedList.add(DebugLoadTest.class);
            linkedList.add(CreateRoadSchematic.class);
            linkedList.add(DebugAllowUnsafe.class);
            linkedList.add(RegenAllRoads.class);
            linkedList.add(Claim.class);
            linkedList.add(Auto.class);
            linkedList.add(HomeCommand.class);
            linkedList.add(Visit.class);
            linkedList.add(Set.class);
            linkedList.add(Clear.class);
            linkedList.add(Delete.class);
            linkedList.add(Trust.class);
            linkedList.add(Add.class);
            linkedList.add(Leave.class);
            linkedList.add(Deny.class);
            linkedList.add(Remove.class);
            linkedList.add(Info.class);
            linkedList.add(Near.class);
            linkedList.add(ListCmd.class);
            linkedList.add(Debug.class);
            linkedList.add(SchematicCmd.class);
            linkedList.add(PluginCmd.class);
            linkedList.add(Purge.class);
            linkedList.add(Reload.class);
            linkedList.add(Merge.class);
            linkedList.add(DebugPaste.class);
            linkedList.add(Unlink.class);
            linkedList.add(Kick.class);
            linkedList.add(Inbox.class);
            linkedList.add(Comment.class);
            linkedList.add(DatabaseCommand.class);
            linkedList.add(Swap.class);
            linkedList.add(Music.class);
            linkedList.add(DebugRoadRegen.class);
            linkedList.add(DebugExec.class);
            linkedList.add(FlagCommand.class);
            linkedList.add(Target.class);
            linkedList.add(Move.class);
            linkedList.add(Condense.class);
            linkedList.add(Copy.class);
            linkedList.add(Trim.class);
            linkedList.add(Done.class);
            linkedList.add(Continue.class);
            linkedList.add(Middle.class);
            linkedList.add(Grant.class);
            linkedList.add(Owner.class);
            linkedList.add(Desc.class);
            linkedList.add(Biome.class);
            linkedList.add(Alias.class);
            linkedList.add(SetHome.class);
            linkedList.add(Cluster.class);
            linkedList.add(DebugImportWorlds.class);
            linkedList.add(Backup.class);
            if (Settings.Ratings.USE_LIKES) {
                linkedList.add(Like.class);
                linkedList.add(Dislike.class);
            } else {
                linkedList.add(Rate.class);
            }
            for (Class clazz : linkedList) {
                try {
                    injector.getInstance(clazz);
                }
                catch (Exception exception) {
                    LOGGER.error("Failed to register command {}", (Object)clazz.getCanonicalName());
                    exception.printStackTrace();
                }
            }
            MainCommand.instance.toggle = injector.getInstance(Toggle.class);
            MainCommand.instance.help = new Help(instance);
        }
        return instance;
    }

    public static boolean onCommand(final PlotPlayer<?> plotPlayer, String ... stringArray) {
        String[] stringArray2;
        final EconHandler econHandler = PlotSquared.platform().econHandler();
        if (stringArray.length >= 1 && stringArray[0].contains(":") && (stringArray2 = stringArray[0].split(":")).length == 2) {
            String[] stringArray3 = new String[stringArray.length + 1];
            stringArray3[0] = stringArray2[0];
            stringArray3[stringArray.length] = stringArray2[1];
            if (stringArray.length >= 2) {
                System.arraycopy(stringArray, 1, stringArray3, 1, stringArray.length - 1);
            }
            stringArray = stringArray3;
        }
        try {
            MainCommand.getInstance().execute(plotPlayer, stringArray, new RunnableVal3<Command, Runnable, Runnable>(){

                @Override
                public void run(Command command, Runnable runnable, Runnable runnable2) {
                    if (command.hasConfirmation(plotPlayer)) {
                        CmdConfirm.addPending(plotPlayer, command.getUsage(), () -> {
                            PlotArea plotArea = plotPlayer.getApplicablePlotArea();
                            if (plotArea != null && econHandler.isEnabled(plotArea) && !plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_BYPASS_ECON)) {
                                double d;
                                PlotExpression plotExpression = plotArea.getPrices().get(command.getFullId());
                                double d2 = d = plotExpression != null ? plotExpression.evaluate(0.0) : 0.0;
                                if (econHandler.getMoney(plotPlayer) < d) {
                                    if (runnable2 != null) {
                                        runnable2.run();
                                    }
                                    return;
                                }
                            }
                            if (runnable != null) {
                                runnable.run();
                            }
                        });
                        return;
                    }
                    PlotArea plotArea = plotPlayer.getApplicablePlotArea();
                    if (plotArea != null && econHandler.isEnabled(plotArea) && !plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_BYPASS_ECON)) {
                        double d;
                        PlotExpression plotExpression = plotArea.getPrices().get(command.getFullId());
                        double d2 = d = plotExpression != null ? plotExpression.evaluate(0.0) : 0.0;
                        if (d != 0.0 && econHandler.getMoney(plotPlayer) < d) {
                            if (runnable2 != null) {
                                runnable2.run();
                            }
                            return;
                        }
                    }
                    if (runnable != null) {
                        runnable.run();
                    }
                }
            }, new RunnableVal2<Command, Command.CommandResult>(){

                @Override
                public void run(Command command, Command.CommandResult commandResult) {
                }
            }).thenAccept(bl -> {});
        }
        catch (Command.CommandException commandException) {
            commandException.perform(plotPlayer);
        }
        return true;
    }

    @Override
    public CompletableFuture<Boolean> execute(final PlotPlayer<?> plotPlayer, String[] stringArray, RunnableVal3<Command, Runnable, Runnable> runnableVal3, RunnableVal2<Command, Command.CommandResult> runnableVal2) {
        Object object;
        Object object2;
        Location location = null;
        Plot plot = null;
        boolean bl = false;
        if (stringArray.length >= 2) {
            object2 = plotPlayer.getApplicablePlotArea();
            object = Plot.fromString((PlotArea)object2, stringArray[0]);
            if (object != null && (plotPlayer instanceof ConsolePlayer || ((Plot)object).getArea().equals(object2) || plotPlayer.hasPermission(Permission.PERMISSION_ADMIN) || plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_AREA_SUDO)) && !((Plot)object).isDenied(plotPlayer.getUUID())) {
                Location location2 = ((Plot)object).getArea() instanceof SinglePlotArea ? (((Plot)object).isLoaded() ? ((Plot)object).getCenterSynchronous() : Location.at("", 0, 0, 0)) : ((Plot)object).getCenterSynchronous();
                if (plotPlayer.canTeleport(location2)) {
                    try (MetaDataAccess<Object> metaDataAccess = plotPlayer.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_LOCATION);){
                        location = metaDataAccess.get().orElse(null);
                        metaDataAccess.set(location2);
                    }
                    metaDataAccess = plotPlayer.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_LAST_PLOT);
                    try {
                        plot = metaDataAccess.get().orElse(null);
                        metaDataAccess.set(object);
                    }
                    finally {
                        if (metaDataAccess != null) {
                            metaDataAccess.close();
                        }
                    }
                    bl = true;
                } else {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("border.denied"), new TagResolver[0]);
                }
                stringArray = Arrays.copyOfRange(stringArray, 1, stringArray.length);
            }
            if (stringArray.length >= 2 && !stringArray[0].isEmpty() && stringArray[0].charAt(0) == '-') {
                if ("f".equals(stringArray[0].substring(1))) {
                    runnableVal3 = new RunnableVal3<Command, Runnable, Runnable>(){

                        @Override
                        public void run(Command command, Runnable runnable, Runnable runnable2) {
                            if (object2 != null && PlotSquared.platform().econHandler().isEnabled(object2)) {
                                double d;
                                PlotExpression plotExpression = object2.getPrices().get(command.getFullId());
                                double d2 = d = plotExpression != null ? plotExpression.evaluate(0.0) : 0.0;
                                if (d != 0.0 && PlotSquared.platform().econHandler().getMoney(plotPlayer) < d) {
                                    if (runnable2 != null) {
                                        runnable2.run();
                                    }
                                    return;
                                }
                            }
                            if (runnable != null) {
                                runnable.run();
                            }
                        }
                    };
                    stringArray = Arrays.copyOfRange(stringArray, 1, stringArray.length);
                } else {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.invalid_command_flag"), new TagResolver[0]);
                    return CompletableFuture.completedFuture(false);
                }
            }
        }
        try {
            super.execute(plotPlayer, stringArray, runnableVal3, runnableVal2);
        }
        catch (Command.CommandException commandException) {
            throw commandException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            object = throwable.getMessage();
            if (object != null) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.error"), TagResolver.resolver("value", Tag.inserting(Component.text((String)object))));
            }
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.error_console"), new TagResolver[0]);
        }
        if (bl && !(plotPlayer instanceof ConsolePlayer)) {
            object2 = plotPlayer.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_LOCATION);
            try {
                if (location == null) {
                    ((MetaDataAccess)object2).remove();
                } else {
                    ((MetaDataAccess)object2).set(location);
                }
            }
            finally {
                if (object2 != null) {
                    ((MetaDataAccess)object2).close();
                }
            }
            object2 = plotPlayer.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_LAST_PLOT);
            try {
                if (plot == null) {
                    ((MetaDataAccess)object2).remove();
                } else {
                    ((MetaDataAccess)object2).set(plot);
                }
            }
            finally {
                if (object2 != null) {
                    ((MetaDataAccess)object2).close();
                }
            }
        }
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public boolean canExecute(PlotPlayer<?> plotPlayer, boolean bl) {
        return true;
    }
}

