/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.CmdConfirm;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.events.PlotMergeEvent;
import com.plotsquared.core.events.Result;
import com.plotsquared.core.location.Direction;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.util.EconHandler;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.PlotExpression;
import com.plotsquared.core.util.StringMan;
import com.plotsquared.google.Inject;
import java.util.Set;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="merge", aliases={"m"}, permission="plots.merge", usage="/plot merge <all | n | e | s | w> [removeroads]", category=CommandCategory.SETTINGS, requiredType=RequiredType.NONE, confirmation=true)
public class Merge
extends SubCommand {
    public static final String[] values = new String[]{"north", "east", "south", "west"};
    public static final String[] aliases = new String[]{"n", "e", "s", "w"};
    private final EventDispatcher eventDispatcher;
    private final EconHandler econHandler;

    @Inject
    public Merge(@NonNull EventDispatcher eventDispatcher, @NonNull EconHandler econHandler) {
        this.eventDispatcher = eventDispatcher;
        this.econHandler = econHandler;
    }

    public static String direction(float f) {
        int n = Math.round(f /= 90.0f);
        return switch (n) {
            case -4, 0, 4 -> "SOUTH";
            case -1, 3 -> "EAST";
            case -2, 2 -> "NORTH";
            case -3, 1 -> "WEST";
            default -> "";
        };
    }

    @Override
    public boolean onCommand(PlotPlayer<?> plotPlayer, String[] stringArray) {
        Location location = plotPlayer.getLocationFull();
        Plot plot = location.getPlotAbs();
        if (plot == null) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
            return false;
        }
        if (!plot.hasOwner()) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("info.plot_unowned"), new TagResolver[0]);
            return false;
        }
        if (plot.getVolume() > 2.147483647E9) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_too_large"), new TagResolver[0]);
            return false;
        }
        Direction direction = null;
        if (stringArray.length == 0) {
            switch (Merge.direction(plotPlayer.getLocationFull().getYaw())) {
                case "NORTH": {
                    direction = Direction.NORTH;
                    break;
                }
                case "EAST": {
                    direction = Direction.EAST;
                    break;
                }
                case "SOUTH": {
                    direction = Direction.SOUTH;
                    break;
                }
                case "WEST": {
                    direction = Direction.WEST;
                }
            }
        } else {
            for (int i = 0; i < values.length; ++i) {
                if (!stringArray[0].equalsIgnoreCase(values[i]) && !stringArray[0].equalsIgnoreCase(aliases[i])) continue;
                direction = Direction.getFromIndex(i);
                break;
            }
            if (direction == null && (stringArray[0].equalsIgnoreCase("all") || stringArray[0].equalsIgnoreCase("auto")) && plotPlayer.hasPermission(Permission.PERMISSION_MERGE_ALL)) {
                direction = Direction.ALL;
            }
        }
        if (direction == null) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot merge <" + StringMan.join(values, " | ") + "> [removeroads]"))));
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("help.direction"), TagResolver.resolver("dir", Tag.inserting(Component.text(Merge.direction(location.getYaw())))));
            return false;
        }
        int n = plot.getConnectedPlots().size();
        int n2 = plotPlayer.hasPermissionRange("plots.merge", Settings.Limit.MAX_PLOTS);
        PlotMergeEvent plotMergeEvent = this.eventDispatcher.callMerge(plot, direction, n2, plotPlayer);
        if (plotMergeEvent.getEventResult() == Result.DENY) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("events.event_denied"), TagResolver.resolver("value", Tag.inserting(Component.text("Merge"))));
            return false;
        }
        boolean bl = plotMergeEvent.getEventResult() == Result.FORCE;
        direction = plotMergeEvent.getDir();
        int n3 = plotMergeEvent.getMax();
        if (!bl && n - 1 > n3) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Component.text(Permission.PERMISSION_MERGE + "." + (n + 1)))));
            return false;
        }
        PlotArea plotArea = plot.getArea();
        PlotExpression plotExpression = plotArea.getPrices().getOrDefault("merge", null);
        double d = plotExpression == null ? 0.0 : plotExpression.evaluate(n);
        UUID uUID = plotPlayer.getUUID();
        if (!bl && !plot.isOwner(uUID)) {
            if (!plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_COMMAND_MERGE)) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_plot_perms"), new TagResolver[0]);
                return false;
            }
            uUID = plot.getOwnerAbs();
        }
        if (direction == Direction.ALL) {
            boolean bl2 = true;
            if (stringArray.length == 2) {
                bl2 = "true".equalsIgnoreCase(stringArray[1]);
            }
            if (!(bl || bl2 || plotPlayer.hasPermission(Permission.PERMISSION_MERGE_KEEP_ROAD))) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_MERGE_KEEP_ROAD)));
                return true;
            }
            if (plot.getPlotModificationManager().autoMerge(Direction.ALL, n3, uUID, plotPlayer, bl2)) {
                if (this.econHandler.isEnabled(plotArea) && !plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_BYPASS_ECON) && d > 0.0) {
                    this.econHandler.withdrawMoney(plotPlayer, d);
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("economy.removed_balance"), TagResolver.resolver("money", Tag.inserting(Component.text(this.econHandler.format(d)))), TagResolver.resolver("balance", Tag.inserting(Component.text(this.econHandler.format(this.econHandler.getMoney(plotPlayer))))));
                }
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("merge.success_merge"), new TagResolver[0]);
                this.eventDispatcher.callPostMerge(plotPlayer, plot);
                return true;
            }
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("merge.no_available_automerge"), new TagResolver[0]);
            return false;
        }
        if (!bl && this.econHandler.isEnabled(plotArea) && !plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_BYPASS_ECON) && d > 0.0 && this.econHandler.getMoney(plotPlayer) < d) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("economy.cannot_afford_merge"), TagResolver.resolver("money", Tag.inserting(Component.text(this.econHandler.format(d)))));
            return false;
        }
        boolean bl3 = stringArray.length == 2 ? "true".equalsIgnoreCase(stringArray[1]) : true;
        if (!(bl || bl3 || plotPlayer.hasPermission(Permission.PERMISSION_MERGE_KEEP_ROAD))) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_MERGE_KEEP_ROAD)));
            return true;
        }
        if (plot.getPlotModificationManager().autoMerge(direction, n3 - n, uUID, plotPlayer, bl3)) {
            if (this.econHandler.isEnabled(plotArea) && !plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_BYPASS_ECON) && d > 0.0) {
                this.econHandler.withdrawMoney(plotPlayer, d);
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("economy.removed_balance"), TagResolver.resolver("money", Tag.inserting(Component.text(this.econHandler.format(d)))));
            }
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("merge.success_merge"), new TagResolver[0]);
            this.eventDispatcher.callPostMerge(plotPlayer, plot);
            return true;
        }
        Plot plot2 = plot.getRelative(direction);
        if (plot2 == null || !plot2.hasOwner() || plot2.isMerged((direction.getIndex() + 2) % 4) || !bl && plot2.isOwner(uUID)) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("merge.no_available_automerge"), new TagResolver[0]);
            return false;
        }
        if (!bl && !plotPlayer.hasPermission(Permission.PERMISSION_MERGE_OTHER)) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_MERGE_OTHER)));
            return false;
        }
        Set<UUID> set = plot2.getOwners();
        boolean bl4 = false;
        for (UUID uUID2 : set) {
            PlotPlayer<?> plotPlayer2 = PlotSquared.platform().playerManager().getPlayerIfExists(uUID2);
            if (!bl && plotPlayer2 == null) continue;
            bl4 = true;
            Direction direction2 = direction;
            Runnable runnable = () -> {
                plotPlayer2.sendMessage((Caption)TranslatableCaption.of("merge.merge_accepted"), new TagResolver[0]);
                plot.getPlotModificationManager().autoMerge(direction2, n3 - n, uUID2, plotPlayer, bl3);
                PlotPlayer<?> plotPlayer3 = PlotSquared.platform().playerManager().getPlayerIfExists(plotPlayer.getUUID());
                if (plotPlayer3 == null) {
                    plotPlayer2.sendMessage((Caption)TranslatableCaption.of("merge.merge_not_valid"), new TagResolver[0]);
                    return;
                }
                if (this.econHandler.isEnabled(plotArea) && !plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_BYPASS_ECON) && d > 0.0) {
                    if (!bl && this.econHandler.getMoney(plotPlayer) < d) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("economy.cannot_afford_merge"), TagResolver.resolver("money", Tag.inserting(Component.text(this.econHandler.format(d)))));
                        return;
                    }
                    this.econHandler.withdrawMoney(plotPlayer, d);
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("economy.removed_balance"), TagResolver.resolver("money", Tag.inserting(Component.text(this.econHandler.format(d)))));
                }
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("merge.success_merge"), new TagResolver[0]);
                this.eventDispatcher.callPostMerge(plotPlayer, plot);
            };
            if (!bl && this.hasConfirmation(plotPlayer)) {
                CmdConfirm.addPending(plotPlayer2, (String)MINI_MESSAGE.serialize(MINI_MESSAGE.deserialize(TranslatableCaption.of("merge.merge_request_confirm").getComponent(plotPlayer), TagResolver.builder().tag("player", Tag.inserting(Component.text(plotPlayer.getName()))).tag("location", Tag.inserting(Component.text(plot.getWorldName() + " " + plot.getId()))).build())), runnable);
                continue;
            }
            runnable.run();
        }
        if (bl || !bl4) {
            if ((bl || plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_COMMAND_MERGE_OTHER_OFFLINE)) && plot.getPlotModificationManager().autoMerge(direction, n3 - n, set.iterator().next(), plotPlayer, bl3)) {
                if (this.econHandler.isEnabled(plotArea) && !plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_BYPASS_ECON) && d > 0.0) {
                    if (!bl && this.econHandler.getMoney(plotPlayer) < d) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("economy.cannot_afford_merge"), TagResolver.resolver("money", Tag.inserting(Component.text(this.econHandler.format(d)))));
                        return false;
                    }
                    this.econHandler.withdrawMoney(plotPlayer, d);
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("economy.removed_balance"), TagResolver.resolver("money", Tag.inserting(Component.text(this.econHandler.format(d)))));
                }
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("merge.success_merge"), new TagResolver[0]);
                this.eventDispatcher.callPostMerge(plotPlayer, plot);
                return true;
            }
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("merge.no_available_automerge"), new TagResolver[0]);
            return false;
        }
        plotPlayer.sendMessage((Caption)TranslatableCaption.of("merge.merge_requested"), new TagResolver[0]);
        return true;
    }
}

