/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.CmdConfirm;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.listener.PlotListener;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.StringMan;
import com.plotsquared.core.util.query.PlotQuery;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.core.uuid.UUIDMapping;
import com.plotsquared.google.Inject;
import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(usage="/plot purge world:<world> area:<area> id:<id> owner:<owner> shared:<shared> unknown:[true | false] clear:[true | false]", command="purge", permission="plots.admin", category=CommandCategory.ADMINISTRATION, requiredType=RequiredType.CONSOLE, confirmation=true)
public class Purge
extends SubCommand {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + Purge.class.getSimpleName()));
    private final PlotAreaManager plotAreaManager;
    private final PlotListener plotListener;

    @Inject
    public Purge(@NonNull PlotAreaManager plotAreaManager, @NonNull PlotListener plotListener) {
        this.plotAreaManager = plotAreaManager;
        this.plotListener = plotListener;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean onCommand(PlotPlayer<?> plotPlayer, String[] stringArray) {
        UUIDMapping uUIDMapping;
        void plot;
        if (stringArray.length == 0) {
            this.sendUsage(plotPlayer);
            return false;
        }
        String string = null;
        PlotArea plotArea = null;
        PlotId plotId = null;
        UUID uUID = null;
        UUID uUID2 = null;
        boolean n = false;
        boolean bl = false;
        Object hashSet = stringArray;
        int n2 = ((String[])hashSet).length;
        boolean n22 = false;
        while (plot < n2) {
            String string2 = hashSet[plot];
            String[] stringArray2 = string2.split(":");
            if (stringArray2.length != 2) {
                this.sendUsage(plotPlayer);
                return false;
            }
            switch (stringArray2[0].toLowerCase()) {
                case "world": 
                case "w": {
                    string = stringArray2[1];
                    break;
                }
                case "area": 
                case "a": {
                    plotArea = this.plotAreaManager.getPlotAreaByString(stringArray2[1]);
                    if (plotArea != null) break;
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_valid_plot_world"), TagResolver.resolver("value", Tag.inserting(Component.text((String)stringArray2[1]))));
                    return false;
                }
                case "plotid": 
                case "id": {
                    try {
                        plotId = PlotId.fromString(stringArray2[1]);
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("invalid.not_valid_plot_id"), TagResolver.resolver("value", Tag.inserting(Component.text(stringArray2[1]))));
                        return false;
                    }
                }
                case "owner": 
                case "o": {
                    uUIDMapping = PlotSquared.get().getImpromptuUUIDPipeline().getImmediately(stringArray2[1]);
                    if (uUIDMapping == null) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.invalid_player"), TagResolver.resolver("value", Tag.inserting(Component.text((String)stringArray2[1]))));
                        return false;
                    }
                    uUID = uUIDMapping.uuid();
                    break;
                }
                case "shared": 
                case "s": {
                    uUIDMapping = PlotSquared.get().getImpromptuUUIDPipeline().getImmediately(stringArray2[1]);
                    if (uUIDMapping == null) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.invalid_player"), TagResolver.resolver("value", Tag.inserting(Component.text((String)stringArray2[1]))));
                        return false;
                    }
                    uUID2 = uUIDMapping.uuid();
                    break;
                }
                case "clear": 
                case "c": 
                case "delete": 
                case "d": 
                case "del": {
                    n = Boolean.parseBoolean(stringArray2[1]);
                    break;
                }
                case "unknown": 
                case "?": 
                case "u": {
                    bl = Boolean.parseBoolean(stringArray2[1]);
                    break;
                }
                default: {
                    this.sendUsage(plotPlayer);
                    return false;
                }
            }
            ++plot;
        }
        hashSet = new HashSet();
        for (Plot entry : PlotQuery.newQuery().whereBasePlot()) {
            UUIDMapping uUIDMapping2;
            if (string != null && !entry.getWorldName().equalsIgnoreCase(string) || plotArea != null && !entry.getArea().equals(plotArea) || plotId != null && !entry.getId().equals(plotId) || uUID != null && !entry.isOwner(uUID) || uUID2 != null && !entry.isAdded(uUID2) || bl && (uUIDMapping2 = PlotSquared.get().getImpromptuUUIDPipeline().getImmediately(entry.getOwner())) != null) continue;
            ((AbstractCollection)hashSet).addAll(entry.getConnectedPlots());
        }
        if (PlotSquared.get().plots_tmp != null) {
            for (Map.Entry entry : PlotSquared.get().plots_tmp.entrySet()) {
                String string3 = (String)entry.getKey();
                if (string != null && !string.equalsIgnoreCase(string3)) continue;
                for (Map.Entry entry2 : ((HashMap)entry.getValue()).entrySet()) {
                    Plot plot2 = (Plot)entry2.getValue();
                    if (plotArea != null && !plot2.getArea().equals(plotArea) || plotId != null && !plot2.getId().equals(plotId) || uUID != null && !plot2.isOwner(uUID) || uUID2 != null && !plot2.isAdded(uUID2) || bl && (uUIDMapping = PlotSquared.get().getImpromptuUUIDPipeline().getImmediately(plot2.getOwner())) != null) continue;
                    ((HashSet)hashSet).add(plot2);
                }
            }
        }
        if (((HashSet)hashSet).isEmpty()) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("invalid.found_no_plots"), new TagResolver[0]);
            return false;
        }
        String string2 = "/plot purge " + StringMan.join(stringArray, " ") + " (" + ((HashSet)hashSet).size() + " plots)";
        boolean bl2 = n;
        Runnable runnable = () -> this.lambda$onCommand$0((HashSet)hashSet, bl2, plotPlayer);
        if (this.hasConfirmation(plotPlayer)) {
            if (bl) {
                if (Settings.UUID.BACKGROUND_CACHING_ENABLED) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("purge.confirm_purge_unknown_bg_enabled"), new TagResolver[0]);
                } else {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("purge.confirm_purge_unknown_bg_disabled"), new TagResolver[0]);
                }
            }
            CmdConfirm.addPending(plotPlayer, string2, runnable);
        } else {
            runnable.run();
        }
        return true;
    }

    private /* synthetic */ void lambda$onCommand$0(final HashSet hashSet, final boolean bl, final PlotPlayer plotPlayer) {
        LOGGER.info("Calculating plots to purge, please wait...");
        final HashSet hashSet2 = new HashSet();
        final Iterator iterator = hashSet.iterator();
        final AtomicBoolean atomicBoolean = new AtomicBoolean(true);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                while (iterator.hasNext() && atomicBoolean.get()) {
                    atomicBoolean.set(false);
                    Plot plot = (Plot)iterator.next();
                    if (plot.temp != Integer.MAX_VALUE) {
                        try {
                            hashSet2.add(plot.temp);
                            if (bl) {
                                plot.getPlotModificationManager().clear(false, true, plotPlayer, () -> LOGGER.info("Plot {} cleared by purge", (Object)plot.getId()));
                            } else {
                                plot.getPlotModificationManager().removeSign();
                            }
                            plot.getArea().removePlot(plot.getId());
                            for (PlotPlayer<?> plotPlayer2 : plot.getPlayersInPlot()) {
                                Purge.this.plotListener.plotEntry(plotPlayer2, plot);
                            }
                        }
                        catch (NullPointerException nullPointerException) {
                            LOGGER.error("NullPointer during purge detected. This is likely because you are deleting a world that has been removed", (Throwable)nullPointerException);
                        }
                    }
                    atomicBoolean.set(true);
                }
                if (iterator.hasNext()) {
                    TaskManager.runTaskAsync(this);
                } else {
                    TaskManager.runTask(() -> {
                        DBFunc.purgeIds(hashSet2);
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("purge.purge_success"), TagResolver.resolver("amount", Tag.inserting(Component.text(hashSet2.size() + "/" + hashSet.size()))));
                    });
                }
            }
        };
        TaskManager.runTaskAsync(runnable);
    }
}

