/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.command.Argument;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.PlayerManager;
import com.plotsquared.core.util.TabCompletions;
import com.plotsquared.google.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="remove", aliases={"r", "untrust", "ut", "undeny", "unban", "ud", "pardon"}, usage="/plot remove <player | *>", category=CommandCategory.SETTINGS, requiredType=RequiredType.NONE, permission="plots.remove")
public class Remove
extends SubCommand {
    private final EventDispatcher eventDispatcher;

    @Inject
    public Remove(@NonNull EventDispatcher eventDispatcher) {
        super(Argument.PlayerName);
        this.eventDispatcher = eventDispatcher;
    }

    @Override
    public boolean onCommand(PlotPlayer<?> plotPlayer, String[] stringArray) {
        Location location = plotPlayer.getLocation();
        Plot plot = location.getPlotAbs();
        if (plot == null) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
            return false;
        }
        if (!plot.hasOwner()) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("info.plot_unowned"), new TagResolver[0]);
            return false;
        }
        if (!plot.isOwner(plotPlayer.getUUID()) && !plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_COMMAND_REMOVE)) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_plot_perms"), new TagResolver[0]);
            return true;
        }
        PlayerManager.getUUIDsFromString(stringArray[0], (collection, throwable) -> {
            int n = 0;
            if (throwable instanceof TimeoutException) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("players.fetching_players_timeout"), new TagResolver[0]);
                return;
            }
            if (throwable != null) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.invalid_player"), TagResolver.resolver("value", Tag.inserting(Component.text(stringArray[0]))));
                return;
            }
            if (!collection.isEmpty()) {
                for (UUID uUID : collection) {
                    if (plot.getTrusted().contains(uUID)) {
                        if (!plot.removeTrusted(uUID)) continue;
                        this.eventDispatcher.callTrusted(plotPlayer, plot, uUID, false);
                        ++n;
                        continue;
                    }
                    if (plot.getMembers().contains(uUID)) {
                        if (!plot.removeMember(uUID)) continue;
                        this.eventDispatcher.callMember(plotPlayer, plot, uUID, false);
                        ++n;
                        continue;
                    }
                    if (plot.getDenied().contains(uUID)) {
                        if (!plot.removeDenied(uUID)) continue;
                        this.eventDispatcher.callDenied(plotPlayer, plot, uUID, false);
                        ++n;
                        continue;
                    }
                    if (uUID != DBFunc.EVERYONE) continue;
                    if (plot.removeTrusted(uUID)) {
                        this.eventDispatcher.callTrusted(plotPlayer, plot, uUID, false);
                        ++n;
                        continue;
                    }
                    if (plot.removeMember(uUID)) {
                        this.eventDispatcher.callMember(plotPlayer, plot, uUID, false);
                        ++n;
                        continue;
                    }
                    if (!plot.removeDenied(uUID)) continue;
                    this.eventDispatcher.callDenied(plotPlayer, plot, uUID, false);
                    ++n;
                }
            }
            if (n == 0) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.invalid_player"), TagResolver.resolver("value", Tag.inserting(Component.text(stringArray[0]))));
            } else {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("member.removed_players"), TagResolver.resolver("amount", Tag.inserting(Component.text(n))));
            }
        });
        return true;
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> plotPlayer, String[] stringArray, boolean bl) {
        Location location = plotPlayer.getLocation();
        Plot plot = location.getPlotAbs();
        if (plot == null) {
            return Collections.emptyList();
        }
        return TabCompletions.completeAddedPlayers(plotPlayer, plot, String.join((CharSequence)",", stringArray).trim(), Collections.singletonList(plotPlayer.getName()));
    }
}

