/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.backup.BackupManager;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.MainCommand;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SetCommand;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.StaticCaption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.inject.factory.ProgressSubscriberFactory;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotManager;
import com.plotsquared.core.queue.QueueCoordinator;
import com.plotsquared.core.util.PatternUtil;
import com.plotsquared.core.util.StringMan;
import com.plotsquared.core.util.TabCompletions;
import com.plotsquared.core.util.WorldUtil;
import com.plotsquared.google.Inject;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.registry.Keyed;
import com.sk89q.worldedit.world.block.BlockCategory;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="set", aliases={"s"}, usage="/plot set <biome | alias | home | flag> <value...>", permission="plots.set", category=CommandCategory.APPEARANCE, requiredType=RequiredType.NONE)
public class Set
extends SubCommand {
    public static final String[] values = new String[]{"biome", "alias", "home"};
    public static final String[] aliases = new String[]{"b", "w", "wf", "a", "h"};
    private final SetCommand component;

    @Inject
    public Set(final @NonNull WorldUtil worldUtil) {
        this.component = new SetCommand(){

            @Override
            public String getId() {
                return "set.component";
            }

            @Override
            public boolean set(PlotPlayer<?> plotPlayer, Plot plot, String string) {
                PlotArea plotArea = plotPlayer.getLocation().getPlotArea();
                if (plotArea == null) {
                    return false;
                }
                PlotManager plotManager = plotArea.getPlotManager();
                String[] stringArray = plotManager.getPlotComponents(plot.getId());
                String[] stringArray2 = string.split(" ");
                String string2 = StringMan.join(Arrays.copyOfRange(stringArray2, 1, stringArray2.length), ",").trim();
                ArrayList<String> arrayList = new ArrayList<String>(Settings.General.INVALID_BLOCKS);
                if (Settings.Enabled_Components.CHUNK_PROCESSOR) {
                    arrayList.addAll(worldUtil.getTileEntityTypes().stream().map(BlockType::getName).toList());
                }
                if (!plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_ALLOW_UNSAFE) && !arrayList.isEmpty()) {
                    for (String string3 : arrayList) {
                        if ((string3 = string3.toLowerCase(Locale.ENGLISH)).startsWith("minecraft:")) {
                            string3 = string3.substring(10);
                        }
                        for (String string4 : string2.split(",")) {
                            block15: {
                                if ((string4 = string4.toLowerCase(Locale.ENGLISH)).startsWith("minecraft:")) {
                                    string4 = string4.substring(10);
                                }
                                if (string4.startsWith("##")) {
                                    try {
                                        BlockCategory blockCategory = (BlockCategory)BlockCategory.REGISTRY.get(string4.substring(2).replaceAll("[*^|]+", "").toLowerCase(Locale.ENGLISH));
                                        if (blockCategory == null || !blockCategory.contains((Keyed)BlockTypes.get((String)string3))) {
                                            continue;
                                        }
                                        break block15;
                                    }
                                    catch (Throwable throwable) {
                                        break block15;
                                    }
                                }
                                if (!string4.contains(string3)) continue;
                            }
                            plotPlayer.sendMessage((Caption)TranslatableCaption.of("invalid.component_illegal_block"), TagResolver.resolver("value", Tag.inserting(Component.text(string3))));
                            return true;
                        }
                    }
                }
                for (String string5 : stringArray) {
                    if (!string5.equalsIgnoreCase(stringArray2[0])) continue;
                    if (!plotPlayer.hasPermission(Permission.PERMISSION_SET_COMPONENT.format(string5))) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Component.text(Permission.PERMISSION_SET_COMPONENT.format(string5)))));
                        return false;
                    }
                    if (stringArray2.length < 2) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("need.need_block"), new TagResolver[0]);
                        return true;
                    }
                    Pattern pattern = PatternUtil.parse(plotPlayer, string2, false);
                    if (plot.getRunning() > 0) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.wait_for_timer"), new TagResolver[0]);
                        return false;
                    }
                    BackupManager.backup(plotPlayer, plot, () -> {
                        plot.addRunning();
                        QueueCoordinator queueCoordinator = plotArea.getQueue();
                        queueCoordinator.setCompleteTask(() -> {
                            plot.removeRunning();
                            plotPlayer.sendMessage((Caption)TranslatableCaption.of("working.component_complete"), TagResolver.resolver("plot", Tag.inserting(Component.text(plot.getId().toString()))));
                        });
                        if (Settings.QUEUE.NOTIFY_PROGRESS) {
                            queueCoordinator.addProgressSubscriber(PlotSquared.platform().injector().getInstance(ProgressSubscriberFactory.class).createWithActor(plotPlayer));
                        }
                        for (Plot plot2 : plot.getConnectedPlots()) {
                            plot2.getPlotModificationManager().setComponent(string5, pattern, plotPlayer, queueCoordinator);
                        }
                        queueCoordinator.enqueue();
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("working.generating_component"), new TagResolver[0]);
                    });
                    return true;
                }
                return false;
            }

            @Override
            public Collection<Command> tab(PlotPlayer<?> plotPlayer, String[] stringArray, boolean bl) {
                return TabCompletions.completePatterns(StringMan.join(stringArray, ","));
            }
        };
    }

    public boolean noArgs(PlotPlayer<?> plotPlayer) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList("biome", "alias", "home"));
        Plot plot = plotPlayer.getCurrentPlot();
        if (plot != null) {
            arrayList.addAll(Arrays.asList(plot.getManager().getPlotComponents(plot.getId())));
        }
        plotPlayer.sendMessage((Caption)StaticCaption.of(TranslatableCaption.of("commandconfig.subcommand_set_options_header_only").getComponent(plotPlayer) + StringMan.join(arrayList, TranslatableCaption.of("blocklist.block_list_separator").getComponent(plotPlayer))), new TagResolver[0]);
        return false;
    }

    @Override
    public boolean onCommand(PlotPlayer<?> plotPlayer, String[] stringArray) {
        if (stringArray.length == 0) {
            return this.noArgs(plotPlayer);
        }
        Command command = MainCommand.getInstance().getCommand("set" + stringArray[0]);
        if (command != null) {
            if (!plotPlayer.hasPermission(command.getPermission(), true)) {
                return false;
            }
            command.execute(plotPlayer, Arrays.copyOfRange(stringArray, 1, stringArray.length), null, null);
            return true;
        }
        Plot plot = plotPlayer.getCurrentPlot();
        if (plot == null) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
            return false;
        }
        if (plot.getVolume() > 2.147483647E9) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_too_large"), new TagResolver[0]);
            return false;
        }
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(plot.getManager().getPlotComponents(plot.getId())));
        if (hashSet.contains(stringArray[0].toLowerCase())) {
            return this.component.onCommand(plotPlayer, Arrays.copyOfRange(stringArray, 0, stringArray.length));
        }
        return this.noArgs(plotPlayer);
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> plotPlayer, String[] stringArray, boolean bl) {
        if (stringArray.length == 1) {
            LinkedList<String> linkedList = new LinkedList<String>();
            if (plotPlayer.hasPermission(Permission.PERMISSION_SET_BIOME)) {
                linkedList.add("biome");
            }
            if (plotPlayer.hasPermission(Permission.PERMISSION_SET_ALIAS)) {
                linkedList.add("alias");
            }
            if (plotPlayer.hasPermission(Permission.PERMISSION_SET_HOME)) {
                linkedList.add("home");
            }
            if (plotPlayer.hasPermission(Permission.PERMISSION_SET_MAIN)) {
                linkedList.add("main");
            }
            if (plotPlayer.hasPermission(Permission.PERMISSION_SET_FLOOR)) {
                linkedList.add("floor");
            }
            if (plotPlayer.hasPermission(Permission.PERMISSION_SET_AIR)) {
                linkedList.add("air");
            }
            if (plotPlayer.hasPermission(Permission.PERMISSION_SET_ALL)) {
                linkedList.add("all");
            }
            if (plotPlayer.hasPermission(Permission.PERMISSION_SET_BORDER)) {
                linkedList.add("border");
            }
            if (plotPlayer.hasPermission(Permission.PERMISSION_SET_WALL)) {
                linkedList.add("wall");
            }
            if (plotPlayer.hasPermission(Permission.PERMISSION_SET_OUTLINE)) {
                linkedList.add("outline");
            }
            if (plotPlayer.hasPermission(Permission.PERMISSION_SET_MIDDLE)) {
                linkedList.add("middle");
            }
            List list = linkedList.stream().filter(string -> string.toLowerCase().startsWith(stringArray[0].toLowerCase())).map(string -> new Command(null, true, (String)string, "", RequiredType.NONE, CommandCategory.APPEARANCE){}).collect(Collectors.toCollection(LinkedList::new));
            if (plotPlayer.hasPermission(Permission.PERMISSION_SET) && stringArray[0].length() > 0) {
                list.addAll(TabCompletions.completePlayers(plotPlayer, stringArray[0], Collections.emptyList()));
            }
            return list;
        }
        if (stringArray.length > 1) {
            Plot plot = plotPlayer.getCurrentPlot();
            if (plot == null) {
                return new ArrayList<Command>();
            }
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
            Command command = MainCommand.getInstance().getCommand("set" + stringArray[0]);
            if (command != null) {
                if (!plotPlayer.hasPermission(command.getPermission(), true)) {
                    return new ArrayList<Command>();
                }
                return command.tab(plotPlayer, stringArray2, bl);
            }
            HashSet<String> hashSet = new HashSet<String>(Arrays.asList(plot.getManager().getPlotComponents(plot.getId())));
            if (hashSet.contains(stringArray[0].toLowerCase())) {
                return this.component.tab(plotPlayer, stringArray2, bl);
            }
        }
        return this.tabOf(plotPlayer, stringArray, bl, new String[0]);
    }
}

