/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.util.task.RunnableVal2;
import com.plotsquared.core.util.task.RunnableVal3;
import java.util.concurrent.CompletableFuture;

@CommandDeclaration(usage="/plot swap <X;Z>", command="swap", aliases={"switch"}, category=CommandCategory.CLAIMING, requiredType=RequiredType.PLAYER)
public class Swap
extends SubCommand {
    @Override
    public CompletableFuture<Boolean> execute(PlotPlayer<?> plotPlayer, String[] stringArray, RunnableVal3<Command, Runnable, Runnable> runnableVal3, RunnableVal2<Command, Command.CommandResult> runnableVal2) {
        Location location = plotPlayer.getLocation();
        Plot plot = location.getPlotAbs();
        if (plot == null) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
            return CompletableFuture.completedFuture(false);
        }
        if (!plot.isOwner(plotPlayer.getUUID()) && !plotPlayer.hasPermission(Permission.PERMISSION_ADMIN)) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_plot_perms"), new TagResolver[0]);
            return CompletableFuture.completedFuture(false);
        }
        if (stringArray.length != 1) {
            this.sendUsage(plotPlayer);
            return CompletableFuture.completedFuture(false);
        }
        Plot plot2 = Plot.getPlotFromString(plotPlayer, stringArray[0], true);
        if (plot2 == null) {
            return CompletableFuture.completedFuture(false);
        }
        if (plot.equals(plot2)) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("invalid.origin_cant_be_target"), new TagResolver[0]);
            return CompletableFuture.completedFuture(false);
        }
        if (!plot.getArea().isCompatible(plot2.getArea())) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.plotworld_incompatible"), new TagResolver[0]);
            return CompletableFuture.completedFuture(false);
        }
        if (plot.isMerged() || plot2.isMerged()) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("swap.swap_merged"), new TagResolver[0]);
            return CompletableFuture.completedFuture(false);
        }
        String string = plot.toString();
        String string2 = plot2.toString();
        return plot.getPlotModificationManager().move(plot2, plotPlayer, () -> {}, true).thenApply(bl -> {
            if (bl.booleanValue()) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("swap.swap_success"), TagResolver.builder().tag("origin", Tag.inserting(Component.text(string))).tag("target", Tag.inserting(Component.text(string2))).build());
                return true;
            }
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("swap.swap_overlap"), new TagResolver[0]);
            return false;
        });
    }

    @Override
    public boolean onCommand(PlotPlayer<?> plotPlayer, String[] stringArray) {
        return true;
    }
}

