/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.configuration;

import com.plotsquared.core.configuration.ConfigurationUtil;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.plot.BlockBucket;
import com.plotsquared.core.util.StringMan;
import com.sk89q.worldedit.world.block.BlockState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class ConfigurationNode {
    private final String constant;
    private final Object defaultValue;
    private final Caption description;
    private final ConfigurationUtil.SettingValue<?> type;
    private final Collection<String> suggestions;
    private Object value;

    public ConfigurationNode(String string, Object object, Caption caption, ConfigurationUtil.SettingValue<?> settingValue) {
        this(string, object, caption, settingValue, new ArrayList<String>());
    }

    public ConfigurationNode(String string, Object object, Caption caption, ConfigurationUtil.SettingValue<?> settingValue, Collection<String> collection) {
        this.constant = string;
        this.defaultValue = object;
        this.description = caption;
        this.value = object;
        this.type = settingValue;
        this.suggestions = collection;
    }

    public ConfigurationUtil.SettingValue<?> getType() {
        return this.type;
    }

    public boolean isValid(String string) {
        try {
            Object obj = this.type.parseString(string);
            return obj != null;
        }
        catch (Exception exception) {
            if (exception instanceof ConfigurationUtil.UnknownBlockException) {
                throw exception;
            }
            return false;
        }
    }

    public boolean setValue(String string) {
        if (!this.type.validateValue(string)) {
            return false;
        }
        this.value = this.type.parseString(string);
        return true;
    }

    public Object getValue() {
        if (this.value instanceof String[]) {
            return Arrays.asList((String[])this.value);
        }
        if (this.value instanceof Object[]) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Object object : (Object[])this.value) {
                arrayList.add(object.toString());
            }
            return arrayList;
        }
        if (this.value instanceof BlockBucket) {
            return this.value.toString();
        }
        if (this.value instanceof BlockState) {
            return this.value.toString();
        }
        return this.value;
    }

    public Object getDefaultValue() {
        if (this.defaultValue instanceof Object[]) {
            return StringMan.join((Object[])this.defaultValue, ",");
        }
        return this.defaultValue;
    }

    public String getConstant() {
        return this.constant;
    }

    public Caption getDescription() {
        return this.description;
    }

    public Collection<String> getSuggestions() {
        return this.suggestions;
    }
}

