/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.configuration;

import com.plotsquared.core.configuration.Configuration;
import com.plotsquared.core.configuration.ConfigurationSection;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MemorySection
implements ConfigurationSection {
    protected final Map<String, Object> map = new LinkedHashMap<String, Object>();
    private final Configuration root;
    private final ConfigurationSection parent;
    private final String path;
    private final String fullPath;

    protected MemorySection() {
        if (!(this instanceof Configuration)) {
            throw new IllegalStateException("Cannot construct a root MemorySection when not a Configuration");
        }
        this.path = "";
        this.fullPath = "";
        this.parent = null;
        this.root = (Configuration)((Object)this);
    }

    protected MemorySection(ConfigurationSection configurationSection, String string) {
        this.path = string;
        this.parent = configurationSection;
        this.root = configurationSection.getRoot();
        if (this.root == null) {
            throw new NullPointerException("Path may not be orphaned");
        }
        this.fullPath = MemorySection.createPath(configurationSection, string);
    }

    public static double toDouble(Object object, double d) {
        List list;
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof String) {
            try {
                return Double.parseDouble((String)object);
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else if (object instanceof List && !(list = (List)object).isEmpty()) {
            return MemorySection.toDouble(list.get(0), d);
        }
        return d;
    }

    public static int toInt(Object object, int n) {
        List list;
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else if (object instanceof List && !(list = (List)object).isEmpty()) {
            return MemorySection.toInt(list.get(0), n);
        }
        return n;
    }

    public static long toLong(Object object, long l) {
        List list;
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        if (object instanceof String) {
            try {
                return Long.parseLong((String)object);
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else if (object instanceof List && !(list = (List)object).isEmpty()) {
            return MemorySection.toLong(list.get(0), l);
        }
        return l;
    }

    public static String createPath(ConfigurationSection configurationSection, String string) {
        return MemorySection.createPath(configurationSection, string, configurationSection.getRoot());
    }

    public static String createPath(ConfigurationSection configurationSection, String string, ConfigurationSection configurationSection2) {
        Configuration configuration = configurationSection.getRoot();
        if (configuration == null) {
            throw new IllegalStateException("Cannot create path without a root");
        }
        char c = configuration.options().pathSeparator();
        StringBuilder stringBuilder = new StringBuilder();
        for (ConfigurationSection configurationSection3 = configurationSection; configurationSection3 != null && configurationSection3 != configurationSection2; configurationSection3 = configurationSection3.getParent()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.insert(0, c);
            }
            stringBuilder.insert(0, configurationSection3.getName());
        }
        if (string != null && !string.isEmpty()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(c);
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    @Override
    public Set<String> getKeys(boolean bl) {
        ConfigurationSection configurationSection;
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        Configuration configuration = this.getRoot();
        if (configuration != null && configuration.options().copyDefaults() && (configurationSection = this.getDefaultSection()) != null) {
            linkedHashSet.addAll(configurationSection.getKeys(bl));
        }
        this.mapChildrenKeys(linkedHashSet, this, bl);
        return linkedHashSet;
    }

    @Override
    public Map<String, Object> getValues(boolean bl) {
        ConfigurationSection configurationSection;
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        Configuration configuration = this.getRoot();
        if (configuration != null && configuration.options().copyDefaults() && (configurationSection = this.getDefaultSection()) != null) {
            linkedHashMap.putAll(configurationSection.getValues(bl));
        }
        this.mapChildrenValues(linkedHashMap, this, bl);
        return linkedHashMap;
    }

    @Override
    public boolean contains(String string) {
        return this.get(string) != null;
    }

    @Override
    public boolean isSet(String string) {
        Configuration configuration = this.getRoot();
        if (configuration == null) {
            return false;
        }
        if (configuration.options().copyDefaults()) {
            return this.contains(string);
        }
        return this.get(string, null) != null;
    }

    @Override
    public String getCurrentPath() {
        return this.fullPath;
    }

    @Override
    public String getName() {
        return this.path;
    }

    @Override
    public Configuration getRoot() {
        return this.root;
    }

    @Override
    public ConfigurationSection getParent() {
        return this.parent;
    }

    @Override
    public void addDefault(String string, Object object) {
        Configuration configuration = this.getRoot();
        if (configuration == null) {
            throw new IllegalStateException("Cannot add default without root");
        }
        if (configuration == this) {
            throw new UnsupportedOperationException("Unsupported addDefault(String, Object) implementation");
        }
        configuration.addDefault(MemorySection.createPath(this, string), object);
    }

    @Override
    public ConfigurationSection getDefaultSection() {
        Configuration configuration;
        Configuration configuration2 = this.getRoot();
        Configuration configuration3 = configuration = configuration2 == null ? null : configuration2.getDefaults();
        if (configuration != null && configuration.isConfigurationSection(this.getCurrentPath())) {
            return configuration.getConfigurationSection(this.getCurrentPath());
        }
        return null;
    }

    @Override
    public void set(String string, Object object) {
        String string2;
        int n;
        Configuration configuration = this.getRoot();
        if (configuration == null) {
            throw new IllegalStateException("Cannot use section without a root");
        }
        char c = configuration.options().pathSeparator();
        int n2 = -1;
        ConfigurationSection configurationSection = this;
        while ((n2 = string.indexOf(c, n = n2 + 1)) != -1) {
            string2 = string.substring(n, n2);
            ConfigurationSection configurationSection2 = configurationSection.getConfigurationSection(string2);
            if (configurationSection2 == null) {
                configurationSection = configurationSection.createSection(string2);
                continue;
            }
            configurationSection = configurationSection2;
        }
        string2 = string.substring(n);
        if (configurationSection == this) {
            if (object == null) {
                this.map.remove(string2);
            } else {
                this.map.put(string2, object);
            }
        } else {
            configurationSection.set(string2, object);
        }
    }

    @Override
    public Object get(String string) {
        return this.get(string, this.getDefault(string));
    }

    @Override
    public Object get(String string, Object object) {
        int n;
        if (string == null) {
            throw new NullPointerException("Path cannot be null");
        }
        if (string.isEmpty()) {
            return this;
        }
        Configuration configuration = this.getRoot();
        if (configuration == null) {
            throw new IllegalStateException("Cannot access section without a root");
        }
        char c = configuration.options().pathSeparator();
        int n2 = -1;
        ConfigurationSection configurationSection = this;
        while ((n2 = string.indexOf(c, n = n2 + 1)) != -1) {
            if ((configurationSection = configurationSection.getConfigurationSection(string.substring(n, n2))) != null) continue;
            return object;
        }
        String string2 = string.substring(n);
        if (configurationSection == this) {
            Object object2 = this.map.get(string2);
            if (object2 == null) {
                return object;
            }
            return object2;
        }
        return configurationSection.get(string2, object);
    }

    @Override
    public ConfigurationSection createSection(String string) {
        ConfigurationSection configurationSection;
        String string2;
        int n;
        Configuration configuration = this.getRoot();
        if (configuration == null) {
            throw new IllegalStateException("Cannot create section without a root");
        }
        char c = configuration.options().pathSeparator();
        int n2 = -1;
        ConfigurationSection configurationSection2 = this;
        while ((n2 = string.indexOf(c, n = n2 + 1)) != -1) {
            string2 = string.substring(n, n2);
            configurationSection = configurationSection2.getConfigurationSection(string2);
            if (configurationSection == null) {
                configurationSection2 = configurationSection2.createSection(string2);
                continue;
            }
            configurationSection2 = configurationSection;
        }
        string2 = string.substring(n);
        if (configurationSection2 == this) {
            configurationSection = new MemorySection(this, string2);
            this.map.put(string2, configurationSection);
            return configurationSection;
        }
        return configurationSection2.createSection(string2);
    }

    @Override
    public ConfigurationSection createSection(String string, Map<?, ?> map) {
        ConfigurationSection configurationSection = this.createSection(string);
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                configurationSection.createSection(entry.getKey().toString(), (Map)entry.getValue());
                continue;
            }
            configurationSection.set(entry.getKey().toString(), entry.getValue());
        }
        return configurationSection;
    }

    @Override
    public String getString(String string) {
        Object object = this.getDefault(string);
        return this.getString(string, object != null ? object.toString() : null);
    }

    @Override
    public String getString(String string, String string2) {
        Object object = this.get(string, string2);
        if (object != null) {
            return object.toString();
        }
        return string2;
    }

    @Override
    public boolean isString(String string) {
        Object object = this.get(string);
        return object instanceof String;
    }

    @Override
    public int getInt(String string) {
        Object object = this.getDefault(string);
        return this.getInt(string, MemorySection.toInt(object, 0));
    }

    @Override
    public int getInt(String string, int n) {
        Object object = this.get(string, n);
        return MemorySection.toInt(object, n);
    }

    @Override
    public boolean isInt(String string) {
        Object object = this.get(string);
        return object instanceof Integer;
    }

    @Override
    public boolean getBoolean(String string) {
        Object object = this.getDefault(string);
        if (object instanceof Boolean) {
            return this.getBoolean(string, (Boolean)object);
        }
        return this.getBoolean(string, false);
    }

    @Override
    public boolean getBoolean(String string, boolean bl) {
        Object object = this.get(string, bl);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return bl;
    }

    @Override
    public boolean isBoolean(String string) {
        Object object = this.get(string);
        return object instanceof Boolean;
    }

    @Override
    public double getDouble(String string) {
        Object object = this.getDefault(string);
        return this.getDouble(string, MemorySection.toDouble(object, 0.0));
    }

    @Override
    public double getDouble(String string, double d) {
        Object object = this.get(string, d);
        return MemorySection.toDouble(object, d);
    }

    @Override
    public boolean isDouble(String string) {
        Object object = this.get(string);
        return object instanceof Double;
    }

    @Override
    public long getLong(String string) {
        Object object = this.getDefault(string);
        return this.getLong(string, MemorySection.toLong(object, 0L));
    }

    @Override
    public long getLong(String string, long l) {
        Object object = this.get(string, l);
        return MemorySection.toLong(object, l);
    }

    @Override
    public boolean isLong(String string) {
        Object object = this.get(string);
        return object instanceof Long;
    }

    @Override
    public List<?> getList(String string) {
        Object object = this.getDefault(string);
        return this.getList(string, object instanceof List ? (List)object : null);
    }

    @Override
    public List<?> getList(String string, List<?> list) {
        List<?> list2 = this.get(string, list);
        return list2 instanceof List ? list2 : list;
    }

    @Override
    public boolean isList(String string) {
        Object object = this.get(string);
        return object instanceof List;
    }

    @Override
    public List<String> getStringList(String string) {
        List<?> list = this.getList(string);
        if (list == null) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object obj : list) {
            if (!(obj instanceof String) && !this.isPrimitiveWrapper(obj)) continue;
            arrayList.add(String.valueOf(obj));
        }
        return arrayList;
    }

    @Override
    public List<Integer> getIntegerList(String string) {
        List<?> list = this.getList(string);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Object obj : list) {
            if (obj instanceof Integer) {
                arrayList.add((Integer)obj);
                continue;
            }
            if (obj instanceof String) {
                try {
                    arrayList.add(Integer.valueOf((String)obj));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (obj instanceof Character) {
                arrayList.add(Integer.valueOf(((Character)obj).charValue()));
                continue;
            }
            if (!(obj instanceof Number)) continue;
            arrayList.add(((Number)obj).intValue());
        }
        return arrayList;
    }

    @Override
    public List<Boolean> getBooleanList(String string) {
        List<?> list = this.getList(string);
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
        for (Object obj : list) {
            if (obj instanceof Boolean) {
                arrayList.add((Boolean)obj);
                continue;
            }
            if (!(obj instanceof String)) continue;
            if (Boolean.TRUE.toString().equals(obj)) {
                arrayList.add(true);
                continue;
            }
            if (!Boolean.FALSE.toString().equals(obj)) continue;
            arrayList.add(false);
        }
        return arrayList;
    }

    @Override
    public List<Double> getDoubleList(String string) {
        List<?> list = this.getList(string);
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (Object obj : list) {
            if (obj instanceof Double) {
                arrayList.add((Double)obj);
                continue;
            }
            if (obj instanceof String) {
                try {
                    arrayList.add(Double.valueOf((String)obj));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (obj instanceof Character) {
                arrayList.add(Double.valueOf(((Character)obj).charValue()));
                continue;
            }
            if (!(obj instanceof Number)) continue;
            arrayList.add(((Number)obj).doubleValue());
        }
        return arrayList;
    }

    @Override
    public List<Float> getFloatList(String string) {
        List<?> list = this.getList(string);
        ArrayList<Float> arrayList = new ArrayList<Float>();
        for (Object obj : list) {
            if (obj instanceof Float) {
                arrayList.add((Float)obj);
                continue;
            }
            if (obj instanceof String) {
                try {
                    arrayList.add(Float.valueOf((String)obj));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (obj instanceof Character) {
                arrayList.add(Float.valueOf(((Character)obj).charValue()));
                continue;
            }
            if (!(obj instanceof Number)) continue;
            arrayList.add(Float.valueOf(((Number)obj).floatValue()));
        }
        return arrayList;
    }

    @Override
    public List<Long> getLongList(String string) {
        List<?> list = this.getList(string);
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (Object obj : list) {
            if (obj instanceof Long) {
                arrayList.add((Long)obj);
                continue;
            }
            if (obj instanceof String) {
                try {
                    arrayList.add(Long.valueOf((String)obj));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (obj instanceof Character) {
                arrayList.add(Long.valueOf(((Character)obj).charValue()));
                continue;
            }
            if (!(obj instanceof Number)) continue;
            arrayList.add(((Number)obj).longValue());
        }
        return arrayList;
    }

    @Override
    public List<Byte> getByteList(String string) {
        List<?> list = this.getList(string);
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        for (Object obj : list) {
            if (obj instanceof Byte) {
                arrayList.add((Byte)obj);
                continue;
            }
            if (obj instanceof String) {
                try {
                    arrayList.add(Byte.valueOf((String)obj));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (obj instanceof Character) {
                arrayList.add((byte)((Character)obj).charValue());
                continue;
            }
            if (!(obj instanceof Number)) continue;
            arrayList.add(((Number)obj).byteValue());
        }
        return arrayList;
    }

    @Override
    public List<Character> getCharacterList(String string) {
        List<?> list = this.getList(string);
        ArrayList<Character> arrayList = new ArrayList<Character>();
        for (Object obj : list) {
            if (obj instanceof Character) {
                arrayList.add((Character)obj);
                continue;
            }
            if (obj instanceof String) {
                String string2 = (String)obj;
                if (string2.length() != 1) continue;
                arrayList.add(Character.valueOf(string2.charAt(0)));
                continue;
            }
            if (!(obj instanceof Number)) continue;
            arrayList.add(Character.valueOf((char)((Number)obj).intValue()));
        }
        return arrayList;
    }

    @Override
    public List<Short> getShortList(String string) {
        List<?> list = this.getList(string);
        ArrayList<Short> arrayList = new ArrayList<Short>();
        for (Object obj : list) {
            if (obj instanceof Short) {
                arrayList.add((Short)obj);
                continue;
            }
            if (obj instanceof String) {
                try {
                    arrayList.add(Short.valueOf((String)obj));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (obj instanceof Character) {
                arrayList.add((short)((Character)obj).charValue());
                continue;
            }
            if (!(obj instanceof Number)) continue;
            arrayList.add(((Number)obj).shortValue());
        }
        return arrayList;
    }

    @Override
    public List<Map<?, ?>> getMapList(String string) {
        List<?> list = this.getList(string);
        ArrayList arrayList = new ArrayList();
        for (Object obj : list) {
            if (!(obj instanceof Map)) continue;
            arrayList.add((Map)obj);
        }
        return arrayList;
    }

    @Override
    public ConfigurationSection getConfigurationSection(String string) {
        Object object = this.get(string, null);
        if (object != null) {
            return object instanceof ConfigurationSection ? (ConfigurationSection)object : null;
        }
        object = this.get(string, this.getDefault(string));
        return object instanceof ConfigurationSection ? this.createSection(string) : null;
    }

    @Override
    public boolean isConfigurationSection(String string) {
        Object object = this.get(string);
        return object instanceof ConfigurationSection;
    }

    protected boolean isPrimitiveWrapper(Object object) {
        return object instanceof Integer || object instanceof Boolean || object instanceof Character || object instanceof Byte || object instanceof Short || object instanceof Double || object instanceof Long || object instanceof Float;
    }

    protected Object getDefault(String string) {
        Configuration configuration = this.getRoot();
        Configuration configuration2 = configuration == null ? null : configuration.getDefaults();
        return configuration2 == null ? null : configuration2.get(MemorySection.createPath(this, string));
    }

    protected void mapChildrenKeys(Set<String> set, ConfigurationSection configurationSection, boolean bl) {
        if (configurationSection instanceof MemorySection) {
            MemorySection memorySection = (MemorySection)configurationSection;
            for (Map.Entry<String, Object> entry : memorySection.map.entrySet()) {
                Object object;
                set.add(MemorySection.createPath(configurationSection, entry.getKey(), this));
                if (!bl || !((object = entry.getValue()) instanceof ConfigurationSection)) continue;
                ConfigurationSection configurationSection2 = (ConfigurationSection)object;
                this.mapChildrenKeys(set, configurationSection2, bl);
            }
        } else {
            Set<String> set2 = configurationSection.getKeys(bl);
            for (String string : set2) {
                set.add(MemorySection.createPath(configurationSection, string, this));
            }
        }
    }

    protected void mapChildrenValues(Map<String, Object> map, ConfigurationSection configurationSection, boolean bl) {
        if (configurationSection instanceof MemorySection) {
            MemorySection memorySection = (MemorySection)configurationSection;
            for (Map.Entry<String, Object> entry : memorySection.map.entrySet()) {
                map.put(MemorySection.createPath(configurationSection, entry.getKey(), this), entry.getValue());
                if (!(entry.getValue() instanceof ConfigurationSection) || !bl) continue;
                this.mapChildrenValues(map, (ConfigurationSection)entry.getValue(), bl);
            }
        } else {
            Map<String, Object> map2 = configurationSection.getValues(bl);
            for (Map.Entry<String, Object> entry : map2.entrySet()) {
                map.put(MemorySection.createPath(configurationSection, entry.getKey(), this), entry.getValue());
            }
        }
    }

    public String toString() {
        Configuration configuration = this.getRoot();
        if (configuration == null) {
            return this.getClass().getSimpleName() + "[path='" + this.getCurrentPath() + "', root='null']";
        }
        return this.getClass().getSimpleName() + "[path='" + this.getCurrentPath() + "', root='" + configuration.getClass().getSimpleName() + "']";
    }
}

