/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.configuration.adventure.text.minimessage.internal;

import com.plotsquared.core.annotations.annotations.ApiStatus;
import com.plotsquared.core.annotations.annotations.NotNull;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.TagPattern;
import com.plotsquared.core.intellij.annotations.annotations.RegExp;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;

@ApiStatus.Internal
public final class TagInternals {
    @RegExp
    public static final String TAG_NAME_REGEX = "[!?#]?[a-z0-9_-]*";
    private static final Pattern TAG_NAME_PATTERN = Pattern.compile("[!?#]?[a-z0-9_-]*");

    private TagInternals() {
    }

    public static void assertValidTagName(@TagPattern @NotNull String string) {
        if (!TAG_NAME_PATTERN.matcher(Objects.requireNonNull(string)).matches()) {
            throw new IllegalArgumentException("Tag name must match pattern " + TAG_NAME_PATTERN.pattern() + ", was " + string);
        }
    }

    public static boolean sanitizeAndCheckValidTagName(@TagPattern @NotNull String string) {
        return TAG_NAME_PATTERN.matcher(Objects.requireNonNull(string).toLowerCase(Locale.ROOT)).matches();
    }

    public static void sanitizeAndAssertValidTagName(@TagPattern @NotNull String string) {
        TagInternals.assertValidTagName(Objects.requireNonNull(string).toLowerCase(Locale.ROOT));
    }
}

