/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.configuration.adventure.text.serializer.legacy;

import com.plotsquared.core.annotations.annotations.NotNull;
import com.plotsquared.core.annotations.annotations.Nullable;
import com.plotsquared.core.configuration.adventure.internal.Internals;
import com.plotsquared.core.configuration.adventure.text.format.TextFormat;
import com.plotsquared.core.configuration.adventure.text.serializer.legacy.CharacterAndFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

final class CharacterAndFormatImpl
implements CharacterAndFormat {
    private final char character;
    private final TextFormat format;

    CharacterAndFormatImpl(char c, @NotNull TextFormat textFormat) {
        this.character = c;
        this.format = Objects.requireNonNull(textFormat, "format");
    }

    @Override
    public char character() {
        return this.character;
    }

    @Override
    @NotNull
    public TextFormat format() {
        return this.format;
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CharacterAndFormatImpl)) {
            return false;
        }
        CharacterAndFormatImpl characterAndFormatImpl = (CharacterAndFormatImpl)object;
        return this.character == characterAndFormatImpl.character && this.format.equals(characterAndFormatImpl.format);
    }

    public int hashCode() {
        int n = this.character;
        n = 31 * n + this.format.hashCode();
        return n;
    }

    @NotNull
    public String toString() {
        return Internals.toString(this);
    }

    static final class Defaults {
        static final List<CharacterAndFormat> DEFAULTS = Defaults.createDefaults();

        private Defaults() {
        }

        static List<CharacterAndFormat> createDefaults() {
            ArrayList<CharacterAndFormat> arrayList = new ArrayList<CharacterAndFormat>(22);
            arrayList.add(CharacterAndFormat.BLACK);
            arrayList.add(CharacterAndFormat.DARK_BLUE);
            arrayList.add(CharacterAndFormat.DARK_GREEN);
            arrayList.add(CharacterAndFormat.DARK_AQUA);
            arrayList.add(CharacterAndFormat.DARK_RED);
            arrayList.add(CharacterAndFormat.DARK_PURPLE);
            arrayList.add(CharacterAndFormat.GOLD);
            arrayList.add(CharacterAndFormat.GRAY);
            arrayList.add(CharacterAndFormat.DARK_GRAY);
            arrayList.add(CharacterAndFormat.BLUE);
            arrayList.add(CharacterAndFormat.GREEN);
            arrayList.add(CharacterAndFormat.AQUA);
            arrayList.add(CharacterAndFormat.RED);
            arrayList.add(CharacterAndFormat.LIGHT_PURPLE);
            arrayList.add(CharacterAndFormat.YELLOW);
            arrayList.add(CharacterAndFormat.WHITE);
            arrayList.add(CharacterAndFormat.OBFUSCATED);
            arrayList.add(CharacterAndFormat.BOLD);
            arrayList.add(CharacterAndFormat.STRIKETHROUGH);
            arrayList.add(CharacterAndFormat.UNDERLINED);
            arrayList.add(CharacterAndFormat.ITALIC);
            arrayList.add(CharacterAndFormat.RESET);
            return Collections.unmodifiableList(arrayList);
        }
    }
}

