/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.configuration.caption;

import com.google.common.collect.ImmutableSet;
import com.plotsquared.core.configuration.caption.CaptionMap;
import com.plotsquared.core.configuration.caption.LocaleHolder;
import com.plotsquared.core.configuration.caption.LocalizedCaptionMap;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;

public class PerUserLocaleCaptionMap
extends LocalizedCaptionMap {
    private final Map<Locale, CaptionMap> localeMap;

    public PerUserLocaleCaptionMap(Map<Locale, CaptionMap> map) {
        super(Locale.ROOT, Collections.emptyMap());
        this.localeMap = map;
    }

    @Override
    public @NonNull String getMessage(@NonNull TranslatableCaption translatableCaption, @NonNull LocaleHolder localeHolder) {
        return this.localeMap.get(localeHolder.getLocale()).getMessage(translatableCaption);
    }

    @Override
    public boolean supportsLocale(@NonNull Locale locale) {
        return this.localeMap.containsKey(locale);
    }

    @Override
    public @NonNull Set<TranslatableCaption> getCaptions() {
        return ImmutableSet.copyOf(this.localeMap.get(LocaleHolder.console().getLocale()).getCaptions());
    }
}

