/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.configuration.caption;

import com.google.common.base.Objects;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.annotations.annotations.NotNull;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.MiniMessage;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.LocaleHolder;
import com.plotsquared.core.configuration.caption.NamespacedCaption;
import java.util.Locale;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class TranslatableCaption
implements NamespacedCaption {
    public static final String DEFAULT_NAMESPACE = "plotsquared";
    private final String namespace;
    private final String key;

    private TranslatableCaption(@NonNull String string, @NonNull String string2) {
        this.namespace = string;
        this.key = string2;
    }

    public static @NonNull TranslatableCaption of(@NonNull String string) {
        String string2;
        String string3;
        if (string.contains(":")) {
            String[] stringArray = string.split(Pattern.quote(":"));
            string3 = stringArray[0];
            string2 = stringArray[1];
        } else {
            string3 = DEFAULT_NAMESPACE;
            string2 = string;
        }
        return new TranslatableCaption(string3.toLowerCase(Locale.ENGLISH), string2.toLowerCase(Locale.ENGLISH));
    }

    public static @NonNull TranslatableCaption of(@NonNull String string, @NonNull String string2) {
        return new TranslatableCaption(string.toLowerCase(Locale.ENGLISH), string2.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public @NonNull String getComponent(@NonNull LocaleHolder localeHolder) {
        return PlotSquared.get().getCaptionMap(this.namespace).getMessage(this, localeHolder);
    }

    @Override
    public @NonNull Component toComponent(@NonNull LocaleHolder localeHolder) {
        if (this.getKey().equals("core.prefix")) {
            return MiniMessage.miniMessage().deserialize(this.getComponent(localeHolder));
        }
        return MiniMessage.miniMessage().deserialize(this.getComponent(localeHolder), (TagResolver)TagResolver.resolver("prefix", Tag.inserting(TranslatableCaption.of("core.prefix").toComponent(localeHolder))));
    }

    @Override
    public @NonNull String getKey() {
        return this.key;
    }

    @Override
    public @NonNull String getNamespace() {
        return this.namespace;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TranslatableCaption translatableCaption = (TranslatableCaption)object;
        return Objects.equal((Object)this.getNamespace(), (Object)translatableCaption.getNamespace()) && Objects.equal((Object)this.getKey(), (Object)translatableCaption.getKey());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getNamespace(), this.getKey()});
    }

    @Override
    @NotNull
    public String toString() {
        return "TranslatableCaption(" + this.getNamespace() + ":" + this.getKey() + ")";
    }
}

