/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.configuration.examination.string;

import com.plotsquared.core.annotations.annotations.NotNull;
import java.util.stream.Stream;

final class Strings {
    private Strings() {
    }

    @NotNull
    static String withSuffix(String string, char c) {
        return string + c;
    }

    @NotNull
    static String wrapIn(String string, char c) {
        return c + string + c;
    }

    static int maxLength(Stream<String> stream) {
        return stream.mapToInt(String::length).max().orElse(0);
    }

    @NotNull
    static String repeat(@NotNull String string, int n) {
        if (n == 0) {
            return "";
        }
        if (n == 1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() * n);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    @NotNull
    static String padEnd(@NotNull String string, int n, char c) {
        return string.length() >= n ? string : String.format("%-" + n + "s", Character.valueOf(c));
    }
}

