/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.configuration.file;

import com.plotsquared.core.configuration.ConfigurationSection;
import com.plotsquared.core.configuration.InvalidConfigurationException;
import com.plotsquared.core.configuration.file.FileConfiguration;
import com.plotsquared.core.configuration.file.YamlConfigurationOptions;
import com.plotsquared.core.configuration.file.YamlConstructor;
import com.plotsquared.core.configuration.file.YamlRepresenter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.representer.Representer;

public class YamlConfiguration
extends FileConfiguration {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + YamlConfiguration.class.getSimpleName()));
    private static final String COMMENT_PREFIX = "# ";
    private static final String BLANK_CONFIG = "{}\n";
    private final DumperOptions yamlOptions = new DumperOptions();
    private final Representer yamlRepresenter = new YamlRepresenter();
    private final Yaml yaml = new Yaml((BaseConstructor)new YamlConstructor(), this.yamlRepresenter, this.yamlOptions);

    public static YamlConfiguration loadConfiguration(File file) {
        YamlConfiguration yamlConfiguration = new YamlConfiguration();
        try {
            yamlConfiguration.load(file);
        }
        catch (InvalidConfigurationException | IOException exception) {
            try {
                File file2 = new File(file.getAbsolutePath() + "_broken");
                int n = 0;
                while (file2.exists()) {
                    file2 = new File(file.getAbsolutePath() + "_broken_" + n++);
                }
                Files.copy(file.toPath(), file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
                LOGGER.error("Could not read: {}", (Object)file);
                LOGGER.error("Renamed to: {}", (Object)file);
                LOGGER.error("============ Full stacktrace ============");
                exception.printStackTrace();
                LOGGER.error("=========================================");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return yamlConfiguration;
    }

    @Override
    public String saveToString() {
        this.yamlOptions.setIndent(this.options().indent());
        this.yamlOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.yamlRepresenter.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        String string = this.buildHeader();
        String string2 = this.yaml.dump(this.getValues(false));
        if (string2.equals(BLANK_CONFIG)) {
            string2 = "";
        }
        return string + string2;
    }

    @Override
    public void loadFromString(String string) {
        Map map;
        try {
            map = (Map)this.yaml.load(string);
        }
        catch (YAMLException yAMLException) {
            throw new InvalidConfigurationException(yAMLException);
        }
        catch (ClassCastException classCastException) {
            throw new InvalidConfigurationException("Top level is not a Map.");
        }
        String string2 = this.parseHeader(string);
        if (!string2.isEmpty()) {
            this.options().header(string2);
        }
        if (map != null) {
            this.convertMapsToSections(map, this);
        }
    }

    protected void convertMapsToSections(Map<?, ?> map, ConfigurationSection configurationSection) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String string = entry.getKey().toString();
            Object obj = entry.getValue();
            if (obj instanceof Map) {
                this.convertMapsToSections((Map)obj, configurationSection.createSection(string));
                continue;
            }
            configurationSection.set(string, obj);
        }
    }

    protected String parseHeader(String string) {
        String[] stringArray = string.split("\r?\n", -1);
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        boolean bl2 = false;
        for (int i = 0; i < stringArray.length && bl; ++i) {
            String string2 = stringArray[i];
            if (string2.startsWith(COMMENT_PREFIX)) {
                if (i > 0) {
                    stringBuilder.append('\n');
                }
                if (string2.length() > COMMENT_PREFIX.length()) {
                    stringBuilder.append(string2.substring(COMMENT_PREFIX.length()));
                }
                bl2 = true;
                continue;
            }
            if (bl2 && string2.isEmpty()) {
                stringBuilder.append('\n');
                continue;
            }
            if (!bl2) continue;
            bl = false;
        }
        return stringBuilder.toString();
    }

    @Override
    protected String buildHeader() {
        String[] stringArray;
        String string;
        Object object;
        String string2 = this.options().header();
        if (this.options().copyHeader() && (object = this.getDefaults()) instanceof FileConfiguration && (string = (stringArray = (String[])object).buildHeader()) != null && !string.isEmpty()) {
            return string;
        }
        if (string2 == null) {
            return "";
        }
        object = new StringBuilder();
        stringArray = string2.split("\r?\n", -1);
        boolean bl = false;
        for (int i = stringArray.length - 1; i >= 0; --i) {
            ((StringBuilder)object).insert(0, '\n');
            if (!bl && stringArray[i].isEmpty()) continue;
            ((StringBuilder)object).insert(0, stringArray[i]);
            ((StringBuilder)object).insert(0, COMMENT_PREFIX);
            bl = true;
        }
        return ((StringBuilder)object).toString();
    }

    @Override
    public YamlConfigurationOptions options() {
        if (this.options == null) {
            this.options = new YamlConfigurationOptions(this);
        }
        return (YamlConfigurationOptions)this.options;
    }
}

