/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.database;

import com.plotsquared.core.configuration.Storage;
import com.plotsquared.core.database.Database;
import com.plotsquared.core.util.StringMan;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;

public class MySQL
extends Database {
    private final String user;
    private final String database;
    private final String password;
    private final String port;
    private final String hostname;
    private Connection connection;

    public MySQL(String string, String string2, String string3, String string4, String string5) {
        this.hostname = string;
        this.port = string2;
        this.database = string3;
        this.user = string4;
        this.password = string5;
        this.connection = null;
    }

    @Override
    public Connection forceConnection() {
        this.connection = DriverManager.getConnection("jdbc:mysql://" + this.hostname + ":" + this.port + "/" + this.database + "?" + StringMan.join(Storage.MySQL.PROPERTIES, "&"), this.user, this.password);
        return this.connection;
    }

    @Override
    public Connection openConnection() {
        if (this.checkConnection()) {
            return this.connection;
        }
        return this.forceConnection();
    }

    @Override
    public boolean checkConnection() {
        return this.connection != null && !this.connection.isClosed();
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public boolean closeConnection() {
        if (this.connection == null) {
            return false;
        }
        this.connection.close();
        this.connection = null;
        return true;
    }

    @Override
    public ResultSet querySQL(String string) {
        if (this.checkConnection()) {
            this.openConnection();
        }
        try (Statement statement = this.connection.createStatement();){
            ResultSet resultSet = statement.executeQuery(string);
            return resultSet;
        }
    }

    @Override
    public int updateSQL(String string) {
        if (this.checkConnection()) {
            this.openConnection();
        }
        try (Statement statement = this.connection.createStatement();){
            int n = statement.executeUpdate(string);
            return n;
        }
    }
}

