/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.database;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.database.Database;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SQLite
extends Database {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + SQLite.class.getSimpleName()));
    private final String dbLocation;
    private Connection connection;

    public SQLite(File file) {
        this.dbLocation = file.getAbsolutePath();
    }

    @Override
    public Connection openConnection() {
        File file;
        if (this.checkConnection()) {
            return this.connection;
        }
        if (!PlotSquared.platform().getDirectory().exists()) {
            PlotSquared.platform().getDirectory().mkdirs();
        }
        if (!(file = new File(this.dbLocation)).exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                LOGGER.error("Unable to create database");
            }
        }
        Class.forName("org.sqlite.JDBC");
        this.connection = DriverManager.getConnection("jdbc:sqlite:" + this.dbLocation);
        return this.connection;
    }

    @Override
    public boolean checkConnection() {
        return this.connection != null && !this.connection.isClosed();
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public boolean closeConnection() {
        if (this.connection == null) {
            return false;
        }
        this.connection.close();
        this.connection = null;
        return true;
    }

    @Override
    public ResultSet querySQL(String string) {
        if (this.checkConnection()) {
            this.openConnection();
        }
        try (Statement statement = this.connection.createStatement();){
            ResultSet resultSet = statement.executeQuery(string);
            return resultSet;
        }
    }

    @Override
    public int updateSQL(String string) {
        if (this.checkConnection()) {
            this.openConnection();
        }
        try (Statement statement = this.connection.createStatement();){
            int n = statement.executeUpdate(string);
            return n;
        }
    }

    @Override
    public Connection forceConnection() {
        Class.forName("org.sqlite.JDBC");
        this.connection = DriverManager.getConnection("jdbc:sqlite:" + this.dbLocation);
        return this.connection;
    }
}

