/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.geantyref;

import com.plotsquared.core.geantyref.GenericTypeReflector;
import java.lang.reflect.AnnotatedType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;

public class AnnotatedTypeSet<E extends AnnotatedType>
implements Set<E> {
    private final Set<E> inner;

    public AnnotatedTypeSet() {
        this(new HashSet());
    }

    public AnnotatedTypeSet(Set<E> set) {
        this.inner = set;
    }

    @Override
    public int size() {
        return this.inner.size();
    }

    @Override
    public boolean isEmpty() {
        return this.inner.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return object instanceof AnnotatedType && this.inner.contains(GenericTypeReflector.toCanonical((AnnotatedType)object));
    }

    @Override
    public Iterator<E> iterator() {
        return this.inner.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.inner.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.inner.toArray(TArray);
    }

    @Override
    public boolean add(E e) {
        return this.inner.add(GenericTypeReflector.toCanonical(e));
    }

    @Override
    public boolean remove(Object object) {
        return object instanceof AnnotatedType && this.inner.remove(GenericTypeReflector.toCanonical((AnnotatedType)object));
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.inner.containsAll(this.canonical(collection));
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        return this.inner.addAll(collection.stream().map(GenericTypeReflector::toCanonical).collect(Collectors.toList()));
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.inner.retainAll(this.canonical(collection));
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.inner.removeAll(this.canonical(collection));
    }

    @Override
    public void clear() {
        this.inner.clear();
    }

    private Collection<?> canonical(Collection<?> collection) {
        return collection.stream().map(object -> object instanceof AnnotatedType ? GenericTypeReflector.toCanonical((AnnotatedType)object) : object).collect(Collectors.toList());
    }
}

