/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.geantyref;

import com.plotsquared.core.geantyref.AnnotationFormatException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;

class AnnotationInvocationHandler
implements Annotation,
InvocationHandler,
Serializable {
    private static final long serialVersionUID = 8615044376674805680L;
    private static final Map<Class<?>, Class<?>> primitiveWrapperMap = new HashMap();
    private final Class<? extends Annotation> annotationType;
    private final Map<String, Object> values;
    private final int hashCode;

    AnnotationInvocationHandler(Class<? extends Annotation> clazz, Map<String, Object> map) {
        Class<?>[] classArray = clazz.getInterfaces();
        if (!clazz.isAnnotation() || classArray.length != 1 || classArray[0] != Annotation.class) {
            throw new AnnotationFormatException(clazz.getName() + " is not an annotation type");
        }
        this.annotationType = clazz;
        this.values = Collections.unmodifiableMap(AnnotationInvocationHandler.normalize(clazz, map));
        this.hashCode = this.calculateHashCode();
    }

    static Map<String, Object> normalize(Class<? extends Annotation> clazz, Map<String, Object> map) {
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Method method : clazz.getDeclaredMethods()) {
            String string = method.getName();
            if (map.containsKey(string)) {
                Class<?> clazz2 = method.getReturnType();
                if (clazz2.isPrimitive()) {
                    clazz2 = primitiveWrapperMap.get(clazz2);
                }
                if (clazz2.isInstance(map.get(string))) {
                    hashMap.put(string, map.get(string));
                    continue;
                }
                hashSet2.add(string);
                continue;
            }
            if (method.getDefaultValue() != null) {
                hashMap.put(string, method.getDefaultValue());
                continue;
            }
            hashSet.add(string);
        }
        if (!hashSet.isEmpty()) {
            throw new AnnotationFormatException("Missing value(s) for " + String.join((CharSequence)",", hashSet));
        }
        if (!hashSet2.isEmpty()) {
            throw new AnnotationFormatException("Incompatible type(s) provided for " + String.join((CharSequence)",", hashSet2));
        }
        return hashMap;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) {
        if (this.values.containsKey(method.getName())) {
            return this.values.get(method.getName());
        }
        return method.invoke((Object)this, objectArray);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return this.annotationType;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!this.annotationType.isInstance(object)) {
            return false;
        }
        Annotation annotation = this.annotationType.cast(object);
        for (Map.Entry<String, Object> entry : this.values.entrySet()) {
            Object object2;
            Object object3 = entry.getValue();
            try {
                object2 = annotation.annotationType().getMethod(entry.getKey(), new Class[0]).invoke((Object)annotation, new Object[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new RuntimeException(reflectiveOperationException);
            }
            if (Objects.deepEquals(object3, object2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('@').append(this.annotationType.getName()).append('(');
        TreeSet<String> treeSet = new TreeSet<String>(this.values.keySet());
        for (String string : treeSet) {
            String string2 = this.values.get(string).getClass().isArray() ? Arrays.deepToString(new Object[]{this.values.get(string)}).replaceAll("^\\[\\[", "[").replaceAll("]]$", "]") : this.values.get(string).toString();
            stringBuilder.append(string).append('=').append(string2).append(", ");
        }
        if (this.values.size() > 0) {
            stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private int calculateHashCode() {
        int n = 0;
        for (Map.Entry<String, Object> entry : this.values.entrySet()) {
            n += 127 * entry.getKey().hashCode() ^ this.calculateHashCode(entry.getValue());
        }
        return n;
    }

    private int calculateHashCode(Object object) {
        if (!object.getClass().isArray()) {
            return object.hashCode();
        }
        if (object instanceof Object[]) {
            return Arrays.hashCode((Object[])object);
        }
        if (object instanceof byte[]) {
            return Arrays.hashCode((byte[])object);
        }
        if (object instanceof short[]) {
            return Arrays.hashCode((short[])object);
        }
        if (object instanceof int[]) {
            return Arrays.hashCode((int[])object);
        }
        if (object instanceof long[]) {
            return Arrays.hashCode((long[])object);
        }
        if (object instanceof char[]) {
            return Arrays.hashCode((char[])object);
        }
        if (object instanceof float[]) {
            return Arrays.hashCode((float[])object);
        }
        if (object instanceof double[]) {
            return Arrays.hashCode((double[])object);
        }
        if (object instanceof boolean[]) {
            return Arrays.hashCode((boolean[])object);
        }
        return Objects.hashCode(object);
    }

    static {
        primitiveWrapperMap.put(Boolean.TYPE, Boolean.class);
        primitiveWrapperMap.put(Byte.TYPE, Byte.class);
        primitiveWrapperMap.put(Character.TYPE, Character.class);
        primitiveWrapperMap.put(Short.TYPE, Short.class);
        primitiveWrapperMap.put(Integer.TYPE, Integer.class);
        primitiveWrapperMap.put(Long.TYPE, Long.class);
        primitiveWrapperMap.put(Double.TYPE, Double.class);
        primitiveWrapperMap.put(Float.TYPE, Float.class);
    }
}

