/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.geantyref;

import com.plotsquared.core.geantyref.AnnotatedArrayTypeImpl;
import com.plotsquared.core.geantyref.AnnotatedParameterizedTypeImpl;
import com.plotsquared.core.geantyref.AnnotatedTypeVariableImpl;
import com.plotsquared.core.geantyref.AnnotatedWildcardTypeImpl;
import com.plotsquared.core.geantyref.GenericTypeReflector;
import com.plotsquared.core.geantyref.ParameterizedTypeImpl;
import com.plotsquared.core.geantyref.TypeVariableImpl;
import com.plotsquared.core.geantyref.UnresolvedTypeVariableException;
import com.plotsquared.core.geantyref.WildcardTypeImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedTypeVariable;
import java.lang.reflect.AnnotatedWildcardType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

class VarMap {
    private final Map<TypeVariable, AnnotatedType> map = new HashMap<TypeVariable, AnnotatedType>();

    VarMap() {
    }

    VarMap(AnnotatedParameterizedType annotatedParameterizedType) {
        Type type;
        do {
            TypeVariable<Class<T>>[] typeVariableArray;
            Class clazz = (Class)((ParameterizedType)annotatedParameterizedType.getType()).getRawType();
            AnnotatedType[] annotatedTypeArray = annotatedParameterizedType.getAnnotatedActualTypeArguments();
            if (annotatedTypeArray.length != (typeVariableArray = clazz.getTypeParameters()).length) {
                throw new IllegalStateException("The given type [" + annotatedParameterizedType + "] is inconsistent: it has " + annotatedTypeArray.length + " arguments instead of " + typeVariableArray.length);
            }
            for (int i = 0; i < annotatedTypeArray.length; ++i) {
                this.add(typeVariableArray[i], annotatedTypeArray[i]);
            }
        } while ((annotatedParameterizedType = (type = ((ParameterizedType)annotatedParameterizedType.getType()).getOwnerType()) instanceof ParameterizedType ? (AnnotatedParameterizedType)GenericTypeReflector.annotate(type) : null) != null);
    }

    VarMap(ParameterizedType parameterizedType) {
        this((AnnotatedParameterizedType)GenericTypeReflector.annotate(parameterizedType));
    }

    VarMap(TypeVariable[] typeVariableArray, AnnotatedType[] annotatedTypeArray) {
        this.addAll(typeVariableArray, annotatedTypeArray);
    }

    void add(TypeVariable typeVariable, AnnotatedType annotatedType) {
        this.map.put(typeVariable, annotatedType);
    }

    void addAll(TypeVariable[] typeVariableArray, AnnotatedType[] annotatedTypeArray) {
        assert (typeVariableArray.length == annotatedTypeArray.length);
        for (int i = 0; i < typeVariableArray.length; ++i) {
            this.map.put(typeVariableArray[i], annotatedTypeArray[i]);
        }
    }

    AnnotatedType map(AnnotatedType annotatedType) {
        return this.map(annotatedType, MappingMode.EXACT);
    }

    AnnotatedType map(AnnotatedType annotatedType, MappingMode mappingMode) {
        if (annotatedType.getType() instanceof Class) {
            return GenericTypeReflector.updateAnnotations(annotatedType, ((Class)annotatedType.getType()).getAnnotations());
        }
        if (annotatedType instanceof AnnotatedTypeVariable) {
            TypeVariable typeVariable = (TypeVariable)annotatedType.getType();
            if (!this.map.containsKey(typeVariable)) {
                if (mappingMode.equals((Object)MappingMode.ALLOW_INCOMPLETE)) {
                    AnnotatedTypeVariable annotatedTypeVariable = (AnnotatedTypeVariable)annotatedType;
                    AnnotatedType[] annotatedTypeArray = this.map(annotatedTypeVariable.getAnnotatedBounds(), mappingMode);
                    Annotation[] annotationArray = GenericTypeReflector.merge(annotatedTypeVariable.getAnnotations(), typeVariable.getAnnotations());
                    TypeVariableImpl typeVariableImpl = new TypeVariableImpl(typeVariable, annotationArray, annotatedTypeArray);
                    return new AnnotatedTypeVariableImpl(typeVariableImpl, annotationArray);
                }
                throw new UnresolvedTypeVariableException(typeVariable);
            }
            TypeVariable typeVariable3 = this.map.keySet().stream().filter(typeVariable2 -> typeVariable2.equals(typeVariable)).findFirst().get();
            Annotation[] annotationArray = GenericTypeReflector.merge(annotatedType.getAnnotations(), typeVariable.getAnnotations(), this.map.get(typeVariable).getAnnotations(), typeVariable3.getAnnotations());
            return GenericTypeReflector.updateAnnotations(this.map.get(typeVariable), annotationArray);
        }
        if (annotatedType instanceof AnnotatedParameterizedType) {
            AnnotatedType annotatedType2;
            AnnotatedParameterizedType annotatedParameterizedType = (AnnotatedParameterizedType)annotatedType;
            ParameterizedType parameterizedType = (ParameterizedType)annotatedParameterizedType.getType();
            Class clazz = (Class)parameterizedType.getRawType();
            AnnotatedType[] annotatedTypeArray = new AnnotatedType[clazz.getTypeParameters().length];
            for (int i = 0; i < annotatedTypeArray.length; ++i) {
                annotatedType2 = this.map(annotatedParameterizedType.getAnnotatedActualTypeArguments()[i], mappingMode);
                annotatedTypeArray[i] = GenericTypeReflector.updateAnnotations(annotatedType2, clazz.getTypeParameters()[i].getAnnotations());
            }
            Type[] typeArray = (Type[])Arrays.stream(annotatedTypeArray).map(AnnotatedType::getType).toArray(Type[]::new);
            annotatedType2 = parameterizedType.getOwnerType() == null ? null : this.map(GenericTypeReflector.annotate(parameterizedType.getOwnerType()), mappingMode).getType();
            ParameterizedTypeImpl parameterizedTypeImpl = new ParameterizedTypeImpl((Class)parameterizedType.getRawType(), typeArray, (Type)((Object)annotatedType2));
            return new AnnotatedParameterizedTypeImpl(parameterizedTypeImpl, GenericTypeReflector.merge(annotatedParameterizedType.getAnnotations(), clazz.getAnnotations()), annotatedTypeArray);
        }
        if (annotatedType instanceof AnnotatedWildcardType) {
            AnnotatedWildcardType annotatedWildcardType = (AnnotatedWildcardType)annotatedType;
            AnnotatedType[] annotatedTypeArray = this.map(annotatedWildcardType.getAnnotatedUpperBounds(), mappingMode);
            AnnotatedType[] annotatedTypeArray2 = this.map(annotatedWildcardType.getAnnotatedLowerBounds(), mappingMode);
            Type[] typeArray = annotatedTypeArray == null || annotatedTypeArray.length == 0 ? ((WildcardType)annotatedWildcardType.getType()).getUpperBounds() : (Type[])Arrays.stream(annotatedTypeArray).map(AnnotatedType::getType).toArray(Type[]::new);
            WildcardTypeImpl wildcardTypeImpl = new WildcardTypeImpl(typeArray, (Type[])Arrays.stream(annotatedTypeArray2).map(AnnotatedType::getType).toArray(Type[]::new));
            return new AnnotatedWildcardTypeImpl(wildcardTypeImpl, annotatedWildcardType.getAnnotations(), annotatedTypeArray2, annotatedTypeArray);
        }
        if (annotatedType instanceof AnnotatedArrayType) {
            return AnnotatedArrayTypeImpl.createArrayType(this.map(((AnnotatedArrayType)annotatedType).getAnnotatedGenericComponentType(), mappingMode), annotatedType.getAnnotations());
        }
        throw new RuntimeException("Not implemented: mapping " + annotatedType.getClass() + " (" + annotatedType + ")");
    }

    AnnotatedType[] map(AnnotatedType[] annotatedTypeArray) {
        return this.map(annotatedTypeArray, MappingMode.EXACT);
    }

    AnnotatedType[] map(AnnotatedType[] annotatedTypeArray, MappingMode mappingMode) {
        AnnotatedType[] annotatedTypeArray2 = new AnnotatedType[annotatedTypeArray.length];
        for (int i = 0; i < annotatedTypeArray.length; ++i) {
            annotatedTypeArray2[i] = this.map(annotatedTypeArray[i], mappingMode);
        }
        return annotatedTypeArray2;
    }

    Type[] map(Type[] typeArray) {
        AnnotatedType[] annotatedTypeArray = this.map((AnnotatedType[])Arrays.stream(typeArray).map(GenericTypeReflector::annotate).toArray(AnnotatedType[]::new));
        return (Type[])Arrays.stream(annotatedTypeArray).map(AnnotatedType::getType).toArray(Type[]::new);
    }

    Type map(Type type) {
        return this.map(GenericTypeReflector.annotate(type)).getType();
    }

    public static enum MappingMode {
        EXACT,
        ALLOW_INCOMPLETE;

    }
}

