/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.generator;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.generator.ClassicPlotManagerComponent;
import com.plotsquared.core.generator.ClassicPlotWorld;
import com.plotsquared.core.generator.SquarePlotManager;
import com.plotsquared.core.inject.factory.ProgressSubscriberFactory;
import com.plotsquared.core.location.Direction;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.BlockBucket;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotAreaTerrainType;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.queue.QueueCoordinator;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.RegionManager;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.google.Inject;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ClassicPlotManager
extends SquarePlotManager {
    private final ClassicPlotWorld classicPlotWorld;
    private final RegionManager regionManager;
    private final ProgressSubscriberFactory subscriberFactory;

    @Inject
    public ClassicPlotManager(@NonNull ClassicPlotWorld classicPlotWorld, @NonNull RegionManager regionManager) {
        super(classicPlotWorld, regionManager);
        this.classicPlotWorld = classicPlotWorld;
        this.regionManager = regionManager;
        this.subscriberFactory = PlotSquared.platform().injector().getInstance(ProgressSubscriberFactory.class);
    }

    @Override
    public boolean setComponent(@NonNull PlotId plotId, @NonNull String string, @NonNull Pattern pattern, @Nullable PlotPlayer<?> plotPlayer, @Nullable QueueCoordinator queueCoordinator) {
        Optional<ClassicPlotManagerComponent> optional = ClassicPlotManagerComponent.fromString(string);
        return optional.map(classicPlotManagerComponent -> switch (classicPlotManagerComponent) {
            default -> throw new IncompatibleClassChangeError();
            case ClassicPlotManagerComponent.FLOOR -> this.setFloor(plotId, pattern, plotPlayer, queueCoordinator);
            case ClassicPlotManagerComponent.WALL -> this.setWallFilling(plotId, pattern, plotPlayer, queueCoordinator);
            case ClassicPlotManagerComponent.AIR -> this.setAir(plotId, pattern, plotPlayer, queueCoordinator);
            case ClassicPlotManagerComponent.MAIN -> this.setMain(plotId, pattern, plotPlayer, queueCoordinator);
            case ClassicPlotManagerComponent.MIDDLE -> this.setMiddle(plotId, pattern, queueCoordinator);
            case ClassicPlotManagerComponent.OUTLINE -> this.setOutline(plotId, pattern, plotPlayer, queueCoordinator);
            case ClassicPlotManagerComponent.BORDER -> this.setWall(plotId, pattern, plotPlayer, queueCoordinator);
            case ClassicPlotManagerComponent.ALL -> this.setAll(plotId, pattern, plotPlayer, queueCoordinator);
        }).orElse(false);
    }

    @Override
    public boolean unClaimPlot(@NonNull Plot plot, @Nullable Runnable runnable, @Nullable QueueCoordinator queueCoordinator) {
        this.setWallFilling(plot.getId(), this.classicPlotWorld.WALL_FILLING.toPattern(), null, queueCoordinator);
        if (!(!this.classicPlotWorld.PLACE_TOP_BLOCK || this.classicPlotWorld.WALL_BLOCK.isAir() && this.classicPlotWorld.WALL_BLOCK.equals(this.classicPlotWorld.CLAIMED_WALL_BLOCK))) {
            this.setWall(plot.getId(), this.classicPlotWorld.WALL_BLOCK.toPattern(), null, queueCoordinator);
        }
        TaskManager.runTask(runnable);
        return true;
    }

    public boolean setFloor(@NonNull PlotId plotId, @NonNull Pattern pattern, @Nullable PlotPlayer<?> plotPlayer, @Nullable QueueCoordinator queueCoordinator) {
        Plot plot = this.classicPlotWorld.getPlotAbs(plotId);
        if (plot != null && plot.isBasePlot()) {
            return this.regionManager.setCuboids(this.classicPlotWorld, plot.getRegions(), pattern, this.classicPlotWorld.PLOT_HEIGHT, this.classicPlotWorld.PLOT_HEIGHT, plotPlayer, queueCoordinator);
        }
        return false;
    }

    public boolean setAll(@NonNull PlotId plotId, @NonNull Pattern pattern, @Nullable PlotPlayer<?> plotPlayer, @Nullable QueueCoordinator queueCoordinator) {
        Plot plot = this.classicPlotWorld.getPlotAbs(plotId);
        if (plot != null && plot.isBasePlot()) {
            return this.regionManager.setCuboids(this.classicPlotWorld, plot.getRegions(), pattern, this.classicPlotWorld.getMinBuildHeight(), this.classicPlotWorld.getMaxBuildHeight() - 1, plotPlayer, queueCoordinator);
        }
        return false;
    }

    public boolean setAir(@NonNull PlotId plotId, @NonNull Pattern pattern, @Nullable PlotPlayer<?> plotPlayer, @Nullable QueueCoordinator queueCoordinator) {
        Plot plot = this.classicPlotWorld.getPlotAbs(plotId);
        if (plot != null && plot.isBasePlot()) {
            return this.regionManager.setCuboids(this.classicPlotWorld, plot.getRegions(), pattern, this.classicPlotWorld.PLOT_HEIGHT + 1, this.classicPlotWorld.getMaxBuildHeight() - 1, plotPlayer, queueCoordinator);
        }
        return false;
    }

    public boolean setMain(@NonNull PlotId plotId, @NonNull Pattern pattern, @Nullable PlotPlayer<?> plotPlayer, @Nullable QueueCoordinator queueCoordinator) {
        Plot plot = this.classicPlotWorld.getPlotAbs(plotId);
        if (plot == null || plot.isBasePlot()) {
            return this.regionManager.setCuboids(this.classicPlotWorld, plot.getRegions(), pattern, this.classicPlotWorld.getMinBuildHeight(), this.classicPlotWorld.PLOT_HEIGHT - 1, plotPlayer, queueCoordinator);
        }
        return false;
    }

    public boolean setMiddle(@NonNull PlotId plotId, @NonNull Pattern pattern, @Nullable QueueCoordinator queueCoordinator) {
        Plot plot = this.classicPlotWorld.getPlotAbs(plotId);
        if (plot == null || !plot.isBasePlot()) {
            return false;
        }
        Location[] locationArray = plot.getCorners();
        boolean bl = false;
        if (queueCoordinator == null) {
            queueCoordinator = this.classicPlotWorld.getQueue();
            bl = true;
        }
        int n = MathMan.average(locationArray[0].getX(), locationArray[1].getX());
        int n2 = MathMan.average(locationArray[0].getZ(), locationArray[1].getZ());
        queueCoordinator.setBlock(n, this.classicPlotWorld.PLOT_HEIGHT, n2, pattern);
        return !bl || queueCoordinator.enqueue();
    }

    public boolean setOutline(@NonNull PlotId plotId, @NonNull Pattern pattern, @Nullable PlotPlayer<?> plotPlayer, @Nullable QueueCoordinator queueCoordinator) {
        int n;
        int n2;
        int n3;
        if (this.classicPlotWorld.ROAD_WIDTH == 0) {
            return false;
        }
        if (this.classicPlotWorld.getTerrain() == PlotAreaTerrainType.ALL) {
            return true;
        }
        Plot plot = this.classicPlotWorld.getPlotAbs(plotId);
        if (plot == null) {
            return false;
        }
        Location location = plot.getBottomAbs();
        Location location2 = plot.getExtendedTopAbs();
        boolean bl = false;
        if (queueCoordinator == null) {
            queueCoordinator = this.classicPlotWorld.getQueue();
            bl = true;
            if (plotPlayer != null && Settings.QUEUE.NOTIFY_PROGRESS) {
                queueCoordinator.addProgressSubscriber(this.subscriberFactory.createWithActor(plotPlayer));
            }
        }
        int n4 = this.classicPlotWorld.getMaxBuildHeight() - 1;
        if (!plot.isMerged(Direction.NORTH)) {
            n3 = location.getZ();
            for (n2 = location.getX(); n2 <= location2.getX(); ++n2) {
                for (n = this.classicPlotWorld.PLOT_HEIGHT; n <= n4; ++n) {
                    queueCoordinator.setBlock(n2, n, n3, pattern);
                }
            }
        }
        if (!plot.isMerged(Direction.WEST)) {
            n3 = location.getX();
            for (n2 = location.getZ(); n2 <= location2.getZ(); ++n2) {
                for (n = this.classicPlotWorld.PLOT_HEIGHT; n <= n4; ++n) {
                    queueCoordinator.setBlock(n3, n, n2, pattern);
                }
            }
        }
        if (!plot.isMerged(Direction.SOUTH)) {
            n3 = location2.getZ();
            for (n2 = location.getX(); n2 <= location2.getX(); ++n2) {
                for (n = this.classicPlotWorld.PLOT_HEIGHT; n <= n4; ++n) {
                    queueCoordinator.setBlock(n2, n, n3, pattern);
                }
            }
        }
        if (!plot.isMerged(Direction.EAST)) {
            n3 = location2.getX();
            for (n2 = location.getZ(); n2 <= location2.getZ(); ++n2) {
                for (n = this.classicPlotWorld.PLOT_HEIGHT; n <= n4; ++n) {
                    queueCoordinator.setBlock(n3, n, n2, pattern);
                }
            }
        }
        if (plot.isBasePlot()) {
            for (CuboidRegion cuboidRegion : plot.getRegions()) {
                Location location3 = Location.at(this.classicPlotWorld.getWorldName(), cuboidRegion.getMinimumPoint().getX(), n4, cuboidRegion.getMinimumPoint().getZ());
                Location location4 = Location.at(this.classicPlotWorld.getWorldName(), cuboidRegion.getMaximumPoint().getX(), n4, cuboidRegion.getMaximumPoint().getZ());
                queueCoordinator.setCuboid(location3, location4, pattern);
            }
        }
        return !bl || queueCoordinator.enqueue();
    }

    public boolean setWallFilling(@NonNull PlotId plotId, @NonNull Pattern pattern, @Nullable PlotPlayer<?> plotPlayer, @Nullable QueueCoordinator queueCoordinator) {
        int n;
        int n2;
        int n3;
        if (this.classicPlotWorld.ROAD_WIDTH == 0) {
            return false;
        }
        if (this.classicPlotWorld.getTerrain() == PlotAreaTerrainType.ALL) {
            return true;
        }
        Plot plot = this.classicPlotWorld.getPlotAbs(plotId);
        if (plot == null) {
            return false;
        }
        Location location = plot.getExtendedBottomAbs().subtract(plot.isMerged(Direction.WEST) ? 0 : 1, 0, plot.isMerged(Direction.NORTH) ? 0 : 1);
        Location location2 = plot.getExtendedTopAbs().add(1, 0, 1);
        boolean bl = false;
        if (queueCoordinator == null) {
            queueCoordinator = this.classicPlotWorld.getQueue();
            bl = true;
            if (plotPlayer != null && Settings.QUEUE.NOTIFY_PROGRESS) {
                queueCoordinator.addProgressSubscriber(this.subscriberFactory.createWithActor(plotPlayer));
            }
        }
        int n4 = this.classicPlotWorld.getMinBuildHeight() + (this.classicPlotWorld.PLOT_BEDROCK ? 1 : 0);
        if (!plot.isMerged(Direction.NORTH)) {
            n3 = location.getZ();
            for (n2 = location.getX(); n2 < location2.getX(); ++n2) {
                for (n = n4; n <= this.classicPlotWorld.WALL_HEIGHT; ++n) {
                    queueCoordinator.setBlock(n2, n, n3, pattern);
                }
            }
        }
        if (!plot.isMerged(Direction.WEST)) {
            n3 = location.getX();
            for (n2 = location.getZ(); n2 < location2.getZ(); ++n2) {
                for (n = n4; n <= this.classicPlotWorld.WALL_HEIGHT; ++n) {
                    queueCoordinator.setBlock(n3, n, n2, pattern);
                }
            }
        }
        if (!plot.isMerged(Direction.SOUTH)) {
            n3 = location2.getZ();
            for (n2 = location.getX(); n2 < location2.getX() + (plot.isMerged(Direction.EAST) ? 0 : 1); ++n2) {
                for (n = n4; n <= this.classicPlotWorld.WALL_HEIGHT; ++n) {
                    queueCoordinator.setBlock(n2, n, n3, pattern);
                }
            }
        }
        if (!plot.isMerged(Direction.EAST)) {
            n3 = location2.getX();
            for (n2 = location.getZ(); n2 < location2.getZ() + (plot.isMerged(Direction.SOUTH) ? 0 : 1); ++n2) {
                for (n = n4; n <= this.classicPlotWorld.WALL_HEIGHT; ++n) {
                    queueCoordinator.setBlock(n3, n, n2, pattern);
                }
            }
        }
        return !bl || queueCoordinator.enqueue();
    }

    public boolean setWall(@NonNull PlotId plotId, @NonNull Pattern pattern, @Nullable PlotPlayer<?> plotPlayer, @Nullable QueueCoordinator queueCoordinator) {
        int n;
        int n2;
        if (this.classicPlotWorld.ROAD_WIDTH == 0) {
            return false;
        }
        if (this.classicPlotWorld.getTerrain() == PlotAreaTerrainType.ALL) {
            return true;
        }
        Plot plot = this.classicPlotWorld.getPlotAbs(plotId);
        if (plot == null) {
            return false;
        }
        Location location = plot.getExtendedBottomAbs().subtract(plot.isMerged(Direction.WEST) ? 0 : 1, 0, plot.isMerged(Direction.NORTH) ? 0 : 1);
        Location location2 = plot.getExtendedTopAbs().add(1, 0, 1);
        boolean bl = false;
        if (queueCoordinator == null) {
            bl = true;
            queueCoordinator = this.classicPlotWorld.getQueue();
            if (plotPlayer != null && Settings.QUEUE.NOTIFY_PROGRESS) {
                queueCoordinator.addProgressSubscriber(this.subscriberFactory.createWithActor(plotPlayer));
            }
        }
        int n3 = this.classicPlotWorld.WALL_HEIGHT + 1;
        if (!plot.isMerged(Direction.NORTH)) {
            n2 = location.getZ();
            for (n = location.getX(); n < location2.getX(); ++n) {
                queueCoordinator.setBlock(n, n3, n2, pattern);
            }
        }
        if (!plot.isMerged(Direction.WEST)) {
            n2 = location.getX();
            for (n = location.getZ(); n < location2.getZ(); ++n) {
                queueCoordinator.setBlock(n2, n3, n, pattern);
            }
        }
        if (!plot.isMerged(Direction.SOUTH)) {
            n2 = location2.getZ();
            for (n = location.getX(); n < location2.getX() + (plot.isMerged(Direction.EAST) ? 0 : 1); ++n) {
                queueCoordinator.setBlock(n, n3, n2, pattern);
            }
        }
        if (!plot.isMerged(Direction.EAST)) {
            n2 = location2.getX();
            for (n = location.getZ(); n < location2.getZ() + (plot.isMerged(Direction.SOUTH) ? 0 : 1); ++n) {
                queueCoordinator.setBlock(n2, n3, n, pattern);
            }
        }
        return !bl || queueCoordinator.enqueue();
    }

    @Override
    public boolean createRoadEast(@NonNull Plot plot, @Nullable QueueCoordinator queueCoordinator) {
        Location location = this.getPlotBottomLocAbs(plot.getId());
        Location location2 = this.getPlotTopLocAbs(plot.getId());
        int n = location2.getX() + 1;
        int n2 = n + this.classicPlotWorld.ROAD_WIDTH - 1;
        int n3 = location.getZ() - 2;
        int n4 = location2.getZ() + 2;
        boolean bl = false;
        if (queueCoordinator == null) {
            queueCoordinator = this.classicPlotWorld.getQueue();
            bl = true;
        }
        int n5 = this.classicPlotWorld.getMaxGenHeight();
        queueCoordinator.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), n, this.classicPlotWorld.schematicStartHeight() + 1, n3 + 1), Location.at(this.classicPlotWorld.getWorldName(), n2, n5, n4 - 1), BlockTypes.AIR.getDefaultState());
        if (this.classicPlotWorld.PLOT_BEDROCK) {
            queueCoordinator.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), n, this.classicPlotWorld.getMinGenHeight(), n3 + 1), Location.at(this.classicPlotWorld.getWorldName(), n2, this.classicPlotWorld.getMinGenHeight(), n4 - 1), BlockTypes.BEDROCK.getDefaultState());
        }
        int n6 = this.classicPlotWorld.PLOT_BEDROCK ? 1 : 0;
        queueCoordinator.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), n2, this.classicPlotWorld.getMinGenHeight() + n6, n3 + 1), Location.at(this.classicPlotWorld.getWorldName(), n2, this.classicPlotWorld.WALL_HEIGHT, n4 - 1), this.classicPlotWorld.WALL_FILLING.toPattern());
        queueCoordinator.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), n, this.classicPlotWorld.getMinGenHeight() + n6, n3 + 1), Location.at(this.classicPlotWorld.getWorldName(), n, this.classicPlotWorld.WALL_HEIGHT, n4 - 1), this.classicPlotWorld.WALL_FILLING.toPattern());
        queueCoordinator.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), n + 1, this.classicPlotWorld.getMinGenHeight() + n6, n3 + 1), Location.at(this.classicPlotWorld.getWorldName(), n2 - 1, this.classicPlotWorld.ROAD_HEIGHT, n4 - 1), this.classicPlotWorld.ROAD_BLOCK.toPattern());
        if (this.classicPlotWorld.PLACE_TOP_BLOCK) {
            queueCoordinator.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), n, this.classicPlotWorld.WALL_HEIGHT + 1, n3 + 1), Location.at(this.classicPlotWorld.getWorldName(), n, this.classicPlotWorld.WALL_HEIGHT + 1, n4 - 1), this.classicPlotWorld.WALL_BLOCK.toPattern());
            queueCoordinator.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), n2, this.classicPlotWorld.WALL_HEIGHT + 1, n3 + 1), Location.at(this.classicPlotWorld.getWorldName(), n2, this.classicPlotWorld.WALL_HEIGHT + 1, n4 - 1), this.classicPlotWorld.WALL_BLOCK.toPattern());
        }
        return !bl || queueCoordinator.enqueue();
    }

    @Override
    public boolean createRoadSouth(@NonNull Plot plot, @Nullable QueueCoordinator queueCoordinator) {
        Location location = this.getPlotBottomLocAbs(plot.getId());
        Location location2 = this.getPlotTopLocAbs(plot.getId());
        int n = location2.getZ() + 1;
        int n2 = n + this.classicPlotWorld.ROAD_WIDTH - 1;
        int n3 = location.getX() - 2;
        int n4 = location2.getX() + 2;
        boolean bl = false;
        if (queueCoordinator == null) {
            queueCoordinator = this.classicPlotWorld.getQueue();
            bl = true;
        }
        queueCoordinator.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), n3 + 1, this.classicPlotWorld.schematicStartHeight() + 1, n), Location.at(this.classicPlotWorld.getWorldName(), n4 - 1, this.classicPlotWorld.getMaxGenHeight(), n2), BlockTypes.AIR.getDefaultState());
        if (this.classicPlotWorld.PLOT_BEDROCK) {
            queueCoordinator.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), n3 + 1, this.classicPlotWorld.getMinGenHeight(), n), Location.at(this.classicPlotWorld.getWorldName(), n4 - 1, this.classicPlotWorld.getMinGenHeight(), n2), BlockTypes.BEDROCK.getDefaultState());
        }
        int n5 = this.classicPlotWorld.PLOT_BEDROCK ? 1 : 0;
        queueCoordinator.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), n3 + 1, this.classicPlotWorld.getMinGenHeight() + n5, n), Location.at(this.classicPlotWorld.getWorldName(), n4 - 1, this.classicPlotWorld.WALL_HEIGHT, n), this.classicPlotWorld.WALL_FILLING.toPattern());
        queueCoordinator.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), n3 + 1, this.classicPlotWorld.getMinGenHeight() + n5, n2), Location.at(this.classicPlotWorld.getWorldName(), n4 - 1, this.classicPlotWorld.WALL_HEIGHT, n2), this.classicPlotWorld.WALL_FILLING.toPattern());
        queueCoordinator.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), n3 + 1, this.classicPlotWorld.getMinGenHeight() + n5, n + 1), Location.at(this.classicPlotWorld.getWorldName(), n4 - 1, this.classicPlotWorld.ROAD_HEIGHT, n2 - 1), this.classicPlotWorld.ROAD_BLOCK.toPattern());
        if (this.classicPlotWorld.PLACE_TOP_BLOCK) {
            queueCoordinator.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), n3 + 1, this.classicPlotWorld.WALL_HEIGHT + 1, n), Location.at(this.classicPlotWorld.getWorldName(), n4 - 1, this.classicPlotWorld.WALL_HEIGHT + 1, n), this.classicPlotWorld.WALL_BLOCK.toPattern());
            queueCoordinator.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), n3 + 1, this.classicPlotWorld.WALL_HEIGHT + 1, n2), Location.at(this.classicPlotWorld.getWorldName(), n4 - 1, this.classicPlotWorld.WALL_HEIGHT + 1, n2), this.classicPlotWorld.WALL_BLOCK.toPattern());
        }
        return !bl || queueCoordinator.enqueue();
    }

    @Override
    public boolean createRoadSouthEast(@NonNull Plot plot, @Nullable QueueCoordinator queueCoordinator) {
        Location location = this.getPlotTopLocAbs(plot.getId());
        int n = location.getX() + 1;
        int n2 = n + this.classicPlotWorld.ROAD_WIDTH - 1;
        int n3 = location.getZ() + 1;
        int n4 = n3 + this.classicPlotWorld.ROAD_WIDTH - 1;
        boolean bl = false;
        if (queueCoordinator == null) {
            queueCoordinator = this.classicPlotWorld.getQueue();
            bl = true;
        }
        queueCoordinator.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), n + 1, this.classicPlotWorld.ROAD_HEIGHT + 1, n3 + 1), Location.at(this.classicPlotWorld.getWorldName(), n2 - 1, this.classicPlotWorld.getMaxGenHeight(), n4 - 1), BlockTypes.AIR.getDefaultState());
        if (this.classicPlotWorld.PLOT_BEDROCK) {
            queueCoordinator.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), n + 1, this.classicPlotWorld.getMinGenHeight(), n3 + 1), Location.at(this.classicPlotWorld.getWorldName(), n2 - 1, this.classicPlotWorld.getMinGenHeight(), n4 - 1), BlockTypes.BEDROCK.getDefaultState());
        }
        int n5 = this.classicPlotWorld.PLOT_BEDROCK ? 1 : 0;
        queueCoordinator.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), n + 1, this.classicPlotWorld.getMinGenHeight() + n5, n3 + 1), Location.at(this.classicPlotWorld.getWorldName(), n2 - 1, this.classicPlotWorld.ROAD_HEIGHT, n4 - 1), this.classicPlotWorld.ROAD_BLOCK.toPattern());
        return !bl || queueCoordinator.enqueue();
    }

    @Override
    public boolean removeRoadEast(@NonNull Plot plot, @Nullable QueueCoordinator queueCoordinator) {
        Location location = this.getPlotBottomLocAbs(plot.getId());
        Location location2 = this.getPlotTopLocAbs(plot.getId());
        int n = location2.getX() + 1;
        int n2 = n + this.classicPlotWorld.ROAD_WIDTH - 1;
        int n3 = location.getZ() - 1;
        int n4 = location2.getZ() + 1;
        boolean bl = false;
        if (queueCoordinator == null) {
            queueCoordinator = this.classicPlotWorld.getQueue();
            bl = true;
        }
        queueCoordinator.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), n, this.classicPlotWorld.schematicStartHeight() + 1, n3), Location.at(this.classicPlotWorld.getWorldName(), n2, this.classicPlotWorld.getMaxGenHeight(), n4), BlockTypes.AIR.getDefaultState());
        int n5 = this.classicPlotWorld.PLOT_BEDROCK ? 1 : 0;
        queueCoordinator.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), n, this.classicPlotWorld.getMinGenHeight() + n5, n3 + 1), Location.at(this.classicPlotWorld.getWorldName(), n2, this.classicPlotWorld.PLOT_HEIGHT - 1, n4 - 1), this.classicPlotWorld.MAIN_BLOCK.toPattern());
        queueCoordinator.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), n, this.classicPlotWorld.PLOT_HEIGHT, n3 + 1), Location.at(this.classicPlotWorld.getWorldName(), n2, this.classicPlotWorld.PLOT_HEIGHT, n4 - 1), this.classicPlotWorld.TOP_BLOCK.toPattern());
        return !bl || queueCoordinator.enqueue();
    }

    @Override
    public boolean removeRoadSouth(@NonNull Plot plot, @Nullable QueueCoordinator queueCoordinator) {
        Location location = this.getPlotBottomLocAbs(plot.getId());
        Location location2 = this.getPlotTopLocAbs(plot.getId());
        int n = location2.getZ() + 1;
        int n2 = n + this.classicPlotWorld.ROAD_WIDTH - 1;
        int n3 = location.getX() - 1;
        int n4 = location2.getX() + 1;
        boolean bl = false;
        if (queueCoordinator == null) {
            queueCoordinator = this.classicPlotWorld.getQueue();
            bl = true;
        }
        queueCoordinator.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), n3, this.classicPlotWorld.schematicStartHeight() + 1, n), Location.at(this.classicPlotWorld.getWorldName(), n4, this.classicPlotWorld.getMaxGenHeight(), n2), BlockTypes.AIR.getDefaultState());
        int n5 = this.classicPlotWorld.PLOT_BEDROCK ? 1 : 0;
        queueCoordinator.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), n3 + 1, this.classicPlotWorld.getMinGenHeight() + n5, n), Location.at(this.classicPlotWorld.getWorldName(), n4 - 1, this.classicPlotWorld.PLOT_HEIGHT - 1, n2), this.classicPlotWorld.MAIN_BLOCK.toPattern());
        queueCoordinator.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), n3 + 1, this.classicPlotWorld.PLOT_HEIGHT, n), Location.at(this.classicPlotWorld.getWorldName(), n4 - 1, this.classicPlotWorld.PLOT_HEIGHT, n2), this.classicPlotWorld.TOP_BLOCK.toPattern());
        return !bl || queueCoordinator.enqueue();
    }

    @Override
    public boolean removeRoadSouthEast(@NonNull Plot plot, @Nullable QueueCoordinator queueCoordinator) {
        Location location = this.getPlotTopLocAbs(plot.getId());
        int n = location.getX() + 1;
        int n2 = n + this.classicPlotWorld.ROAD_WIDTH - 1;
        int n3 = location.getZ() + 1;
        int n4 = n3 + this.classicPlotWorld.ROAD_WIDTH - 1;
        boolean bl = false;
        if (queueCoordinator == null) {
            queueCoordinator = this.classicPlotWorld.getQueue();
            bl = true;
        }
        queueCoordinator.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), n, this.classicPlotWorld.schematicStartHeight() + 1, n3), Location.at(this.classicPlotWorld.getWorldName(), n2, this.classicPlotWorld.getMaxGenHeight(), n4), BlockTypes.AIR.getDefaultState());
        int n5 = this.classicPlotWorld.PLOT_BEDROCK ? 1 : 0;
        queueCoordinator.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), n, this.classicPlotWorld.getMinGenHeight() + n5, n3), Location.at(this.classicPlotWorld.getWorldName(), n2, this.classicPlotWorld.PLOT_HEIGHT - 1, n4), this.classicPlotWorld.MAIN_BLOCK.toPattern());
        queueCoordinator.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), n, this.classicPlotWorld.PLOT_HEIGHT, n3), Location.at(this.classicPlotWorld.getWorldName(), n2, this.classicPlotWorld.PLOT_HEIGHT, n4), this.classicPlotWorld.TOP_BLOCK.toPattern());
        return !bl || queueCoordinator.enqueue();
    }

    @Override
    public boolean finishPlotMerge(@NonNull List<PlotId> list, @Nullable QueueCoordinator queueCoordinator) {
        BlockBucket blockBucket = this.classicPlotWorld.CLAIMED_WALL_BLOCK;
        if (!(!this.classicPlotWorld.PLACE_TOP_BLOCK || blockBucket.isAir() && blockBucket.equals(this.classicPlotWorld.WALL_BLOCK))) {
            for (PlotId object : list) {
                this.setWall(object, blockBucket.toPattern(), null, queueCoordinator);
            }
        }
        if (Settings.General.MERGE_REPLACE_WALL) {
            BlockBucket blockBucket2 = this.classicPlotWorld.WALL_FILLING;
            for (PlotId plotId : list) {
                this.setWallFilling(plotId, blockBucket2.toPattern(), null, queueCoordinator);
            }
        }
        return true;
    }

    @Override
    public boolean finishPlotUnlink(@NonNull List<PlotId> list, @Nullable QueueCoordinator queueCoordinator) {
        BlockBucket blockBucket = this.classicPlotWorld.CLAIMED_WALL_BLOCK;
        if (!(!this.classicPlotWorld.PLACE_TOP_BLOCK || blockBucket.isAir() && blockBucket.equals(this.classicPlotWorld.WALL_BLOCK))) {
            for (PlotId plotId : list) {
                this.setWall(plotId, blockBucket.toPattern(), null, queueCoordinator);
            }
        }
        return true;
    }

    @Override
    public boolean startPlotMerge(@NonNull List<PlotId> list, @Nullable QueueCoordinator queueCoordinator) {
        return true;
    }

    @Override
    public boolean startPlotUnlink(@NonNull List<PlotId> list, @Nullable QueueCoordinator queueCoordinator) {
        return true;
    }

    @Override
    public boolean claimPlot(@NonNull Plot plot, @Nullable QueueCoordinator queueCoordinator) {
        BlockBucket blockBucket = this.classicPlotWorld.CLAIMED_WALL_BLOCK;
        if (!(!this.classicPlotWorld.PLACE_TOP_BLOCK || blockBucket.isAir() && blockBucket.equals(this.classicPlotWorld.WALL_BLOCK))) {
            return this.setWall(plot.getId(), blockBucket.toPattern(), null, queueCoordinator);
        }
        return true;
    }

    @Override
    public String[] getPlotComponents(@NonNull PlotId plotId) {
        return ClassicPlotManagerComponent.stringValues();
    }

    @Override
    public Location getSignLoc(@NonNull Plot plot) {
        plot = plot.getBasePlot(false);
        Location location = plot.getBottomAbs();
        return Location.at(this.classicPlotWorld.getWorldName(), location.getX() - 1, this.classicPlotWorld.ROAD_HEIGHT + 1, location.getZ() - 2);
    }
}

