/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.generator;

import com.plotsquared.core.annotation.Nullable;
import com.plotsquared.core.configuration.ConfigurationNode;
import com.plotsquared.core.configuration.ConfigurationSection;
import com.plotsquared.core.configuration.ConfigurationUtil;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.configuration.file.YamlConfiguration;
import com.plotsquared.core.generator.IndependentPlotGenerator;
import com.plotsquared.core.generator.SquarePlotWorld;
import com.plotsquared.core.inject.annotations.WorldConfig;
import com.plotsquared.core.plot.BlockBucket;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.queue.GlobalBlockQueue;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.world.block.BlockTypes;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class ClassicPlotWorld
extends SquarePlotWorld {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + ClassicPlotWorld.class.getSimpleName()));
    public int ROAD_HEIGHT = 62;
    public int PLOT_HEIGHT = 62;
    public int WALL_HEIGHT = 62;
    public BlockBucket MAIN_BLOCK = new BlockBucket(BlockTypes.STONE);
    public BlockBucket TOP_BLOCK = new BlockBucket(BlockTypes.GRASS_BLOCK);
    public BlockBucket WALL_BLOCK = new BlockBucket(BlockTypes.STONE_SLAB);
    public BlockBucket CLAIMED_WALL_BLOCK = new BlockBucket(BlockTypes.SANDSTONE_SLAB);
    public BlockBucket WALL_FILLING = new BlockBucket(BlockTypes.STONE);
    public BlockBucket ROAD_BLOCK = new BlockBucket(BlockTypes.QUARTZ_BLOCK);
    public boolean PLOT_BEDROCK = true;
    public boolean PLACE_TOP_BLOCK = true;

    public ClassicPlotWorld(@NonNull String string, @Nullable String string2, @NonNull IndependentPlotGenerator independentPlotGenerator, @Nullable PlotId plotId, @Nullable PlotId plotId2, @WorldConfig @NonNull YamlConfiguration yamlConfiguration, @NonNull GlobalBlockQueue globalBlockQueue) {
        super(string, string2, independentPlotGenerator, plotId, plotId2, yamlConfiguration, globalBlockQueue);
    }

    private static BlockBucket createCheckedBlockBucket(String string, BlockBucket blockBucket) {
        BlockBucket blockBucket2 = new BlockBucket(string);
        Pattern pattern = null;
        try {
            pattern = blockBucket2.toPattern();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (pattern == null) {
            LOGGER.error("Failed to parse pattern '{}', check your worlds.yml", (Object)string);
            LOGGER.error("Falling back to {}", (Object)blockBucket);
            return blockBucket;
        }
        return blockBucket2;
    }

    @Override
    public @NonNull ConfigurationNode[] getSettingNodes() {
        return new ConfigurationNode[]{new ConfigurationNode("plot.height", this.PLOT_HEIGHT, TranslatableCaption.of("setup.plot_height"), ConfigurationUtil.INTEGER), new ConfigurationNode("plot.size", this.PLOT_WIDTH, TranslatableCaption.of("setup.plot_width"), ConfigurationUtil.INTEGER), new ConfigurationNode("plot.filling", this.MAIN_BLOCK, TranslatableCaption.of("setup.plot_block"), ConfigurationUtil.BLOCK_BUCKET), new ConfigurationNode("wall.place_top_block", this.PLACE_TOP_BLOCK, TranslatableCaption.of("setup.top_block_boolean"), ConfigurationUtil.BOOLEAN), new ConfigurationNode("plot.floor", this.TOP_BLOCK, TranslatableCaption.of("setup.plot_block_floor"), ConfigurationUtil.BLOCK_BUCKET), new ConfigurationNode("wall.block", this.WALL_BLOCK, TranslatableCaption.of("setup.top_wall_block"), ConfigurationUtil.BLOCK_BUCKET), new ConfigurationNode("wall.block_claimed", this.CLAIMED_WALL_BLOCK, TranslatableCaption.of("setup.wall_block_claimed"), ConfigurationUtil.BLOCK_BUCKET), new ConfigurationNode("road.width", this.ROAD_WIDTH, TranslatableCaption.of("setup.road_width"), ConfigurationUtil.INTEGER), new ConfigurationNode("road.height", this.ROAD_HEIGHT, TranslatableCaption.of("setup.road_height"), ConfigurationUtil.INTEGER), new ConfigurationNode("road.block", this.ROAD_BLOCK, TranslatableCaption.of("setup.road_block"), ConfigurationUtil.BLOCK_BUCKET), new ConfigurationNode("wall.filling", this.WALL_FILLING, TranslatableCaption.of("setup.wall_filling_block"), ConfigurationUtil.BLOCK_BUCKET), new ConfigurationNode("wall.height", this.WALL_HEIGHT, TranslatableCaption.of("setup.wall_height"), ConfigurationUtil.INTEGER), new ConfigurationNode("plot.bedrock", this.PLOT_BEDROCK, TranslatableCaption.of("setup.bedrock_boolean"), ConfigurationUtil.BOOLEAN)};
    }

    @Override
    public void loadConfiguration(ConfigurationSection configurationSection) {
        super.loadConfiguration(configurationSection);
        this.PLOT_BEDROCK = configurationSection.getBoolean("plot.bedrock");
        this.PLOT_HEIGHT = Math.min(this.getMaxGenHeight(), configurationSection.getInt("plot.height"));
        this.MAIN_BLOCK = ClassicPlotWorld.createCheckedBlockBucket(configurationSection.getString("plot.filling"), this.MAIN_BLOCK);
        this.TOP_BLOCK = ClassicPlotWorld.createCheckedBlockBucket(configurationSection.getString("plot.floor"), this.TOP_BLOCK);
        this.WALL_BLOCK = ClassicPlotWorld.createCheckedBlockBucket(configurationSection.getString("wall.block"), this.WALL_BLOCK);
        this.ROAD_HEIGHT = Math.min(this.getMaxGenHeight(), configurationSection.getInt("road.height"));
        this.ROAD_BLOCK = ClassicPlotWorld.createCheckedBlockBucket(configurationSection.getString("road.block"), this.ROAD_BLOCK);
        this.WALL_FILLING = ClassicPlotWorld.createCheckedBlockBucket(configurationSection.getString("wall.filling"), this.WALL_FILLING);
        this.PLACE_TOP_BLOCK = configurationSection.getBoolean("wall.place_top_block");
        this.WALL_HEIGHT = Math.min(this.getMaxGenHeight() - (this.PLACE_TOP_BLOCK ? 1 : 0), configurationSection.getInt("wall.height"));
        this.CLAIMED_WALL_BLOCK = ClassicPlotWorld.createCheckedBlockBucket(configurationSection.getString("wall.block_claimed"), this.CLAIMED_WALL_BLOCK);
    }

    int schematicStartHeight() {
        int n = Math.min(this.PLOT_HEIGHT, this.ROAD_HEIGHT);
        if (!Settings.Schematics.USE_WALL_IN_ROAD_SCHEM_HEIGHT) {
            return n;
        }
        return Math.min(this.WALL_HEIGHT, n);
    }
}

