/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.generator;

import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.events.PlotFlagAddEvent;
import com.plotsquared.core.events.Result;
import com.plotsquared.core.generator.HybridPlotWorld;
import com.plotsquared.core.listener.WEExtent;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotAreaType;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.PlotManager;
import com.plotsquared.core.plot.expiration.PlotAnalysis;
import com.plotsquared.core.plot.flag.GlobalFlagContainer;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.plot.flag.implementations.AnalysisFlag;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.queue.BlockArrayCacheScopedQueueCoordinator;
import com.plotsquared.core.queue.GlobalBlockQueue;
import com.plotsquared.core.queue.QueueCoordinator;
import com.plotsquared.core.util.ChunkManager;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.RegionManager;
import com.plotsquared.core.util.RegionUtil;
import com.plotsquared.core.util.SchematicHandler;
import com.plotsquared.core.util.WorldUtil;
import com.plotsquared.core.util.task.RunnableVal;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.core.util.task.TaskTime;
import com.plotsquared.google.Inject;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class HybridUtils {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + HybridUtils.class.getSimpleName()));
    private static final BlockState AIR = BlockTypes.AIR.getDefaultState();
    @Deprecated(forRemoval=true, since="7.0.0")
    public static HybridUtils manager;
    public static Set<BlockVector2> regions;
    public static int height;
    public static Set<BlockVector2> chunks;
    public static PlotArea area;
    public static boolean UPDATE;
    private final PlotAreaManager plotAreaManager;
    private final ChunkManager chunkManager;
    private final GlobalBlockQueue blockQueue;
    private final WorldUtil worldUtil;
    private final SchematicHandler schematicHandler;
    private final EventDispatcher eventDispatcher;

    @Inject
    public HybridUtils(@NonNull PlotAreaManager plotAreaManager, @NonNull ChunkManager chunkManager, @NonNull GlobalBlockQueue globalBlockQueue, @NonNull WorldUtil worldUtil, @NonNull SchematicHandler schematicHandler, @NonNull EventDispatcher eventDispatcher) {
        this.plotAreaManager = plotAreaManager;
        this.chunkManager = chunkManager;
        this.blockQueue = globalBlockQueue;
        this.worldUtil = worldUtil;
        this.schematicHandler = schematicHandler;
        this.eventDispatcher = eventDispatcher;
    }

    public void regeneratePlotWalls(PlotArea plotArea) {
        PlotManager plotManager = plotArea.getPlotManager();
        plotManager.regenerateAllPlotWalls(null);
    }

    public void analyzeRegion(String string, CuboidRegion cuboidRegion, RunnableVal<PlotAnalysis> runnableVal) {
        TaskManager.runTaskAsync(() -> {
            PlotArea plotArea = this.plotAreaManager.getPlotArea(string, null);
            if (!(plotArea instanceof HybridPlotWorld)) {
                return;
            }
            HybridPlotWorld hybridPlotWorld = (HybridPlotWorld)plotArea;
            BlockVector3 blockVector3 = cuboidRegion.getMinimumPoint();
            BlockVector3 blockVector32 = cuboidRegion.getMaximumPoint();
            int n = blockVector3.getX();
            int n2 = blockVector3.getZ();
            int n3 = blockVector32.getX();
            int n4 = blockVector32.getZ();
            int n5 = n >> 4;
            int n6 = n2 >> 4;
            int n7 = n3 >> 4;
            int n8 = n4 >> 4;
            int n9 = n3 - n + 1;
            int n10 = n4 - n2 + 1;
            int n11 = plotArea.getMaxGenHeight() - plotArea.getMinGenHeight() + 1;
            int n12 = plotArea.getMinGenHeight();
            BlockState[][][] blockStateArray = new BlockState[n11][n9][n10];
            BlockArrayCacheScopedQueueCoordinator blockArrayCacheScopedQueueCoordinator = new BlockArrayCacheScopedQueueCoordinator(Location.at("", cuboidRegion.getMinimumPoint().withY(hybridPlotWorld.getMinGenHeight())), Location.at("", cuboidRegion.getMaximumPoint().withY(hybridPlotWorld.getMaxGenHeight())));
            cuboidRegion.getChunks().forEach(blockVector2 -> {
                int n3 = blockVector2.getX() - n5;
                int n4 = blockVector2.getZ() - n6;
                blockArrayCacheScopedQueueCoordinator.setOffsetX(n3 << 4);
                blockArrayCacheScopedQueueCoordinator.setOffsetZ(n4 << 4);
                hybridPlotWorld.getGenerator().generateChunk(blockArrayCacheScopedQueueCoordinator, hybridPlotWorld, false);
            });
            BlockState[][][] blockStateArray2 = blockArrayCacheScopedQueueCoordinator.getBlockStates();
            QueueCoordinator queueCoordinator = plotArea.getQueue();
            queueCoordinator.addReadChunks(cuboidRegion.getChunks());
            queueCoordinator.setChunkConsumer(blockVector2 -> {
                int n11 = blockVector2.getX();
                int n12 = blockVector2.getZ();
                int n13 = n11 == n5 ? n & 0xF : 0;
                int n14 = n12 == n6 ? n2 & 0xF : 0;
                int n15 = n11 == n7 ? n3 & 0xF : 15;
                int n16 = n12 == n8 ? n4 & 0xF : 15;
                int n17 = n11 << 4;
                int n18 = n12 << 4;
                int n19 = n17 - n;
                int n20 = n18 - n2;
                for (int i = n13; i <= n15; ++i) {
                    int n21 = n17 + i;
                    for (int j = n14; j <= n16; ++j) {
                        int n22 = n18 + j;
                        for (int k = 0; k < n11; ++k) {
                            int n23 = k + n12;
                            BlockState blockState = queueCoordinator.getBlock(n21, n23, n22);
                            if (blockState == null) {
                                blockState = AIR;
                            }
                            int n24 = n19 + i;
                            int n25 = n20 + j;
                            blockStateArray[k][n24][n25] = blockState;
                        }
                    }
                }
            });
            Runnable runnable = () -> {
                int n4 = n9 * n10;
                int[] nArray = new int[n4];
                int[] nArray2 = new int[n4];
                int[] nArray3 = new int[n4];
                int[] nArray4 = new int[n4];
                int[] nArray5 = new int[n4];
                int n5 = 0;
                for (int i = 0; i < n9; ++i) {
                    for (int j = 0; j < n10; ++j) {
                        HashSet<BlockType> hashSet = new HashSet<BlockType>();
                        for (int k = 0; k < n11; ++k) {
                            BlockState blockState = blockStateArray2[k][i][j];
                            BlockState blockState2 = blockStateArray[k][i][j];
                            if (blockState2 == null) {
                                throw new NullPointerException(String.format("\"now\" block null attempting to perform plot analysis. Indexes: x=%d of %d, yIndex=%d of %d, z=%d of %d", i, n9, k, n11, j, n10));
                            }
                            if (!(blockState2.equals((Object)blockState) || blockState == null && blockState2.getBlockType().equals((Object)BlockTypes.AIR))) {
                                int n6 = n5;
                                nArray[n6] = nArray[n6] + 1;
                            }
                            if (blockState2.getBlockType().getMaterial().isAir()) {
                                int n7 = n5;
                                nArray4[n7] = nArray4[n7] + 1;
                                continue;
                            }
                            if (i > 0 && j > 0 && k > 0 && i < n9 - 1 && j < n10 - 1 && k < n11 - 1) {
                                if (blockStateArray[k - 1][i][j].getBlockType().getMaterial().isAir()) {
                                    int n8 = n5;
                                    nArray2[n8] = nArray2[n8] + 1;
                                }
                                if (blockStateArray[k][i - 1][j].getBlockType().getMaterial().isAir()) {
                                    int n9 = n5;
                                    nArray2[n9] = nArray2[n9] + 1;
                                }
                                if (blockStateArray[k][i][j - 1].getBlockType().getMaterial().isAir()) {
                                    int n10 = n5;
                                    nArray2[n10] = nArray2[n10] + 1;
                                }
                                if (blockStateArray[k + 1][i][j].getBlockType().getMaterial().isAir()) {
                                    int n11 = n5;
                                    nArray2[n11] = nArray2[n11] + 1;
                                }
                                if (blockStateArray[k][i + 1][j].getBlockType().getMaterial().isAir()) {
                                    int n12 = n5;
                                    nArray2[n12] = nArray2[n12] + 1;
                                }
                                if (blockStateArray[k][i][j + 1].getBlockType().getMaterial().isAir()) {
                                    int n13 = n5;
                                    nArray2[n13] = nArray2[n13] + 1;
                                }
                            }
                            if (!blockState2.equals((Object)blockState2.getBlockType().getDefaultState())) {
                                int n14 = n5;
                                nArray3[n14] = nArray3[n14] + 1;
                            }
                            hashSet.add(blockState2.getBlockType());
                        }
                        nArray5[n5] = hashSet.size();
                        ++n5;
                    }
                }
                PlotAnalysis plotAnalysis = new PlotAnalysis();
                plotAnalysis.changes = (int)(MathMan.getMean(nArray) * 100.0);
                plotAnalysis.faces = (int)(MathMan.getMean(nArray2) * 100.0);
                plotAnalysis.data = (int)(MathMan.getMean(nArray3) * 100.0);
                plotAnalysis.air = (int)(MathMan.getMean(nArray4) * 100.0);
                plotAnalysis.variety = (int)(MathMan.getMean(nArray5) * 100.0);
                plotAnalysis.changes_sd = (int)(MathMan.getSD(nArray, plotAnalysis.changes) * 100.0);
                plotAnalysis.faces_sd = (int)(MathMan.getSD(nArray2, plotAnalysis.faces) * 100.0);
                plotAnalysis.data_sd = (int)(MathMan.getSD(nArray3, plotAnalysis.data) * 100.0);
                plotAnalysis.air_sd = (int)(MathMan.getSD(nArray4, plotAnalysis.air) * 100.0);
                plotAnalysis.variety_sd = (int)(MathMan.getSD(nArray5, plotAnalysis.variety) * 100.0);
                runnableVal.value = plotAnalysis;
                runnableVal.run();
            };
            queueCoordinator.setCompleteTask(runnable);
            queueCoordinator.enqueue();
        });
    }

    public void analyzePlot(final Plot plot, final RunnableVal<PlotAnalysis> runnableVal) {
        final ArrayDeque<CuboidRegion> arrayDeque = new ArrayDeque<CuboidRegion>(plot.getRegions());
        final ArrayList arrayList = new ArrayList();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (arrayDeque.isEmpty()) {
                    PlotAnalysis plotAnalysis2;
                    if (!arrayList.isEmpty()) {
                        runnableVal.value = new PlotAnalysis();
                        for (PlotAnalysis plotAnalysis2 : arrayList) {
                            ((PlotAnalysis)runnableVal.value).air += plotAnalysis2.air;
                            ((PlotAnalysis)runnableVal.value).air_sd += plotAnalysis2.air_sd;
                            ((PlotAnalysis)runnableVal.value).changes += plotAnalysis2.changes;
                            ((PlotAnalysis)runnableVal.value).changes_sd += plotAnalysis2.changes_sd;
                            ((PlotAnalysis)runnableVal.value).data += plotAnalysis2.data;
                            ((PlotAnalysis)runnableVal.value).data_sd += plotAnalysis2.data_sd;
                            ((PlotAnalysis)runnableVal.value).faces += plotAnalysis2.faces;
                            ((PlotAnalysis)runnableVal.value).faces_sd += plotAnalysis2.faces_sd;
                            ((PlotAnalysis)runnableVal.value).variety += plotAnalysis2.variety;
                            ((PlotAnalysis)runnableVal.value).variety_sd += plotAnalysis2.variety_sd;
                        }
                        ((PlotAnalysis)runnableVal.value).air /= arrayList.size();
                        ((PlotAnalysis)runnableVal.value).air_sd /= arrayList.size();
                        ((PlotAnalysis)runnableVal.value).changes /= arrayList.size();
                        ((PlotAnalysis)runnableVal.value).changes_sd /= arrayList.size();
                        ((PlotAnalysis)runnableVal.value).data /= arrayList.size();
                        ((PlotAnalysis)runnableVal.value).data_sd /= arrayList.size();
                        ((PlotAnalysis)runnableVal.value).faces /= arrayList.size();
                        ((PlotAnalysis)runnableVal.value).faces_sd /= arrayList.size();
                        ((PlotAnalysis)runnableVal.value).variety /= arrayList.size();
                        ((PlotAnalysis)runnableVal.value).variety_sd /= arrayList.size();
                    } else {
                        runnableVal.value = arrayList.get(0);
                    }
                    ArrayList arrayList2 = new ArrayList();
                    arrayList2.add(((PlotAnalysis)runnableVal.value).changes);
                    arrayList2.add(((PlotAnalysis)runnableVal.value).faces);
                    arrayList2.add(((PlotAnalysis)runnableVal.value).data);
                    arrayList2.add(((PlotAnalysis)runnableVal.value).air);
                    arrayList2.add(((PlotAnalysis)runnableVal.value).variety);
                    arrayList2.add(((PlotAnalysis)runnableVal.value).changes_sd);
                    arrayList2.add(((PlotAnalysis)runnableVal.value).faces_sd);
                    arrayList2.add(((PlotAnalysis)runnableVal.value).data_sd);
                    arrayList2.add(((PlotAnalysis)runnableVal.value).air_sd);
                    arrayList2.add(((PlotAnalysis)runnableVal.value).variety_sd);
                    plotAnalysis2 = GlobalFlagContainer.getInstance().getFlag(AnalysisFlag.class).createFlagInstance(arrayList2);
                    PlotFlagAddEvent plotFlagAddEvent = HybridUtils.this.eventDispatcher.callFlagAdd((PlotFlag<?, ?>)((Object)plotAnalysis2), plot);
                    if (plotFlagAddEvent.getEventResult() == Result.DENY) {
                        return;
                    }
                    plot.setFlag(plotFlagAddEvent.getFlag());
                    TaskManager.runTask(runnableVal);
                    return;
                }
                CuboidRegion cuboidRegion = (CuboidRegion)arrayDeque.poll();
                final 1 var2_4 = this;
                HybridUtils.this.analyzeRegion(plot.getWorldName(), cuboidRegion, new RunnableVal<PlotAnalysis>(){

                    @Override
                    public void run(PlotAnalysis plotAnalysis) {
                        arrayList.add(plotAnalysis);
                        TaskManager.runTaskLater(var2_4, TaskTime.ticks(1L));
                    }
                });
            }
        };
        runnable.run();
    }

    public final ArrayList<BlockVector2> getChunks(BlockVector2 blockVector2) {
        ArrayList<BlockVector2> arrayList = new ArrayList<BlockVector2>();
        int n = blockVector2.getX() << 5;
        int n2 = blockVector2.getZ() << 5;
        for (int i = n; i < n + 32; ++i) {
            for (int j = n2; j < n2 + 32; ++j) {
                arrayList.add(BlockVector2.at((int)i, (int)j));
            }
        }
        return arrayList;
    }

    public boolean scheduleRoadUpdate(PlotArea plotArea, int n) {
        if (UPDATE) {
            return false;
        }
        UPDATE = true;
        Set<BlockVector2> set = this.worldUtil.getChunkChunks(plotArea.getWorldName());
        return this.scheduleRoadUpdate(plotArea, set, n, new LinkedHashSet<BlockVector2>());
    }

    public boolean scheduleSingleRegionRoadUpdate(Plot plot, int n) {
        if (UPDATE) {
            return false;
        }
        UPDATE = true;
        HashSet<BlockVector2> hashSet = new HashSet<BlockVector2>();
        hashSet.add(RegionManager.getRegion(plot.getCenterSynchronous()));
        return this.scheduleRoadUpdate(plot.getArea(), hashSet, n, new LinkedHashSet<BlockVector2>());
    }

    public boolean scheduleRoadUpdate(final PlotArea plotArea, final Set<BlockVector2> set, final int n, final Set<BlockVector2> set2) {
        regions = set;
        area = plotArea;
        height = n;
        chunks = set2;
        final int n2 = 1024 * set.size() + set2.size();
        final AtomicInteger atomicInteger = new AtomicInteger(0);
        TaskManager.runTask(new Runnable(){

            @Override
            public void run() {
                if (!UPDATE) {
                    Iterator iterator = set2.iterator();
                    QueueCoordinator queueCoordinator = HybridUtils.this.blockQueue.getNewQueue(HybridUtils.this.worldUtil.getWeWorld(plotArea.getWorldName()));
                    while (iterator.hasNext()) {
                        BlockVector2 blockVector2 = (BlockVector2)iterator.next();
                        iterator.remove();
                        boolean bl = HybridUtils.this.regenerateRoad(plotArea, blockVector2, n, queueCoordinator);
                        if (bl) continue;
                        LOGGER.info("Failed to regenerate roads in chunk {}", (Object)blockVector2);
                    }
                    queueCoordinator.enqueue();
                    LOGGER.info("Cancelled road task");
                    return;
                }
                atomicInteger.incrementAndGet();
                if (atomicInteger.intValue() % 10 == 0) {
                    LOGGER.info("Progress: {}%", (Object)(100 * (n2 - (set2.size() + 1024 * set.size())) / n2));
                }
                if (regions.isEmpty() && set2.isEmpty()) {
                    HybridUtils.this.regeneratePlotWalls(plotArea);
                    UPDATE = false;
                    LOGGER.info("Finished road conversion");
                } else {
                    2 var1_2 = this;
                    TaskManager.runTaskAsync(() -> {
                        try {
                            if (set2.size() < 64 && !regions.isEmpty()) {
                                Iterator<BlockVector2> iterator = regions.iterator();
                                BlockVector2 blockVector2 = iterator.next();
                                iterator.remove();
                                LOGGER.info("Updating .mcr: {}, {} (approx 1024 chunks)", (Object)blockVector2.getX(), (Object)blockVector2.getZ());
                                LOGGER.info("- Remaining: {}", (Object)regions.size());
                                set2.addAll(HybridUtils.this.getChunks(blockVector2));
                                System.gc();
                            }
                            if (!set2.isEmpty()) {
                                TaskManager.getPlatformImplementation().sync(() -> {
                                    Iterator iterator = set2.iterator();
                                    if (set2.size() >= 32) {
                                        QueueCoordinator queueCoordinator = HybridUtils.this.blockQueue.getNewQueue(HybridUtils.this.worldUtil.getWeWorld(plotArea.getWorldName()));
                                        for (int i = 0; i < 32; ++i) {
                                            BlockVector2 blockVector2 = (BlockVector2)iterator.next();
                                            iterator.remove();
                                            boolean bl = HybridUtils.this.regenerateRoad(plotArea, blockVector2, n, queueCoordinator);
                                            if (bl) continue;
                                            LOGGER.info("Failed to regenerate the road in chunk {}", (Object)blockVector2);
                                        }
                                        queueCoordinator.setCompleteTask(var1_2);
                                        queueCoordinator.enqueue();
                                        return null;
                                    }
                                    QueueCoordinator queueCoordinator = HybridUtils.this.blockQueue.getNewQueue(HybridUtils.this.worldUtil.getWeWorld(plotArea.getWorldName()));
                                    while (!set2.isEmpty()) {
                                        BlockVector2 blockVector2 = (BlockVector2)iterator.next();
                                        iterator.remove();
                                        boolean bl = HybridUtils.this.regenerateRoad(plotArea, blockVector2, n, queueCoordinator);
                                        if (bl) continue;
                                        LOGGER.info("Failed to regenerate road in chunk {}", (Object)blockVector2);
                                    }
                                    queueCoordinator.setCompleteTask(var1_2);
                                    queueCoordinator.enqueue();
                                    return null;
                                });
                                return;
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            Iterator<BlockVector2> iterator = regions.iterator();
                            BlockVector2 blockVector2 = iterator.next();
                            iterator.remove();
                            LOGGER.error("Error! Could not update '{}/region/r.{}.{}.mca' (Corrupt chunk?)", (Object)plotArea.getWorldHash(), (Object)blockVector2.getX(), (Object)blockVector2.getZ());
                        }
                        TaskManager.runTaskLater(var1_2, TaskTime.seconds(1L));
                    });
                }
            }
        });
        return true;
    }

    public boolean setupRoadSchematic(Plot plot) {
        String string = plot.getWorldName();
        QueueCoordinator queueCoordinator = this.blockQueue.getNewQueue(this.worldUtil.getWeWorld(string));
        Location location = plot.getBottomAbs().subtract(1, 0, 1);
        Location location2 = plot.getTopAbs();
        HybridPlotWorld hybridPlotWorld = (HybridPlotWorld)plot.getArea();
        int n = Settings.Schematics.USE_WALL_IN_ROAD_SCHEM_HEIGHT ? Math.min(hybridPlotWorld.PLOT_HEIGHT, Math.min(hybridPlotWorld.WALL_HEIGHT, hybridPlotWorld.ROAD_HEIGHT)) : hybridPlotWorld.ROAD_HEIGHT;
        int n2 = location.getX() - hybridPlotWorld.ROAD_WIDTH + 1;
        int n3 = location.getZ() + 1;
        int n4 = Settings.Schematics.PASTE_ROAD_ON_TOP ? n : plot.getArea().getMinGenHeight();
        int n5 = location.getX();
        int n6 = location2.getZ();
        int n7 = this.get_ey(hybridPlotWorld, queueCoordinator, n2, n5, n3, n6, n4);
        int n8 = n3 - hybridPlotWorld.ROAD_WIDTH;
        int n9 = n3 - 1;
        int n10 = this.get_ey(hybridPlotWorld, queueCoordinator, n2, n5, n8, n9, n4);
        Set<CuboidRegion> set = Collections.singleton(RegionUtil.createRegion(n2, n5, n4, n7, n3, n6));
        Set<CuboidRegion> set2 = Collections.singleton(RegionUtil.createRegion(n2, n5, n4, n10, n8, n9));
        String string2 = Settings.Paths.SCHEMATICS + File.separator + "GEN_ROAD_SCHEMATIC" + File.separator + plot.getArea().toString() + File.separator;
        this.schematicHandler.getCompoundTag(string, set).whenComplete((compoundTag2, throwable2) -> {
            this.schematicHandler.save((CompoundTag)compoundTag2, string2 + "sideroad.schem");
            this.schematicHandler.getCompoundTag(string, set2).whenComplete((compoundTag, throwable) -> {
                this.schematicHandler.save((CompoundTag)compoundTag, string2 + "intersection.schem");
                hybridPlotWorld.ROAD_SCHEMATIC_ENABLED = true;
                try {
                    hybridPlotWorld.setupSchematics();
                }
                catch (SchematicHandler.UnsupportedFormatException unsupportedFormatException) {
                    unsupportedFormatException.printStackTrace();
                }
            });
        });
        return true;
    }

    private int get_ey(HybridPlotWorld hybridPlotWorld, QueueCoordinator queueCoordinator, int n, int n2, int n3, int n4, int n5) {
        int n6 = n5;
        for (int i = n; i <= n2; ++i) {
            for (int j = n3; j <= n4; ++j) {
                for (int k = n5; k <= hybridPlotWorld.getMaxGenHeight(); ++k) {
                    BlockState blockState;
                    if (k <= n6 || (blockState = queueCoordinator.getBlock(i, k, j)).getBlockType().getMaterial().isAir()) continue;
                    n6 = k;
                }
            }
        }
        return n6;
    }

    public boolean regenerateRoad(PlotArea plotArea, BlockVector2 blockVector2, int n, @Nullable QueueCoordinator queueCoordinator) {
        boolean bl;
        QueueCoordinator queueCoordinator2;
        int n2 = blockVector2.getX() << 4;
        int n3 = blockVector2.getZ() << 4;
        int n4 = n2 + 15;
        int n5 = n3 + 15;
        HybridPlotWorld hybridPlotWorld = (HybridPlotWorld)plotArea;
        if (!hybridPlotWorld.ROAD_SCHEMATIC_ENABLED) {
            return false;
        }
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        if (hybridPlotWorld.getType() == PlotAreaType.PARTIAL) {
            boolean bl2 = plotArea.contains(n2, n3);
            boolean bl3 = plotArea.contains(n4, n5);
            if (!bl2 && !bl3) {
                return false;
            }
            atomicBoolean.set(bl2 ^ bl3);
        }
        PlotManager plotManager = plotArea.getPlotManager();
        PlotId plotId = plotManager.getPlotId(n2, 0, n3);
        PlotId plotId2 = plotManager.getPlotId(n4, 0, n5);
        int n6 = n2 -= hybridPlotWorld.ROAD_OFFSET_X;
        int n7 = n3 -= hybridPlotWorld.ROAD_OFFSET_Z;
        if (queueCoordinator == null) {
            queueCoordinator2 = this.blockQueue.getNewQueue(this.worldUtil.getWeWorld(hybridPlotWorld.getWorldName()));
            bl = true;
        } else {
            queueCoordinator2 = queueCoordinator;
            bl = false;
        }
        if (plotId == null || plotId2 == null || plotId != plotId2) {
            Plot plot;
            if (plotId != null && (plot = plotArea.getPlotAbs(plotId)) != null && plot.hasOwner() && plot.isMerged()) {
                atomicBoolean.set(true);
            }
            if (plotId2 != null && !atomicBoolean.get() && (plot = plotArea.getPlotAbs(plotId2)) != null && plot.hasOwner() && plot.isMerged()) {
                atomicBoolean.set(true);
            }
            short s = hybridPlotWorld.SIZE;
            for (int i = 0; i < 16; ++i) {
                short s2 = (short)((n6 + i) % s);
                for (int j = 0; j < 16; ++j) {
                    int n8;
                    int n9;
                    int n10;
                    boolean bl4;
                    short s3 = (short)((n7 + j) % s);
                    if (s2 < 0) {
                        s2 = (short)(s2 + s);
                    }
                    if (s3 < 0) {
                        s3 = (short)(s3 + s);
                    }
                    if (atomicBoolean.get()) {
                        bl4 = plotManager.getPlotId(n6 + i + hybridPlotWorld.ROAD_OFFSET_X, 1, n7 + j + hybridPlotWorld.ROAD_OFFSET_Z) == null;
                    } else {
                        boolean bl5 = s2 > hybridPlotWorld.PATH_WIDTH_LOWER;
                        n10 = s3 > hybridPlotWorld.PATH_WIDTH_LOWER ? 1 : 0;
                        n9 = s2 < hybridPlotWorld.PATH_WIDTH_UPPER ? 1 : 0;
                        n8 = s3 < hybridPlotWorld.PATH_WIDTH_UPPER ? 1 : 0;
                        boolean bl6 = bl4 = !bl5 || n10 == 0 || n9 == 0 || n8 == 0;
                    }
                    if (!bl4) continue;
                    BaseBlock[] baseBlockArray = hybridPlotWorld.G_SCH.get(MathMan.pair(s2, s3));
                    n10 = hybridPlotWorld.getRoadYStart();
                    n9 = Math.max(n, baseBlockArray.length);
                    for (n8 = 0; n8 < n9; ++n8) {
                        if (n8 > baseBlockArray.length - 1) {
                            queueCoordinator2.setBlock(n6 + i + hybridPlotWorld.ROAD_OFFSET_X, n10 + n8, n7 + j + hybridPlotWorld.ROAD_OFFSET_Z, WEExtent.AIRBASE);
                            continue;
                        }
                        BaseBlock baseBlock = baseBlockArray[n8];
                        if (baseBlock != null) {
                            queueCoordinator2.setBlock(n6 + i + hybridPlotWorld.ROAD_OFFSET_X, n10 + n8, n7 + j + hybridPlotWorld.ROAD_OFFSET_Z, baseBlock);
                            continue;
                        }
                        queueCoordinator2.setBlock(n6 + i + hybridPlotWorld.ROAD_OFFSET_X, n10 + n8, n7 + j + hybridPlotWorld.ROAD_OFFSET_Z, WEExtent.AIRBASE);
                    }
                    BiomeType biomeType = hybridPlotWorld.G_SCH_B.get(MathMan.pair(s2, s3));
                    if (biomeType != null) {
                        queueCoordinator2.setBiome(n6 + i + hybridPlotWorld.ROAD_OFFSET_X, n7 + j + hybridPlotWorld.ROAD_OFFSET_Z, biomeType);
                        continue;
                    }
                    queueCoordinator2.setBiome(n6 + i + hybridPlotWorld.ROAD_OFFSET_X, n7 + j + hybridPlotWorld.ROAD_OFFSET_Z, hybridPlotWorld.getPlotBiome());
                }
            }
            if (bl) {
                queueCoordinator2.enqueue();
            }
            return true;
        }
        return false;
    }

    static {
        chunks = new LinkedHashSet<BlockVector2>();
        UPDATE = false;
    }
}

