/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.http;

import com.plotsquared.core.annotations.annotations.NotNull;
import com.plotsquared.core.annotations.annotations.Nullable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

final class Headers {
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();

    private Headers() {
    }

    static Headers newInstance() {
        return new Headers();
    }

    void addHeader(@NotNull String string, @NotNull String string2) {
        Objects.requireNonNull(string, "Key may not be null");
        Objects.requireNonNull(string2, "Value may not be null");
        string = string.toLowerCase();
        if (this.headers.containsKey(string)) {
            this.headers.get(string).add(string2);
        } else {
            LinkedList<String> linkedList = new LinkedList<String>();
            linkedList.add(string2);
            this.headers.put(string, linkedList);
        }
    }

    @NotNull
    List<String> getHeaders(@NotNull String string) {
        Objects.requireNonNull(string, "Key may not be null");
        List<String> list = this.headers.get(string.toLowerCase());
        if (list == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    @NotNull
    String getHeader(@NotNull String string) {
        return Objects.requireNonNull(this.getOrDefault(string, ""));
    }

    @Nullable
    String getOrDefault(@NotNull String string, @Nullable String string2) {
        List<String> list = this.getHeaders(string);
        if (list.isEmpty()) {
            return string2;
        }
        return list.get(list.size() - 1);
    }

    @NotNull
    Collection<String> getHeaders() {
        return Collections.unmodifiableSet(this.headers.keySet());
    }
}

