/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.listener;

import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.listener.WEExtent;
import com.plotsquared.core.util.WEManager;
import com.plotsquared.core.util.WorldUtil;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.NullExtent;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ProcessedWEExtent
extends AbstractDelegateExtent {
    private final Set<CuboidRegion> mask;
    private final String world;
    private final int max;
    private final WorldUtil worldUtil;
    private final Map<Long, Integer[]> tileEntityCount = new HashMap<Long, Integer[]>();
    int Ecount = 0;
    boolean Eblocked = false;
    private int count;
    private Extent parent;

    public ProcessedWEExtent(String string, Set<CuboidRegion> set, int n, Extent extent, Extent extent2, @NonNull WorldUtil worldUtil) {
        super(extent);
        this.mask = set;
        this.world = string;
        this.worldUtil = worldUtil;
        if (n == -1) {
            n = Integer.MAX_VALUE;
        }
        this.max = n;
        this.count = 0;
        this.parent = extent2;
    }

    private static long getChunkKey(BlockVector3 blockVector3) {
        return (long)(blockVector3.getBlockX() >> 4) & 0xFFFFFFFFL | ((long)(blockVector3.getBlockZ() >> 4) & 0xFFFFFFFFL) << 32;
    }

    public BlockState getBlock(BlockVector3 blockVector3) {
        if (WEManager.maskContains(this.mask, blockVector3.getX(), blockVector3.getY(), blockVector3.getZ())) {
            return super.getBlock(blockVector3);
        }
        return WEExtent.AIRSTATE;
    }

    public BaseBlock getFullBlock(BlockVector3 blockVector3) {
        if (WEManager.maskContains(this.mask, blockVector3.getX(), blockVector3.getY(), blockVector3.getZ())) {
            return super.getFullBlock(blockVector3);
        }
        return WEExtent.AIRBASE;
    }

    public <T extends BlockStateHolder<T>> boolean setBlock(BlockVector3 blockVector3, T t) {
        Object object;
        boolean bl = this.worldUtil.getTileEntityTypes().contains(t.getBlockType());
        if (bl) {
            object = this.tileEntityCount.computeIfAbsent(ProcessedWEExtent.getChunkKey(blockVector3), l -> new Integer[]{this.worldUtil.getTileEntityCount(this.world, BlockVector2.at((int)(blockVector3.getBlockX() >> 4), (int)(blockVector3.getBlockZ() >> 4)))});
            if (object[0] >= Settings.Chunk_Processor.MAX_TILES) {
                return false;
            }
            Integer n = object[0];
            object[0] = object[0] + 1;
        }
        if (WEManager.maskContains(this.mask, blockVector3.getX(), blockVector3.getY(), blockVector3.getZ())) {
            if (this.count++ > this.max) {
                if (this.parent != null) {
                    try {
                        object = AbstractDelegateExtent.class.getDeclaredField("extent");
                        ((Field)object).setAccessible(true);
                        ((Field)object).set(this.parent, new NullExtent());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    this.parent = null;
                }
                return false;
            }
            return super.setBlock(blockVector3, t);
        }
        return !bl;
    }

    public Entity createEntity(Location location, BaseEntity baseEntity) {
        if (this.Eblocked) {
            return null;
        }
        ++this.Ecount;
        if (this.Ecount > Settings.Chunk_Processor.MAX_ENTITIES) {
            this.Eblocked = true;
        }
        if (WEManager.maskContains(this.mask, location.getBlockX(), location.getBlockY(), location.getBlockZ())) {
            return super.createEntity(location, baseEntity);
        }
        return null;
    }

    public boolean setBiome(BlockVector2 blockVector2, BiomeType biomeType) {
        return WEManager.maskContains(this.mask, blockVector2.getX(), blockVector2.getZ()) && super.setBiome(blockVector2, biomeType);
    }
}

